select filtro.nrDeducao,
       filtro.nrAnoDeducao,
       filtro.idAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo,
       filtro.idCancelamento,
       filtro.entidade,
       filtro.exercicio,
       filtro.idpagamentobloqueto,
       filtro.idcreditocontribuinteitem,
       filtro.iddebitoparcelareceita,
       filtro.idParcelamento,
       filtro.idDebitoReceita,
       filtro.idEstornoParcelamento,
       filtro.idTipoCredito
from (select distinct md.idato                                                       as idAto,
                      tc.nrdeducao                                                   as nrDeducao,
                      tc.nranodeducao                                                as nrAnoDeducao,
                      tcdi.dataestorno                                               as dtEstorno,
                      tcdi.valor                                                     as vlEstorno,
                      substr(md.descricao || '.' || coalesce(cd.motivo, ''), 0, 250) as dsMotivo,
                      cd.idcancelamento                                              as idCancelamento,
                      cd.entidade                                                    as entidade,
                      cd.exercicio                                                   as exercicio,
                      cast(null as integer)                                          as idpagamentobloqueto,
                      cast(null as integer)                                          as idcreditocontribuinteitem,
                      tcdi.iddebitoparcelareceita                                    as iddebitoparcelareceita,
                      cast(null as integer)                                          as idParcelamento,
                      cast(null as integer)                                          as idDebitoReceita,
                      cast(null as integer)                                          as idEstornoParcelamento,
                      trt.classificacaoreceitatipo  as idTipoCredito
      from tribcancelamentodebito cd
               join tribcancelamentodebitoitem tcdi on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and
                                                       tcdi.idcancelamento = cd.idcancelamento
               left join tceDeducaoCancelamentoDA tdc on tdc.entidade = tcdi.entidade and tdc.exercicio = tcdi.exercicio
          and tdc.idcancelamento = tcdi.idcancelamento and tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
               left join tceDeducaoCreditoDA tc on tc.idtcededucaocreditoDA = tdc.idtcededucaocreditoDA
               left join tribmotivodesconto md on md.motivodesconto = cd.motivocancelamento
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
               left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      where cd.entidade = :entidade
        and tcdi.dataestorno between :dataInicial and :dataFinal
        and tcdi.estornado = 'S'
        and cd.tipoDeducao <> 8
        and tcdi.situacaolegal in (1, 2)
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcdi.dataestorno > cd.datacancelamento
        and tcdi.valor > 0
        and not exists (
          select 1
          from tceDeducaoCancelamentoDAEst tdc
          where tdc.entidade = tcdi.entidade
            and tdc.exercicio = tcdi.exercicio
            and tdc.idcancelamento = tcdi.idcancelamento
            and tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita)
      union all
      select distinct md.idato,
                      tc.nrdeducao                 as nrDeducao,
                      tc.nranodeducao              as nrAnoDeducao,
                      tep.data                     as dtEstorno,
                      tpd.valordesconto            as vlEstorno,
                      substr(md.descricao, 0, 250) as dsMotivo,
                      cast(null as integer)        as idcancelamento,
                      cast(null as integer)        as entidade,
                      cast(null as integer)        as exercicio,
                      tepi.idpagamentobloqueto     as idPagamentoBloqueto,
                      cast(null as integer)        as idcreditocontribuinteitem,
                      tepi.iddebitoparcelareceita  as idDebitoParcelaReceita,
                      cast(null as integer)        as idParcelamento,
                      cast(null as integer)        as idDebitoReceita,
                      cast(null as integer)                                          as idEstornoParcelamento,
                      trt.classificacaoreceitatipo  as idTipoCredito
      from tribpagamentodebito tpd
               join tribEstornoPagamentoItem tepi on tepi.idpagamentobloqueto = tpd.idPagamentoBloqueto and
                                                     tepi.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               join tribestornopagamento tep
                    on tep.entidade = tepi.entidade and tep.exercicio = tepi.exercicio and tep.estorno = tepi.estorno
               left join tcededucaopagamentoDA tdp on tdp.idpagamentobloqueto = tpd.idpagamentobloqueto and
                                                 tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tceDeducaoCreditoDA tc on tc.idtcededucaocreditoDA = tdp.idtcededucaocreditoDA
               left join tribmotivodesconto md on md.motivodesconto = tep.motivodesconto
               left join contabancaria cb on tep.entidade = cb.entidade and tep.contabancariaestorno = cb.contabancaria
               left join tribdebitoparcelareceita tdpr on tpd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
               left join tribreceita                  tr   on tr.entidade =  :entidade
          and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      where tep.data between :dataInicial and :dataFinal
        and tep.entidade = :entidade
        and tpd.situacaolegal in (1, 2)
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
        and tpd.valordesconto > 0
        and not exists (
            select 1
            from tceDeducaoPagamentoDAEst tdp
            where tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
              and tdp.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
      union all
      select distinct md.idato,
                      tc.nrdeducao                                                               as nrDeducao,
                      tc.nranodeducao                                                            as nrAnoDeducao,
                      tcc.dataestorno                                                            as dtEstorno,
                      tcci.valordesconto                                                         as vlEstorno,
                      substr(md.descricao || '.' || coalesce(tcc.observacaoestorno, ''), 0, 250) as dsMotivo,
                      cast(null as integer)                                                      as idcancelamento,
                      cast(null as integer)                                                      as entidade,
                      cast(null as integer)                                                      as exercicio,
                      cast(null as integer)                                                      as idpagamentobloqueto,
                      tdcc.idcreditocontribuinteitem                                             as idCreditoContribuinteItem,
                      tdcc.iddebitoparcelareceita                                                as idDebitoParcelaReceita,
                      cast(null as integer)                                                      as idParcelamento,
                      cast(null as integer)                                                      as idDebitoReceita,
                      cast(null as integer)                                          as idEstornoParcelamento,
                      trt.classificacaoreceitatipo  as idTipoCredito
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita     tdpr  on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
               join tceDeducaoCreditoCreditoDA tdcc
                    on tdcc.idCreditoContribuinteItem = tcci.idCreditoContribuinteItem and
                       tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita
               join tceDeducaoCreditoDA tc on tc.idtcededucaocreditoDA = tdcc.idtcededucaocreditoDA
               left join tribmotivodesconto md on md.motivodesconto = tcc.motivodescontoestorno
               left join contabancaria cb on tcc.entidade = cb.entidade and tcc.contabancaria = cb.contabancaria
               left join tribreceita                  tr    on tr.entidade = :entidade
          and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo              trt   on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt  on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      where tcc.dataestorno between :dataInicial and :dataFinal
        and tcc.entidade = :entidade
        and tcc.valorestornado > 0
        and tcci.valordesconto > 0
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
        and not exists (
            select 1
            from tceDeducaoCreditoCreditoDAEst tdcc
            where tdcc.idCreditoContribuinteItem = tcci.idcreditocontribuinteitem
                and tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita)
      union all
      /*Estorno desconto de parcelamento voltando para a origem*/
      select tdcda.cdcontroleleiato                                    as idAto,
             tdcda.nrdeducao                                           as nrDeducao,
             tdcda.nranodeducao                                        as nrAnoDeducao,
             tep.dataestorno                                           as dtEstorno,
             sum(
                     case
                         when valores.parcela = valores.max_parcela then
                                     valores.valordescontoprincipal +
                                     valores.valordescontojuros +
                                     valores.valordescontomulta +
                                     valores.valordescontocorrecao -
                                     coalesce(
                                             (select sum(v.rateio_desconto_principal +
                                                         v.rateio_desconto_juros +
                                                         v.rateio_desconto_multa +
                                                         v.rateio_desconto_correcao)
                                              from vw_desconto_parcelamento v
                                              where v.idparcelamento = tp.idparcelamento
                                                and v.iddebito = valores.iddebito
                                                and v.receitaorigem = valores.receitaorigem
                                                and v.parcela <> valores.parcela),
                                             0)
                         else
                                 valores.rateio_desconto_principal +
                                 valores.rateio_desconto_juros +
                                 valores.rateio_desconto_multa +
                                 valores.rateio_desconto_correcao end) as vlEstorno,
             'Estorno de parcelamento: ' || tep.motivo                 as dsMotivo,
             cast(null as integer)                                     as idCancelamento,
             cast(null as integer)                                     as entidade,
             cast(null as integer)                                     as exercicio,
             cast(null as integer)                                     as idPagamentoBloqueto,
             cast(null as integer)                                     as idCreditoContribuinteItem,
             valores.iddebitoparcelareceita                            as idDebitoParcelaReceita,
             tep.idparcelamento                                        as idParcelamento,
             cast(null as integer)                                     as idDebitoReceita,
             tep.idestornoparcelamento                                 as idEstornoParcelamento,
             tcrt.classificacaoreceitatipo as idTipoCredito
      from tribestornoparcelamento tep
               left outer join tribparcelamento tp
                               on tp.idparcelamento = tep.idparcelamento
               left outer join tribparamparcelamento tpp
                               on tp.idparametroparcelamento = tpp.idparametroparcelamento
               left outer join tribmotivodesconto tmd
                               on tpp.motivoestorno = tmd.motivodesconto
               left outer join tribtipooperacaotce ttot
                               on tmd.idtipooperacaotce = ttot.idtipooperacaotce
               left outer join tribmotivodesconto tmdjurosfinan
                               on tpp.motivodescontofinan = tmdjurosfinan.motivodesconto
               left outer join tribtipooperacaotce ttotjurosfinan
                               on tmdjurosfinan.idtipooperacaotce = ttotjurosfinan.idtipooperacaotce
               join vw_desconto_parcelamento valores
                    on valores.idparcelamento = tp.idparcelamento
               left outer join tribdebito td
                               on td.iddebito = valores.iddebito
               left outer join tribreceita tr
                               on td.entidade = tr.entidade
                                   and :exercicio = tr.exercicio
                                   and valores.receita = tr.receita
               left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               left join tribclassificacaoreceitatipo tcrt
                         on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
               left outer join tcededucaoparcda tdpda
                               on tdpda.idparcelamento = tep.idparcelamento
                                   and tdpda.iddebitoparcelareceita =
                                       valores.iddebitoparcelareceita
               left outer join tcededucaocreditoda tdcda
                               on tdpda.idtcededucaocreditoda = tdcda.idtcededucaocreditoda
      where tep.dataestorno between :dataInicial and :dataFinal
        and tp.anocontrato = :exercicio
        and valores.situacaolegal in (1, 2)
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
        and exists(select 1
                   from tribestornoparcelamentodebito tepd
                   where tepd.idestornoparcelamento = tep.idestornoparcelamento
                     and tepd.iddebitoorigem > tepd.iddebitodestino)
        and not exists( select 1
                        from tcededucaoparcdaest tdpdae
                        where tdpdae.idparcelamento = tep.idparcelamento
                          and tdpdae.iddebitoparcelareceita = valores.iddebitoparcelareceita
                          and tdpdae.idestornoparcelamento = tep.idestornoparcelamento)
      group by tdcda.nrdeducao, tdcda.nranodeducao, tdcda.cdcontroleleiato,
               tdcda.idtipocredito,
               tep.dataestorno,
               'Estorno de parcelamento: ' || tep.motivo,
               tep.idparcelamento,
               valores.iddebitoparcelareceita,
               tcrt.classificacaoreceitatipo,
               tep.idestornoparcelamento
      /*Estorno desconto de parcelamento nova subdivida*/
      union all
      select tdcda.cdcontroleleiato                                    as idAto,
             tdcda.nrdeducao                                           as nrDeducao,
             tdcda.nranodeducao                                        as nrAnoDeducao,
             tep.dataestorno                                           as dtEstorno,
             sum(
                     case
                         when valores.parcela = valores.max_parcela then
                                     valores.valordescontoprincipal +
                                     valores.valordescontojuros +
                                     valores.valordescontomulta +
                                     valores.valordescontocorrecao -
                                     coalesce(
                                             (select sum(v.rateio_desconto_principal +
                                                         v.rateio_desconto_juros +
                                                         v.rateio_desconto_multa +
                                                         v.rateio_desconto_correcao)
                                              from vw_desc_parcelamento_prox_sub v
                                              where v.idparcelamento = tp.idparcelamento
                                                and v.iddebito = valores.iddebito
                                                and v.receitaorigem = valores.receitaorigem
                                                and v.parcela <> valores.parcela),
                                             0)
                         else
                                 valores.rateio_desconto_principal +
                                 valores.rateio_desconto_juros +
                                 valores.rateio_desconto_multa +
                                 valores.rateio_desconto_correcao end  ) as vlEstorno,
             'Estorno de parcelamento: ' || tep.motivo                 as dsMotivo,
             cast(null as integer)                                     as idCancelamento,
             cast(null as integer)                                     as entidade,
             cast(null as integer)                                     as exercicio,
             cast(null as integer)                                     as idPagamentoBloqueto,
             cast(null as integer)                                     as idCreditoContribuinteItem,
             valores.iddebitoparcelareceita                            as idDebitoParcelaReceita,
             tep.idparcelamento                                        as idParcelamento,
             cast(null as integer)                                     as idDebitoReceita,
             tep.idestornoparcelamento                                 as idEstornoParcelamento,
             tcrt.classificacaoreceitatipo  as idTipoCredito
      from tribestornoparcelamento tep
               left outer join tribparcelamento tp
                               on tp.idparcelamento = tep.idparcelamento
               left outer join tribparamparcelamento tpp
                               on tp.idparametroparcelamento = tpp.idparametroparcelamento
               left outer join tribmotivodesconto tmd
                               on tpp.motivoestorno = tmd.motivodesconto
               left outer join tribtipooperacaotce ttot
                               on tmd.idtipooperacaotce = ttot.idtipooperacaotce
               left outer join tribmotivodesconto tmdjurosfinan
                               on tpp.motivodescontofinan = tmdjurosfinan.motivodesconto
               left outer join tribtipooperacaotce ttotjurosfinan
                               on tmdjurosfinan.idtipooperacaotce = ttotjurosfinan.idtipooperacaotce
               join vw_desc_parcelamento_prox_sub valores
                    on valores.idestornoparcelamento = tep.idestornoparcelamento
               left outer join tribdebito td
                               on td.iddebito = valores.iddebito
               left outer join tribreceita tr
                               on td.entidade = tr.entidade
                                   and :exercicio = tr.exercicio
                                   and valores.receita = tr.receita
               left outer join tcededucaoparcda tdpda
                               on tdpda.idparcelamento = tep.idparcelamento
                                   and tdpda.iddebitoparcelareceita =
                                       valores.iddebitoparcelareceita
               left outer join tcededucaocreditoda tdcda
                               on tdpda.idtcededucaocreditoda = tdcda.idtcededucaocreditoda
               left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               left join tribclassificacaoreceitatipo tcrt
                         on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
      where tep.dataestorno between :dataInicial and :dataFinal
        and tp.anocontrato = :exercicio
        and valores.situacaolegal in (1, 2)
        and (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and exists(select 1
                   from tribestornoparcelamentodebito tepd
                   where tepd.idestornoparcelamento = tep.idestornoparcelamento
                     and tepd.iddebitoorigem < tepd.iddebitodestino)
        and not exists( select 1
                        from tcededucaoparcdaest tdpdae
                        where tdpdae.idparcelamento = tep.idparcelamento
                          and tdpdae.iddebitoparcelareceita = valores.iddebitoparcelareceita
                          and tdpdae.idestornoparcelamento = tep.idestornoparcelamento)
      group by tdcda.nrdeducao, tdcda.nranodeducao, tdcda.cdcontroleleiato,
               tdcda.idtipocredito,
               tep.dataestorno,
               'Estorno de parcelamento: ' || tep.motivo,
               tep.idparcelamento,
               valores.iddebitoparcelareceita,
               tcrt.classificacaoreceitatipo,
               tep.idestornoparcelamento
     ) filtro
order by filtro.dtEstorno,
         filtro.nrDeducao,
         filtro.nrAnoDeducao,
         filtro.idAto