select 07                                      as codigoArquivo,
       'Inscrição de Créditos em Dívida Ativa' as arquivo,
       'DEBITO'                                as tipoArquivo,
       arquivo.valor                           as valorArquivo,
       integracao.valor                        as valorIntegracao,
       0                                       as valorRetencao,
       (select
        case when count(teis.idregistro) > 0 then 'true' else 'false' end
        from tceinsccreditoda ticd
        join triberrosimportacaosimam teis on
        teis.idregistro = ticd.idtceinsccreditoda
        and teis.identificadorarquivo = 'INSCRICAO_CREDITO_DIVIDA_ATIVA'
        where ticd.dtinscricao between :dataInicial and :dataFinal) as temerroimportacao
from (
         select sum(filtro.valor) as valor
         from (select sum(ticd.vlinscricao) valor
               from tceInscCreditoDA ticd
               where ticd.dtinscricao between :dataInicial and :dataFinal
              ) filtro
     ) as arquivo
         cross join (select sum(valor) as valor
                     from (select coalesce(iip.valor, 0) as valor
                           from integracaopatrimonial ip
                                    left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                                    left join tribreceita r
                                              on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                                                 r.entidade = ip.entidade
                                    JOIN tribreceitatipo trt
                                         ON trt.tiporeceita = r.tiporeceita
                           where ip.entidade = :entidade
                             and ip.datamovimento between :dataInicial and :dataFinal
                             and iip.tipomovimento = 'INSCRICAO'
                             and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                             and iip.situacaolegal in (1,2)
                             and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE'
                             union all
					select sum(coalesce(item.valortributo, 0)) as valor
					from loteitemintegracaocontabil item
					      left join loteintegracaocontabil lote on item.idlote = lote.id
					      left join tribreceita r
					            on r.id = item.idtributo and r.exercicio = lote.exercicio and r.entidade = lote.entidade
					      JOIN tribreceitatipo trt
					            ON trt.tiporeceita = r.tiporeceita
					where lote.tipolote = 'ESTORNO_PAGAMENTO'
						and lote.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
						and lote.entidade = :entidade
						and lote.datalote between :dataInicial and :dataFinal
						and item.idtipooperacaodeducao = '3'
						and item.situacaolegal in (1,2)
						and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
						group by lote.datalote
                             ) as dados
) as integracao