select pagamento.iddebito,
       pagamento.iddebitoparcelareceita,
       pagamento.pessoa,
       pagamento.idtributo,
       pagamento.classificacaotributo,
       pagamento.situacaolegal,
       pagamento.idmotivodeducao,
       pagamento.idtipooperacaodeducao,
       pagamento.idcontacontabil,
       pagamento.tipoTributo,
       sum(pagamento.valorprincipal) as valorprincipal,
       sum(pagamento.valorjuros) as valorjuros,
       sum(pagamento.valormulta) as valormulta,
       sum(pagamento.valorcorrecao) as valorcorrecao,
       sum(pagamento.valordescontoprincipal) as valordescontoprincipal,
       sum(pagamento.valordescontojuros) as valordescontojuros,
       sum(pagamento.valordescontomulta) as valordescontomulta,
       sum(pagamento.valordescontocorrecao) as valordescontocorrecao,
       sum(pagamento.valordescontojurosfinan) as valordescontojurosfinan
from
(select debito.iddebito,
       debitoparcelareceita.iddebitoparcelareceita,
       boleto.pessoa,
       tributo.id as idtributo,
       tributo.classificacao as classificacaotributo,
       pagamentodebito.situacaolegal,
       motivodeducao.motivodesconto as idmotivodeducao,
       tipooperacaotce.idtipooperacaotce as idtipooperacaodeducao,
       contabancaria.localcontabil as idcontacontabil,
       tributo.tiporeceita as tipoTributo,
       coalesce(pagamentodebito.valorprincipal,0) + coalesce(pagamentodebito.valorpagomaior,0) as valorprincipal,
       coalesce(pagamentodebito.valorjuros,0) as valorjuros,
       coalesce(pagamentodebito.valormulta,0) as valormulta,
       coalesce(pagamentodebito.valorcorrecao,0) as valorcorrecao,
       coalesce(pagamentodebito.valordescontoprincipal,0) as valordescontoprincipal,
       coalesce(pagamentodebito.valordescontojuros,0) as valordescontojuros,
       coalesce(pagamentodebito.valordescontomulta,0) as valordescontomulta,
       coalesce(pagamentodebito.valordescontocorrecao,0) as valordescontocorrecao,
       coalesce(pagamentodebito.valordescontojurosfinan,0) as valordescontojurosfinan
from tribpagamentolote lote
join tribconvenio convenio on lote.entidade = convenio.entidade
                          and lote.convenio = convenio.convenio
join tribpagamento pagamento on pagamento.entidade = lote.entidade
                     and pagamento.exerciciolote = lote.exercicio
                     and pagamento.lote = lote.lote
join tribpagamentobloqueto pagamentoboleto on pagamento.entidade = pagamentoboleto.entidade
                                      and pagamento.exerciciopagamento = pagamentoboleto.exerciciopagamento
                                      and pagamento.pagamento = pagamentoboleto.pagamento
join tribpagamentodebito pagamentodebito on pagamentoboleto.idpagamentobloqueto = pagamentodebito.idpagamentobloqueto
join tribbloqueto boleto on pagamentoboleto.entidade = boleto.entidade
                        and pagamentoboleto.exerciciobloqueto = boleto.exerciciobloqueto
                        and pagamentoboleto.bloqueto = boleto.bloqueto
left join tribmotivodesconto motivodeducao on pagamentoboleto.motivodesconto = motivodeducao.motivodesconto
left join tribtipooperacaotce tipooperacaotce on motivodeducao.idtipooperacaotce = tipooperacaotce.idtipooperacaotce
join tribdebitoparcelareceita debitoparcelareceita on pagamentodebito.iddebitoparcelareceita = debitoparcelareceita.iddebitoparcelareceita
join tribdebitoparcela parcela on debitoparcelareceita.entidade = parcela.entidade
                              and debitoparcelareceita.exercicio = parcela.exercicio
                              and debitoparcelareceita.tipocadastro = parcela.tipocadastro
                              and debitoparcelareceita.cadastrogeral = parcela.cadastrogeral
                              and debitoparcelareceita.guiarecolhimento = parcela.guiarecolhimento
                              and debitoparcelareceita.subdivida = parcela.subdivida
                              and debitoparcelareceita.parcela = parcela.parcela
join tribdebito debito on parcela.entidade = debito.entidade
                      and parcela.exercicio = debito.exercicio
                      and parcela.tipocadastro = debito.tipocadastro
                      and parcela.cadastrogeral = debito.cadastrogeral
                      and parcela.guiarecolhimento = debito.guiarecolhimento
                      and parcela.subdivida = debito.subdivida
join tribreceita tributo on debitoparcelareceita.entidade = tributo.entidade
                        and lote.exercicio = tributo.exercicio
                        and debitoparcelareceita.receita = tributo.receita
join contabancaria on pagamento.entidade = contabancaria.entidade
    and pagamento.contabancaria = contabancaria.contabancaria
where contabancaria.integraarrecadacao = 'S'
and lote.entidade = :entidade
and lote.exercicio = :exercicio
and lote.lote = :lote
union all
select debito.iddebito,
       debitoparcelareceita.iddebitoparcelareceita,
       boleto.pessoa,
       tributo.id as idtributo,
       tributo.classificacao as classificacaotributo,
       parcela.situacaolegal,
       motivodeducao.motivodesconto as idmotivodeducao,
       tipooperacaotce.idtipooperacaotce as idtipooperacaodeducao,
       contabancaria.localcontabil as idcontacontabil,
       tributo.tiporeceita as tipoTributo,
       coalesce(creditocontribuinteitem.valorprincipal,0) as valorprincipal,
       coalesce(creditocontribuinteitem.valorjuros,0) as valorjuros,
       coalesce(creditocontribuinteitem.valormulta,0) as valormulta,
       coalesce(creditocontribuinteitem.valorcorrecao,0) as valorcorrecao,
       coalesce(creditocontribuinteitem.valordescontoprincipal,0) as valordescontoprincipal,
       coalesce(creditocontribuinteitem.valordescontojuros,0) as valordescontojuros,
       coalesce(creditocontribuinteitem.valordescontomulta,0) as valordescontomulta,
       coalesce(creditocontribuinteitem.valordescontocorrecao,0) as valordescontocorrecao,
       coalesce(creditocontribuinteitem.valordescontojurosfinan,0) as valordescontojurosfinan
from tribpagamentolote lote
join tribconvenio convenio on lote.entidade = convenio.entidade
                          and lote.convenio = convenio.convenio
join tribcreditocontribuinte creditocontribuinte on lote.entidade = creditocontribuinte.entidade
                                                and lote.exercicio = creditocontribuinte.exerciciolote
                                                and lote.lote = creditocontribuinte.lote
join tribcreditocontribuinteitem creditocontribuinteitem on creditocontribuinte.entidade = creditocontribuinteitem.entidade
                                                        and creditocontribuinte.exercicio = creditocontribuinteitem.exercicio
                                                        and creditocontribuinte.creditocontribuinte = creditocontribuinteitem.creditocontribuinte
join tribbloqueto boleto on creditocontribuinte.entidade = boleto.entidade
                        and creditocontribuinte.exerciciobloqueto = boleto.exerciciobloqueto
                        and creditocontribuinte.bloqueto = boleto.bloqueto
left join tribmotivodesconto motivodeducao on boleto.motivodesconto = motivodeducao.motivodesconto
left join tribtipooperacaotce tipooperacaotce on motivodeducao.idtipooperacaotce = tipooperacaotce.idtipooperacaotce
join tribdebitoparcelareceita debitoparcelareceita on creditocontribuinteitem.iddebitoparcelareceita = debitoparcelareceita.iddebitoparcelareceita
join tribdebitoparcela parcela on debitoparcelareceita.entidade = parcela.entidade
                              and debitoparcelareceita.exercicio = parcela.exercicio
                              and debitoparcelareceita.tipocadastro = parcela.tipocadastro
                              and debitoparcelareceita.cadastrogeral = parcela.cadastrogeral
                              and debitoparcelareceita.guiarecolhimento = parcela.guiarecolhimento
                              and debitoparcelareceita.subdivida = parcela.subdivida
                              and debitoparcelareceita.parcela = parcela.parcela
join tribdebito debito on parcela.entidade = debito.entidade
                      and parcela.exercicio = debito.exercicio
                      and parcela.tipocadastro = debito.tipocadastro
                      and parcela.cadastrogeral = debito.cadastrogeral
                      and parcela.guiarecolhimento = debito.guiarecolhimento
                      and parcela.subdivida = debito.subdivida
join tribreceita tributo on debitoparcelareceita.entidade = tributo.entidade
                        and lote.exercicio = tributo.exercicio
                        and debitoparcelareceita.receita = tributo.receita
join contabancaria on creditocontribuinte.entidade = contabancaria.entidade
                          and creditocontribuinte.contabancaria = contabancaria.contabancaria
where contabancaria.integraarrecadacao = 'S'
and lote.entidade = :entidade
and lote.exercicio = :exercicio
and lote.lote = :lote ) pagamento
group by pagamento.iddebito,
       pagamento.iddebitoparcelareceita,
       pagamento.pessoa,
       pagamento.idtributo,
       pagamento.classificacaotributo,
       pagamento.situacaolegal,
       pagamento.idmotivodeducao,
       pagamento.idtipooperacaodeducao,
       pagamento.idcontacontabil,
       pagamento.tipoTributo