/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.unico;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.repository.CidadeRepository;
import br.com.elotech.tributos.service.CidadeService;
import br.com.elotech.tributos.service.UnidadeFederacaoService;
import br.com.elotech.tributos.service.unico.CidadeClientUnico;
import br.com.elotech.tributos.util.ConvertToUpperCase;
import br.com.elotech.unico.client.dto.CidadeDTO;
import br.com.elotech.unico.client.dto.UfDTO;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CidadeServiceUnico
extends CrudService<Cidade, Long>
implements CidadeService {
    private CidadeClientUnico cidadeClientUnico;
    private CidadeRepository cidadeRepository;
    private UnidadeFederacaoService unidadeFederacaoService;

    public CidadeServiceUnico(CidadeClientUnico cidadeClientUnico, CidadeRepository cidadeRepository, UnidadeFederacaoService unidadeFederacaoService) {
        this.cidadeClientUnico = cidadeClientUnico;
        this.cidadeRepository = cidadeRepository;
        this.unidadeFederacaoService = unidadeFederacaoService;
    }

    public Optional<Cidade> buscaOuCriaCidade(br.com.elotech.tributos.dto.CidadeDTO cidadeDTO) {
        if (StringUtils.isBlank((CharSequence)cidadeDTO.getDescricao())) {
            return Optional.empty();
        }
        ConvertToUpperCase.convert((Object)cidadeDTO);
        if (Objects.nonNull(cidadeDTO.getId())) {
            return this.cidadeRepository.findById((Object)cidadeDTO.getId());
        }
        List cidades = this.cidadeRepository.findByDescricaoIgnoreCaseAndUnidadeFederacaoIgnoreCase(cidadeDTO.getDescricao(), cidadeDTO.getUf());
        if (!cidades.isEmpty()) {
            return cidades.stream().max(Comparator.comparing(Cidade::getAtiva));
        }
        List uf = this.unidadeFederacaoService.findByUnidadeFederacaoIgnoreCase(cidadeDTO.getUf());
        if (!uf.isEmpty()) {
            CidadeDTO novaCidadeUnico = new CidadeDTO();
            UfDTO ufDTO = new UfDTO();
            ufDTO.setId(((UnidadeFederacao)uf.get(0)).getIdunico());
            novaCidadeUnico.setUf(ufDTO);
            novaCidadeUnico.setDescricao(cidadeDTO.getDescricao());
            CidadeDTO novaCidadeCriada = this.cidadeClientUnico.saveCidade(novaCidadeUnico);
            return this.cidadeRepository.findByIdUnico(novaCidadeCriada.getId());
        }
        return Optional.empty();
    }
}

