/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.simam.InscricaoCreditoDividaAtiva;
import br.com.elotech.tributos.dto.simam.InscricaoDividaAtivaDTO;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.simam.InscricaoCreditoDividaAtivaRepository;
import java.time.LocalDate;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class InscricaoDividaAtivaService
extends CrudService<InscricaoCreditoDividaAtiva, Long> {
    private final EntidadeRepository entidadeRepository;
    private final InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository;

    public InscricaoDividaAtivaService(EntidadeRepository entidadeRepository, InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository) {
        this.entidadeRepository = entidadeRepository;
        this.inscricaoCreditoDividaAtivaRepository = inscricaoCreditoDividaAtivaRepository;
    }

    public List<InscricaoDividaAtivaDTO> findInscricaoDividaAtiva(Long idEntidade, LocalDate dataInicial, LocalDate dataFinal) {
        Entidade entidade = (Entidade)this.entidadeRepository.findById((Object)idEntidade).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar a entidade com id %d", idEntidade)));
        return this.inscricaoCreditoDividaAtivaRepository.findLancamentos(entidade.getId(), Long.valueOf(entidade.getIdentificacaoTce()), dataInicial, dataFinal);
    }
}

