/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.EstornoDeducaoCreditoMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoCustomRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.conferencia.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EstornoDeducaoCreditoMaService
implements ManutencaoArquivoSimAmService<EstornoDeducaoCreditoMaDTO> {
    private final EstornoDeducaoCreditoCustomRepository estornoDeducaoCreditoRepository;
    private final EntityManager entityManager;
    private final ContextService contextService;
    private final DeducaoCreditoRepository deducaoCreditoRepository;
    private final AtoRepository atoRepository;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO;
    }

    public Page<EstornoDeducaoCreditoMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dtEstorno"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.estornoDeducaoCreditoRepository.findAll(specification, pageable).map(EstornoDeducaoCreditoMaDTO::from);
    }

    public List<EstornoDeducaoCreditoMaDTO> updateAll(List<EstornoDeducaoCreditoMaDTO> arquivos) {
        if (!this.areRegistrosValidos(arquivos)) {
            return arquivos.stream().filter(EstornoDeducaoCreditoMaDTO::hasError).collect(Collectors.toList());
        }
        this.estornoDeducaoCreditoRepository.saveAll((Iterable)arquivos.stream().map(EstornoDeducaoCreditoMaDTO::toDeducaoCredito).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areRegistrosValidos(List<EstornoDeducaoCreditoMaDTO> estornoDeducaoCredito) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return estornoDeducaoCredito.stream().reduce(Boolean.TRUE, (result, current) -> {
            try {
                this.validaNrDeducao(current);
                this.validaCdControleLeiAto(current, entidade);
            }
            catch (EloValidationException e) {
                current.setMensagemErro(e.getMessage());
            }
            return current.hasError() == false;
        }, (a, b) -> a != false && b != false);
    }

    private void validaNrDeducao(EstornoDeducaoCreditoMaDTO estornoDeducaoCredito) {
        if (!this.deducaoCreditoRepository.existsByNrDeducaoAndNrAnoDeducao(estornoDeducaoCredito.getNrDeducao(), estornoDeducaoCredito.getNrAnoDeducao()).booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o foi encontrado registro de Dedu\u00e7\u00e3o de cr\u00e9dito com a chave NrDeducao/NrAnoDeducao com os valores %s/%s.", estornoDeducaoCredito.getNrDeducao(), estornoDeducaoCredito.getNrAnoDeducao()));
        }
    }

    private void validaCdControleLeiAto(EstornoDeducaoCreditoMaDTO arrecadacaoTipoCredito, Long entidade) {
        Optional<Long> idAto = this.atoRepository.findByIdAto(entidade, arrecadacaoTipoCredito.getCdControleLeiAto()).map(Ato::getIdAto);
        if (idAto.isEmpty()) {
            throw new EloValidationException(String.format("O controle de Lei/Ato %d com c\u00f3digo %d da tabela EstornoDeducaoCredito n\u00e3o est\u00e1 presente na tabela CgAto.", arrecadacaoTipoCredito.getCdControleLeiAto(), arrecadacaoTipoCredito.getId()));
        }
    }

    @Generated
    public EstornoDeducaoCreditoMaService(EstornoDeducaoCreditoCustomRepository estornoDeducaoCreditoRepository, EntityManager entityManager, ContextService contextService, DeducaoCreditoRepository deducaoCreditoRepository, AtoRepository atoRepository) {
        this.estornoDeducaoCreditoRepository = estornoDeducaoCreditoRepository;
        this.entityManager = entityManager;
        this.contextService = contextService;
        this.deducaoCreditoRepository = deducaoCreditoRepository;
        this.atoRepository = atoRepository;
    }
}

