/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.domain.documento.cda.ValidacaoDadosContribuintesDTO;
import br.com.elotech.tributos.dto.documento.cda.LoteCdaResumoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.DocumentoTipoService;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.service.documento.cda.GeraCertidaoDividaAtivaService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaItemPessoaService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GeraLoteCertidaoDividaAtivaService {
    private final ContextService contextService;
    private final DocumentoService documentoService;
    private final DocumentoTipoService documentoTipoService;
    private final EntidadeTributacaoService entidadeTributacaoService;
    private final LoteCdaService loteCdaService;
    private final LoteCdaItemPessoaService loteCdaItemPessoaService;
    private final GeraCertidaoDividaAtivaService geraCertidaoDividaAtivaService;

    GeraLoteCertidaoDividaAtivaService(ContextService contextService, DocumentoService documentoService, DocumentoTipoService documentoTipoService, EntidadeTributacaoService entidadeTributacaoService, LoteCdaService loteCdaService, LoteCdaItemPessoaService loteCdaItemPessoaService, GeraCertidaoDividaAtivaService geraCertidaoDividaAtivaService) {
        this.contextService = contextService;
        this.documentoService = documentoService;
        this.documentoTipoService = documentoTipoService;
        this.entidadeTributacaoService = entidadeTributacaoService;
        this.loteCdaService = loteCdaService;
        this.loteCdaItemPessoaService = loteCdaItemPessoaService;
        this.geraCertidaoDividaAtivaService = geraCertidaoDividaAtivaService;
    }

    public LoteCdaResumoDTO gerarCertidoes(Long idSimulacao) {
        LocalDate dataReferencia = LocalDate.now();
        LoteCda loteSimulacao = (LoteCda)this.loteCdaService.findOne((Serializable)idSimulacao);
        if (!SituacaoLoteCda.SIMULACAO_GERADA.equals((Object)loteSimulacao.getSituacao())) {
            throw new EloValidationException("O respectivo lote possui situa\u00e7\u00e3o diferente de Simula\u00e7\u00e3o Gerada.");
        }
        this.validateDadosContribuintesInvalidos(loteSimulacao.getId());
        List debitosInvalidos = this.loteCdaService.getDebitoParcelaTributoInvalidoFromLoteCda(loteSimulacao.getId()).stream().map(BigDecimal::longValue).collect(Collectors.toList());
        loteSimulacao.getItens().forEach(item -> item.getItemDetalhes().removeIf(itemDetalhe -> debitosInvalidos.contains(itemDetalhe.getParcelaTributo().getId())));
        loteSimulacao.getItens().removeIf(item -> item.getItemDetalhes().isEmpty());
        if (loteSimulacao.getItens().isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrado nenhum d\u00e9bito para gerar uma certid\u00e3o de d\u00edvida ativa, verifique se os d\u00e9bitos j\u00e1 est\u00e3o inclusos em outras CDA's.");
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        EntidadeTributacao entidadeTributacao = this.entidadeTributacaoService.findByEntidadeIdAndExercicio(entidade, exercicio);
        DocumentoTipo tipoDocumento = this.documentoTipoService.findById(TipoDocumentoEnum.CERTIDAO_DIVIDA_ATIVA.getCodigo());
        this.loteCdaService.calcularAcrescimosGeracaoCda(dataReferencia, loteSimulacao.getItens(), entidade);
        loteSimulacao.getItens().forEach(item -> {
            Documento documento = this.geraCertidaoDividaAtivaService.gerarCertidaoDividaAtiva(item, entidade, exercicio, tipoDocumento, entidadeTributacao, dataReferencia);
            item.setDocumento((Documento)this.documentoService.save((EloEntity)documento, null));
        });
        loteSimulacao.setSituacao(SituacaoLoteCda.CERTIDAO_GERADA);
        loteSimulacao.setDataGeracao(dataReferencia);
        loteSimulacao.setUsuarioGeracao(SecurityUtils.getUserAise());
        return LoteCdaResumoDTO.of((LoteCda)((LoteCda)this.loteCdaService.save((EloEntity)loteSimulacao, null)));
    }

    private void validateDadosContribuintesInvalidos(Long idLote) {
        ValidacaoDadosContribuintesDTO loteDadosContribuintes = this.loteCdaItemPessoaService.revalidarDadosContribuintes(idLote);
        if (!loteDadosContribuintes.isValid()) {
            throw new EloValidationException("O respectivo lote possui propriet\u00e1rios com os seguintes dados inv\u00e1lidos: " + loteDadosContribuintes.getInvalidMessage());
        }
    }
}

