/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.comunicado;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.ComunicadoDto;
import br.com.elotech.tributos.dto.SituacaoComunicado;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.repository.ComunicadoCadastroRepository;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BatchService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ComunicadoService
extends CrudService<Comunicado, ComunicadoId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComunicadoService.class);
    private final ComunicadoRepository comunicadoRepository;
    private final ComunicadoCadastroRepository comunicadoCadastroRepository;
    private final ComunicadoCadastroService comunicadoCadastroService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final ResolversHandler resolversHandler;
    private final NotificacaoService notificacaoService;
    private final BatchService batchService;

    public Page<ComunicadoDto> search(String search, Pageable pageable) {
        return this.findByRsql(search, pageable).map(ComunicadoDto::from);
    }

    public ComunicadoDto findComunicadoDTOById(ComunicadoId comunicadoId) {
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o comunicado com identificador: Entidade %d, Exercicio %d e idComunicado %d", comunicadoId.getEntidade(), comunicadoId.getExercicio(), comunicadoId.getIdComunicado()));
        }
        ComunicadoDto comunicadoDTO = ComunicadoDto.from((Comunicado)comunicado);
        BatchJobExecution batchJobExecution = comunicado.getBatchJobExecutionComunicado();
        if (Objects.isNull(batchJobExecution)) {
            return comunicadoDTO;
        }
        JobParameters jobParameters = this.batchService.getJobParametersById(batchJobExecution.getId());
        comunicadoDTO.setJobParameters(jobParameters);
        return comunicadoDTO;
    }

    public void validateEnderecosGlobais(Long entidade, Long exercicio, Long idComunicado) throws Exception {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o comunicado com identificador: Entidade %d, Exercicio %d e idComunicado %d", entidade, exercicio, idComunicado));
        }
        if (SituacaoComunicado.CANCELADO.equals((Object)comunicado.getSituacao())) {
            throw new EloValidationException("Este comunicado j\u00e1 foi cancelado");
        }
    }

    public Comunicado cancelComunicado(Long entidade, Long exercicio, Long idComunicado) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        if (Objects.isNull(comunicado)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o comunicado com identificador: Entidade %d, Exercicio %d e idComunicado %d", entidade, exercicio, idComunicado));
        }
        if (SituacaoComunicado.CANCELADO.equals((Object)comunicado.getSituacao())) {
            throw new EloValidationException("Este comunicado j\u00e1 foi cancelado");
        }
        this.comunicadoCadastroRepository.updateComunicadoCadastrosSituacao(entidade, exercicio, idComunicado, SituacaoComunicadoCadastro.CANCELADO, SituacaoComunicadoCadastro.CANCELADO.getDescricao());
        this.comunicadoRepository.updateComunicadoSituacaoCancelado(entidade, exercicio, idComunicado);
        comunicado.setSituacao(SituacaoComunicado.CANCELADO);
        return comunicado;
    }

    @Async
    @Transactional
    public void printLoteComunicado(Long entidade, Long exercicio, Long idComunicado, String search, Sort sort) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaImpressaoLoteComunicado(comunicadoId.toString());
        Long tarefa = execucao.getTarefaAssincrona().getId();
        UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
        Optional notificacaoId = this.notificacaoService.send("Gera\u00e7\u00e3o de Comunicados em Lote", String.format("Iniciada a gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        List comunicadosCadastro = this.comunicadoCadastroService.findByRsql(entidade, exercicio, idComunicado, search, sort);
        this.groupArquivosLoteComunicado(comunicadosCadastro, comunicadoId, execucao, tarefa, userSecurityDTO, notificacaoId);
    }

    public String getUrlArquivoLoteComunicado(Long entidade, Long exercicio, Long idComunicado) {
        try {
            Comunicado comunicado = (Comunicado)this.comunicadoRepository.findById((Object)ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado)).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comunicado n\u00e3o encontrado"));
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + comunicado.getIdArquivoImpressao()));
            return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
        }
        catch (Exception ex) {
            throw new EloValidationException("Falha ao recuperar URL de download do arquivo." + ex.getMessage());
        }
    }

    private void groupArquivosLoteComunicado(List<ComunicadoCadastro> comunicadosCadastro, ComunicadoId comunicadoId, TarefaAssincronaExecucao execucao, Long tarefa, UserSecurityDTO userSecurityDTO, Optional<UUID> notificacaoId) {
        if (Objects.isNull(comunicadosCadastro)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Lote de Comunicado de id %s.", comunicadoId.toString()));
        }
        try {
            log.info("Iniciando o agrupamento dos arquivos de Lote de Comunicado");
            ArquivoNovoRequest arquivoNovoRequest = this.getArquivoNovoRequest(comunicadoId.toString(), comunicadosCadastro);
            Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
            comunicadosCadastro.forEach(comunicadoCadastro -> {
                comunicadoCadastro.getId().getComunicado().setIdArquivoImpressao(arquivo.getId());
                comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.IMPRESSO);
                comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.IMPRESSO.getDescricao());
            });
            this.comunicadoCadastroRepository.saveAll(comunicadosCadastro);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Finalizada Gera\u00e7\u00e3o de Comunicados em Lote", String.format("Finalizada com sucesso a gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
            log.info("Finalizado o agrupamento dos arquivos de Lote de Comunicado e disponibilizado no S3");
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            this.notificacaoService.send("Erro na Gera\u00e7\u00e3o de Comunicados em Lote", String.format("Ocorreu um erro na gera\u00e7\u00e3o do PDF do Lote de Comunicado da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
            log.error("Erro ao agrupar arquivos de Lote de Comunicado {} ", (Object)e.getMessage(), (Object)e);
        }
    }

    private ArquivoNovoRequest getArquivoNovoRequest(String comunicadoId, List<ComunicadoCadastro> comunicadosCadastro) throws IOException {
        InputStream inputStream = this.groupArquivosLoteComunicado(comunicadosCadastro);
        return this.uploadArquivoAgrupado(comunicadoId, inputStream);
    }

    private ArquivoNovoRequest uploadArquivoAgrupado(String comunicadoId, InputStream inputStream) {
        String nomeArquivo = String.format("Comunicado_Lote_%s_%s", comunicadoId, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        return ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
    }

    private InputStream groupArquivosLoteComunicado(List<ComunicadoCadastro> comunicadosCadastro) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        try (PDDocument document = new PDDocument();){
            for (ComunicadoCadastro comunicadoCadastro : comunicadosCadastro) {
                PDFMergerUtility pdfMerge = new PDFMergerUtility();
                byte[] arquivoTemp = this.comunicadoCadastroService.print(comunicadoCadastro.getId().getComunicado().getId().getEntidade(), comunicadoCadastro.getId().getComunicado().getId().getExercicio(), comunicadoCadastro.getId().getComunicado().getId().getIdComunicado(), comunicadoCadastro.getId().getSequencia());
                PDDocument pdfDocument = PDDocument.load((byte[])arquivoTemp);
                pdfMerge.appendDocument(document, pdfDocument);
                pdfDocument.close();
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            document.save((OutputStream)byteArrayOutputStream);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    @Generated
    public ComunicadoService(ComunicadoRepository comunicadoRepository, ComunicadoCadastroRepository comunicadoCadastroRepository, ComunicadoCadastroService comunicadoCadastroService, TarefaAssincronaService tarefaAssincronaService, ResolversHandler resolversHandler, NotificacaoService notificacaoService, BatchService batchService) {
        this.comunicadoRepository = comunicadoRepository;
        this.comunicadoCadastroRepository = comunicadoCadastroRepository;
        this.comunicadoCadastroService = comunicadoCadastroService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.resolversHandler = resolversHandler;
        this.notificacaoService = notificacaoService;
        this.batchService = batchService;
    }
}

