/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.LivroEstorno;
import br.com.elotech.tributos.domain.LivroEstornoParcelaTributo;
import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.LivroEstornoRegistroDTO;
import br.com.elotech.tributos.dto.LivroParcelaEstornoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.repository.DocumentoItemDividaAtivaRepository;
import br.com.elotech.tributos.repository.LivroEstornoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.LivroParcelaTributoService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LivroEstornoService
extends CrudService<LivroEstorno, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LivroEstornoService.class);
    private final LivroEstornoRepository livroEstornoRepository;
    private final LivroParcelaTributoService livroParcelaTributoService;
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoService debitoService;
    private final DocumentoItemDividaAtivaRepository documentoItemDividaAtivaRepository;

    public void estornarPorLivro(LivroParcelaEstornoDTO livroParcelaEstornoDTO) {
        List livroParcelasTributos = this.livroParcelaTributoService.findByLivro(livroParcelaEstornoDTO.getEntidade(), livroParcelaEstornoDTO.getExercicio(), livroParcelaEstornoDTO.getLivro());
        this.saveLivroEstornoAndUpdateParcelas(livroParcelaEstornoDTO, livroParcelasTributos);
    }

    public void estornarPorRegistros(List<LivroParcelaEstornoDTO> livroParcelaEstornoDTO) {
        livroParcelaEstornoDTO.forEach(estorno -> {
            List livroParcelaTributo = this.livroParcelaTributoService.findByLivroRegistro(estorno.getEntidade(), estorno.getExercicio(), estorno.getLivro(), estorno.getSequencia());
            this.saveLivroEstornoAndUpdateParcelas(estorno, livroParcelaTributo);
        });
    }

    public Boolean validateMovimentacaoItem(LivroEstornoRegistroDTO livroEstornoRegistroDTO) {
        for (LivroParcelaEstornoDTO estorno : livroEstornoRegistroDTO.getEstornos()) {
            if (!this.existeParcelaTributo(estorno)) continue;
            return false;
        }
        return true;
    }

    private void saveLivroEstornoAndUpdateParcelas(LivroParcelaEstornoDTO livroEstornoDTO, List<LivroParcelaTributo> livroParcelasTributos) {
        HashMap debitosEnglobados = new HashMap();
        HashMap parcelas = new HashMap();
        List<LivroParcelaTributo> livroParcelasTributosNaoEstornado = livroParcelasTributos.stream().filter(estorno -> Boolean.FALSE.equals(estorno.getEstornado()) && !this.existeMovimentacaoParcelaTributo(estorno)).collect(Collectors.toList());
        if (livroParcelasTributosNaoEstornado.isEmpty()) {
            throw new EloValidationException(String.format("N\u00e3o h\u00e1 d\u00e9bitos para estornar no livro %d/%d", livroEstornoDTO.getLivro(), livroEstornoDTO.getExercicio()));
        }
        LivroEstorno livroEstorno = new LivroEstorno();
        livroEstorno.setDataEstorno(LocalDate.now());
        livroEstorno.setUsuario(SecurityUtils.getUserAise());
        this.livroEstornoRepository.save((Object)livroEstorno);
        LOGGER.debug("Iniciando o estorno dos registros do livro {}/{}", (Object)livroEstornoDTO.getLivro(), (Object)livroEstornoDTO.getExercicio());
        livroParcelasTributosNaoEstornado.forEach(livroParcelaTributo -> {
            DebitoIdDTO idDebitoEnglobado;
            LOGGER.debug("Estornando livroParcelaTributo com id {}", (Object)livroParcelaTributo.getId());
            this.updateSituacaoLivroParcela(livroParcelaTributo);
            LivroEstornoParcelaTributo livroEstornoParcelaTributo = new LivroEstornoParcelaTributo();
            livroEstornoParcelaTributo.setLivroParcelaTributo(livroParcelaTributo);
            livroEstornoParcelaTributo.setMotivoCancelamento(livroEstornoDTO.getMotivoDeducao());
            livroEstorno.getLivroEstornoParcelaTributos().add(livroEstornoParcelaTributo);
            DebitoIdDTO idDebito = DebitoIdDTO.of((Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getIdDebito(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getEntidade(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getExercicio(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getTipoCadastro(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getCadastroGeral(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getDivida(), (Long)livroParcelaTributo.getId().getDebitoParcelaTributo().getSubDivida());
            if (Objects.nonNull(livroParcelaTributo.getNovaSubDivida()) && !livroParcelaTributo.getNovaSubDivida().equals(idDebito.getSubDivida()) && !debitosEnglobados.containsKey(idDebitoEnglobado = this.debitoService.findByCompositeKey(livroParcelaTributo.getId().getDebitoParcelaTributo().getEntidade(), livroParcelaTributo.getId().getDebitoParcelaTributo().getExercicio(), livroParcelaTributo.getId().getDebitoParcelaTributo().getTipoCadastro(), livroParcelaTributo.getId().getDebitoParcelaTributo().getCadastroGeral(), livroParcelaTributo.getId().getDebitoParcelaTributo().getDivida(), livroParcelaTributo.getNovaSubDivida()).map(debito -> DebitoIdDTO.of((Long)debito.getId(), (Long)debito.getEntidade(), (Long)debito.getExercicio(), (Long)debito.getTipoCadastro(), (Long)debito.getCadastroGeralId(), (Long)debito.getDivida().getDivida(), (Long)debito.getSubDivida())).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar o d\u00e9bito")))) {
                debitosEnglobados.put(idDebitoEnglobado, livroParcelaTributo.getId().getDebitoParcelaTributo().getDebitoParcela().getDebito());
                this.debitoParcelaService.estornoParcelaLivroDividaAtivaEnglobado(idDebitoEnglobado);
                this.cancelarDebitosEnglobados(livroParcelaTributo, idDebitoEnglobado, livroEstornoDTO.getMotivoDeducao());
            }
            if (!parcelas.containsKey(livroParcelaTributo.getId().getDebitoParcelaTributo().getDebitoParcela().getId())) {
                parcelas.put(livroParcelaTributo.getId().getDebitoParcelaTributo().getDebitoParcela().getId(), livroParcelaTributo.getId().getDebitoParcelaTributo().getDebitoParcela());
                this.debitoParcelaService.estornoParcelaLivroDividaAtiva(livroParcelaTributo, idDebito);
            }
        });
        LOGGER.debug("Gerando as observa\u00e7\u00f5es para os d\u00e9bitos estornados");
        this.geraDebitoObservacao(livroEstornoDTO, livroParcelasTributosNaoEstornado);
        this.livroEstornoRepository.save((Object)livroEstorno);
    }

    private void geraDebitoObservacao(LivroParcelaEstornoDTO livroEstornoDTO, List<LivroParcelaTributo> livroParcelasTributosNaoEstornado) {
        livroParcelasTributosNaoEstornado.stream().collect(Collectors.groupingBy(g -> g.getId().getDebitoParcelaTributo().getDebitoParcela().getDebito())).forEach((debito, livroParcelaTributos) -> {
            String parcelasString = livroParcelaTributos.stream().map(livroParcelaTributo -> livroParcelaTributo.getId().getDebitoParcelaTributo().getParcela()).sorted().distinct().map(Objects::toString).collect(Collectors.joining(", "));
            String observacao = String.format("Estorno D\u00edvida Ativa, do livro N\u00ba %d/%d Parcelas: %s", livroEstornoDTO.getLivro(), livroEstornoDTO.getExercicio(), parcelasString);
            DebitoIdDTO idDebitoDTO = DebitoIdDTO.of((Long)debito.getId(), (Long)debito.getEntidade(), (Long)debito.getExercicio(), (Long)debito.getTipoCadastro(), (Long)debito.getCadastroGeralId(), (Long)debito.getGuiaRecolhimento(), (Long)debito.getSubDivida());
            this.debitoObservacaoService.save(idDebitoDTO, observacao);
        });
    }

    private void updateSituacaoLivroParcela(LivroParcelaTributo livroParcelasTributos) {
        this.livroParcelaTributoService.updateSituacaoEstornado(livroParcelasTributos);
    }

    private void cancelarDebitosEnglobados(LivroParcelaTributo livroParcelaTributo, DebitoIdDTO idDebito, MotivoDeducao motivoDeducao) {
        LocalDate dataCancelamento = LocalDate.now();
        this.cancelamentoDebitoService.cancelamentoDebitoEnglobado(livroParcelaTributo, idDebito, motivoDeducao, dataCancelamento);
    }

    private boolean existeParcelaTributo(LivroParcelaEstornoDTO estorno) {
        List livroParcelaTributo = this.livroParcelaTributoService.findByLivroRegistro(estorno.getEntidade(), estorno.getExercicio(), estorno.getLivro(), estorno.getSequencia());
        return livroParcelaTributo.stream().anyMatch(arg_0 -> this.existeMovimentacaoParcelaTributo(arg_0));
    }

    public Boolean validateMovimentacaoLivro(LivroParcelaEstornoDTO livroParcelaEstornoDTO) {
        List livroParcelasTributos = this.livroParcelaTributoService.findByLivro(livroParcelaEstornoDTO.getEntidade(), livroParcelaEstornoDTO.getExercicio(), livroParcelaEstornoDTO.getLivro());
        return livroParcelasTributos.stream().noneMatch(arg_0 -> this.existeMovimentacaoParcelaTributo(arg_0));
    }

    private boolean existeMovimentacaoParcelaTributo(LivroParcelaTributo livroParcela) {
        if (Objects.nonNull(livroParcela.getNovaSubDivida())) {
            return Boolean.TRUE.equals(this.validateSituacaoEnglobada(livroParcela)) ? Boolean.TRUE : this.existInCda(livroParcela);
        }
        if (SituacaoLegal.JUIZO.equals((Object)livroParcela.getSituacaoLegal())) {
            return Boolean.TRUE;
        }
        return this.existInCda(livroParcela);
    }

    private Boolean validateSituacaoEnglobada(LivroParcelaTributo livroParcelaTributo) {
        Optional debitoEnglobado = this.debitoService.findByCompositeKey(livroParcelaTributo.getId().getDebitoParcelaTributo().getEntidade(), livroParcelaTributo.getId().getDebitoParcelaTributo().getExercicio(), livroParcelaTributo.getId().getDebitoParcelaTributo().getTipoCadastro(), livroParcelaTributo.getId().getDebitoParcelaTributo().getCadastroGeral(), livroParcelaTributo.getId().getDebitoParcelaTributo().getDivida(), livroParcelaTributo.getNovaSubDivida());
        if (debitoEnglobado.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar d\u00e9bito englobado com nova subdivida;");
        }
        if (!this.validateSituacaoParcela((Debito)debitoEnglobado.get()).booleanValue()) {
            return Boolean.TRUE;
        }
        return this.documentoItemDividaAtivaRepository.findDocumentoByLivroEnglobado(livroParcelaTributo.getId().getLivroRegistro().getId().getLivro().getId().getEntidade(), livroParcelaTributo.getId().getLivroRegistro().getId().getLivro().getId().getExercicio(), livroParcelaTributo.getId().getLivroRegistro().getId().getLivro().getId().getLivro(), ((Debito)debitoEnglobado.get()).getId(), TipoDocumentoEnum.CERTIDAO_DIVIDA_ATIVA.getCodigo(), livroParcelaTributo.getNovaSubDivida());
    }

    private Boolean existInCda(LivroParcelaTributo livroParcelaTributo) {
        Optional debito = this.debitoService.findByCompositeKey(livroParcelaTributo.getId().getDebitoParcelaTributo().getEntidade(), livroParcelaTributo.getId().getDebitoParcelaTributo().getExercicio(), livroParcelaTributo.getId().getDebitoParcelaTributo().getTipoCadastro(), livroParcelaTributo.getId().getDebitoParcelaTributo().getCadastroGeral(), livroParcelaTributo.getId().getDebitoParcelaTributo().getDivida(), livroParcelaTributo.getId().getDebitoParcelaTributo().getSubDivida());
        if (!this.validateSituacaoParcela((Debito)debito.get()).booleanValue()) {
            return Boolean.TRUE;
        }
        return this.documentoItemDividaAtivaRepository.findDocumentoByLivro(livroParcelaTributo.getId().getLivroRegistro().getId().getLivro().getId().getEntidade(), livroParcelaTributo.getId().getLivroRegistro().getId().getLivro().getId().getExercicio(), livroParcelaTributo.getId().getLivroRegistro().getId().getLivro().getId().getLivro(), livroParcelaTributo.getId().getLivroRegistro().getId().getSequencia(), livroParcelaTributo.getId().getDebitoParcelaTributo().getId(), TipoDocumentoEnum.CERTIDAO_DIVIDA_ATIVA.getCodigo());
    }

    private Boolean validateSituacaoParcela(Debito debito) {
        return debito.getParcelas().stream().map(DebitoParcela::getSituacaoDebito).map(SituacaoParcela::getTipoSituacaoParcela).allMatch(situacaoDebito -> TipoSituacaoParcela.ABERTO.equals(situacaoDebito) || TipoSituacaoParcela.INSCRITO_DIVIDA_ATIVA.equals(situacaoDebito));
    }

    @Generated
    public LivroEstornoService(LivroEstornoRepository livroEstornoRepository, LivroParcelaTributoService livroParcelaTributoService, CancelamentoDebitoService cancelamentoDebitoService, DebitoObservacaoService debitoObservacaoService, DebitoParcelaService debitoParcelaService, DebitoService debitoService, DocumentoItemDividaAtivaRepository documentoItemDividaAtivaRepository) {
        this.livroEstornoRepository = livroEstornoRepository;
        this.livroParcelaTributoService = livroParcelaTributoService;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoService = debitoService;
        this.documentoItemDividaAtivaRepository = documentoItemDividaAtivaRepository;
    }
}

