/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoItemPeticaoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoDocumentoDTO;
import br.com.elotech.tributos.exception.PeticaoNotFoundException;
import br.com.elotech.tributos.report.loader.PeticaoDividaAtivaParamLoader;
import br.com.elotech.tributos.repository.DocumentoPeticaoRepository;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DocumentoService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DocumentoPeticaoService {
    private final DocumentoPeticaoRepository documentoPeticaoRepository;
    private final DocumentoService documentoService;
    private final DebitoParcelaService debitoParcelaService;
    private final PeticaoDividaAtivaParamLoader peticaoDividaAtivaParamLoader;

    public DocumentoPeticaoService(DocumentoPeticaoRepository documentoPeticaoRepository, DocumentoService documentoService, DebitoParcelaService debitoParcelaService, PeticaoDividaAtivaParamLoader peticaoDividaAtivaParamLoader) {
        this.documentoPeticaoRepository = documentoPeticaoRepository;
        this.documentoService = documentoService;
        this.debitoParcelaService = debitoParcelaService;
        this.peticaoDividaAtivaParamLoader = peticaoDividaAtivaParamLoader;
    }

    public DocumentoDTO findPeticaoDividaAtiva(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        if (Objects.isNull(documento)) {
            throw new EloValidationException("Peti\u00e7\u00e3o n\u00e3o encontrado");
        }
        DocumentoDTO documentoDTO = DocumentoDTO.from((Documento)documento);
        documentoDTO.getDocumentosItensPeticaoDTO().addAll(this.documentoPeticaoRepository.findAllDocumentoPeticaoCdaByPeticao(documento.getId()));
        return documentoDTO;
    }

    public List<DocumentoItemPeticaoDTO> findDividaAtivaPorPeticao(Long id) {
        Documento documento = (Documento)this.documentoService.findById((Serializable)id).orElseThrow(() -> new PeticaoNotFoundException("Peti\u00e7\u00e3o n\u00e3o encontrada"));
        return this.documentoPeticaoRepository.findAllDocumentoPeticaoCdaByPeticao(documento.getId()).stream().filter(item -> item.getCanceladoCertidao().equals(Boolean.FALSE)).collect(Collectors.toList());
    }

    public DocumentoDTO cancelarPeticao(Long id, CancelamentoDocumentoDTO cancelamentoDocumentoDTO) {
        DocumentoDTO peticaoDTO = DocumentoDTO.from((Documento)this.documentoService.cancelarDocumento(id, cancelamentoDocumentoDTO));
        List listaDebitoParcelaDTO = this.documentoPeticaoRepository.findDebitoParcelasPorPeticao(id);
        listaDebitoParcelaDTO.forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).updateSituacaoLegalParcela(arg_0));
        return peticaoDTO;
    }

    public ImprimirRelatorioDTO buildImpressaoPeticaoDTO(Long id) {
        DocumentoDTO documento = this.findPeticaoDividaAtiva(id);
        if (Objects.isNull(documento.getRelatorio())) {
            throw new EloValidationException("Relat\u00f3rio n\u00e3o encontrado ou n\u00e3o configurado na peti\u00e7\u00e3o de d\u00edvida ativa");
        }
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(Integer.valueOf(documento.getRelatorio().intValue()));
        dto.setModulo(documento.getModulo());
        dto.setTipoRelatorioFromEnum(TipoRelatorio.fromValue((String)documento.getTipoRelatorio()));
        dto.setFiltro(String.format(" td.Exercicio = %d and td.Documento = %d", documento.getExercicio(), documento.getDocumento()));
        dto.setListParametros(this.peticaoDividaAtivaParamLoader.load(documento.getExercicio()));
        dto.setSubReports(this.createSubReportImprimirPeticao(dto.getFiltro()));
        return dto;
    }

    private SubReportDTO createSubReportImprimirPeticao(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Certidao", filtro), new SubReportItemDTO("CertidaoProprietario", filtro)}));
        return subReportDTO;
    }

    public List<DocumentoItemPeticaoDTO> findPeticoesVinculadasComCDA(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        if (Objects.isNull(documento)) {
            throw new EloValidationException("Certid\u00e3o de d\u00edvida ativa n\u00e3o encontrado");
        }
        return this.documentoPeticaoRepository.findPeticaoVinculadaComCDA(documento.getEntidade(), documento.getExercicio(), documento.getDocumento());
    }
}

