/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Carne;
import br.com.elotech.tributos.domain.DebitoCarne;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoCotaUnicaDTO;
import br.com.elotech.tributos.repository.DebitoCarneCustomRepository;
import br.com.elotech.tributos.util.AgrupaDebitos;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DebitoCarneService
extends CrudService<DebitoCarne, Long> {
    private final DebitoCarneCustomRepository debitoCarneCustomRepository;

    public List<DebitoCarneDTO> getDebitosCarne(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral) {
        return this.debitoCarneCustomRepository.getDebitosCarne(entidade, exercicio, tipoCadastro, cadastroGeral);
    }

    public List<DebitoParcelaTributoCotaUnicaDTO> findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(Long idDebito) {
        return this.debitoCarneCustomRepository.findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(idDebito);
    }

    public List<DebitoCarneDTO> getDebitosCarneComFormasPagamento(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral) {
        List debitosCarne = this.getDebitosCarne(entidade, exercicio, tipoCadastro, cadastroGeral);
        debitosCarne.forEach(debitoCarne -> {
            List formasPagamento = this.findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(debitoCarne.getIdDebito());
            debitoCarne.setFormasPagamento(AgrupaDebitos.agrupaDebitosPorDebitoEFormaPagamento((List)formasPagamento));
        });
        return debitosCarne;
    }

    public DebitoCarne associarCarneNoDebito(Long idDebito, CarneDTO carneDTO, Long formaPagamento) {
        if (this.getCrudRepository().existsById((Object)idDebito)) {
            throw new EloValidationException(String.format("O d\u00e9bito %d j\u00e1 possui carne associado.", idDebito));
        }
        Carne carne = (Carne)this.getEm().getReference(Carne.class, (Object)carneDTO.toCarneId());
        DebitoCarne debitoCarne = new DebitoCarne();
        debitoCarne.setId(idDebito);
        debitoCarne.setCarne(carne);
        debitoCarne.setFormaPagamento(formaPagamento);
        return (DebitoCarne)this.save((EloEntity)debitoCarne, null);
    }

    @Generated
    public DebitoCarneService(DebitoCarneCustomRepository debitoCarneCustomRepository) {
        this.debitoCarneCustomRepository = debitoCarneCustomRepository;
    }
}

