/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.pagamento.AiseImportacaoArquivoRetornoPagamentoResultDTO;
import br.com.elotech.tributos.dto.pagamento.ImportacaoArquivoRetornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoDTO;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteConcederDescontoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteIntegracaoDTO;
import br.com.elotech.tributos.dto.pagamento.QuantidadeInconsistenciaLoteDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.VerificarExistenciaJobService;
import br.com.elotech.tributos.service.batch.BaixaAutomaticaJobStarter;
import br.com.elotech.tributos.service.batch.DescontoBaixaAutomaticaJobStarter;
import br.com.elotech.tributos.service.exception.UserNotFoundException;
import br.com.elotech.tributos.service.integracaoboleto.sicoob.IntegracaoPixPagoContext;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletResponse;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/pagamento-lotes"})
public class PagamentoLoteResource
extends CrudResource<PagamentoLote, PagamentoLoteId> {
    private final ProcessaPagamentoLoteService processaPagamentoLoteService;
    private final PagamentoLoteService pagamentoLoteService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final BaixaAutomaticaJobStarter baixaAutomaticaJobStarter;
    private final IntegracaoPixPagoContext integracaoPixPagoContext;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final VerificarExistenciaJobService verificarExistenciaJobService;
    private final DescontoBaixaAutomaticaJobStarter descontoBaixaAutomaticaJobStarter;

    public PagamentoLoteResource(ProcessaPagamentoLoteService processaPagamentoLoteService, PagamentoLoteService pagamentoLoteService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, BaixaAutomaticaJobStarter baixaAutomaticaJobStarter, IntegracaoPixPagoContext integracaoPixPagoContext, TarefaAssincronaService tarefaAssincronaService, VerificarExistenciaJobService verificarExistenciaJobService, DescontoBaixaAutomaticaJobStarter descontoBaixaAutomaticaJobStarter) {
        this.processaPagamentoLoteService = processaPagamentoLoteService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.baixaAutomaticaJobStarter = baixaAutomaticaJobStarter;
        this.integracaoPixPagoContext = integracaoPixPagoContext;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.verificarExistenciaJobService = verificarExistenciaJobService;
        this.descontoBaixaAutomaticaJobStarter = descontoBaixaAutomaticaJobStarter;
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<PagamentoLoteDTO>> searchPagamentos(@RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok((Object)this.getService().findByRsql((String)search.orElse(null), page).map(PagamentoLoteDTO::of));
    }

    @GetMapping(value={"/baixa-automatica-lote/{entidade}/{exercicio}/{lote}"})
    public ResponseEntity<QuantidadeInconsistenciaLoteDTO> countBaixaAutomaticaByLote(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long lote) {
        return ResponseEntity.ok((Object)this.baixaAutomaticaDetalheService.countInconsistenciasLote(entidade, exercicio, lote));
    }

    @PutMapping(value={"/reabrir-lote/{entidade}/{exercicio}/{lote}"})
    public ResponseEntity<Void> reabrirLote(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long lote) {
        this.pagamentoLoteService.reabrirLote(entidade, exercicio, lote);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/fechar-lote/{entidade}/{exercicio}/{lote}"})
    public ResponseEntity<Void> fecharLote(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long lote) {
        this.pagamentoLoteService.fecharLote(entidade, exercicio, lote);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/importar-arquivo-retorno"})
    public ResponseEntity<AiseImportacaoArquivoRetornoPagamentoResultDTO> importarArquivoRetorno(ImportacaoArquivoRetornoPagamentoDTO arquivoRetorno, @RequestParam MultipartFile file) throws IOException {
        return ResponseEntity.ok((Object)this.pagamentoLoteService.importarArquivoRetorno(arquivoRetorno, file.getBytes()));
    }

    @GetMapping(value={"arquivo-pagamento-retorno/{entidade}/{exercicio}/{lote}"})
    public ResponseEntity<PagamentoLoteDTO> findPagamentoLote(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long lote) {
        return ResponseEntity.ok((Object)this.pagamentoLoteService.findPagamentoLoteDTO(entidade, exercicio, lote));
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{lote}/verificar"})
    public Callable<Void> verificarLote(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="lote") Long lote) {
        return () -> {
            PagamentoLoteId pagamentoLoteId = PagamentoLoteId.of((Long)entidade, (Long)exercicio, (Long)lote);
            Boolean tarefaEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.VERIFICACAO_PAGAMENTO_LOTE, "ID_PAGAMENTO_LOTE", pagamentoLoteId.toString());
            if (Boolean.TRUE.equals(tarefaEmExecucao)) {
                throw new EloValidationException("J\u00e1 existe uma tarefa em execu\u00e7\u00e3o para o Lote Pagamento informado!");
            }
            boolean existeJobComMesmosParametros = this.verificarExistenciaJobService.existeJobEmAndamento(entidade, exercicio, lote, JobType.BAIXA_AUTOMATICA.getTipo());
            if (existeJobComMesmosParametros) {
                throw new EloValidationException("Este lote j\u00e1 se encontra em processamento.");
            }
            UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
            if (Objects.isNull(userSecurityDTO.getUserId())) {
                throw new UserNotFoundException("Usu\u00e1rio logado n\u00e3o encontrado.");
            }
            this.processaPagamentoLoteService.verificarLoteTarefa(pagamentoLoteId, userSecurityDTO);
            return null;
        };
    }

    @PostMapping(value={"/por-data"})
    public ResponseEntity<SortedMap<LocalDate, List<PagamentoLoteIntegracaoDTO>>> findPagamentoLotePorDia(@RequestBody List<LocalDate> diasSelecionados) {
        return ResponseEntity.ok((Object)this.pagamentoLoteService.findPagamentoLotePorDia(diasSelecionados));
    }

    @DeleteMapping(value={"/{entidade}/{exercicio}/{lote}"})
    public ResponseEntity<Void> removerLote(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="lote") Long lote) {
        this.pagamentoLoteService.removerLote(entidade, exercicio, lote);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{lote}/baixar"})
    public ResponseEntity<Void> baixarLote(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="lote") Long lote) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        this.baixaAutomaticaJobStarter.startJob(entidade, exercicio, lote);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/importar-pix"})
    public ResponseEntity<ImportacaoPixPagoResultadoDTO> importarPagamentosPix(@RequestBody ImportacaoPixPagoDTO dto) {
        return ResponseEntity.ok((Object)this.integracaoPixPagoContext.importar(dto));
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{lote}/imprimir-consistencia-baixa"})
    public void imprimirConsistenciaArquivoBaixa(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="lote") Long lote, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.pagamentoLoteService.imprimirConsistenciaArquivoBaixa(entidade, exercicio, lote);
        if (Objects.isNull(arquivo)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o arquivo de consist\u00eancia de baixa!");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)"consistenciabaixa.pdf");
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{lote}/conceder-desconto"})
    public ResponseEntity<Void> concederDescontoParaPagamentosPagoAMenorMaiorQueParametrizado(@PathVariable(value="lote") Long lote, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="entidade") Long entidade, @RequestBody(required=false) Map<String, String> observacao) {
        PagamentoLoteConcederDescontoDTO dto = new PagamentoLoteConcederDescontoDTO(lote, exercicio, entidade, observacao.get("observacao"));
        this.descontoBaixaAutomaticaJobStarter.startJob(dto);
        return ResponseEntity.ok().build();
    }
}

