/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.audit.domain.ChangeWithRevision;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.annotation.ValidFile;
import br.com.elotech.tributos.audit.AuditService;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.dto.ArquivoJasperRequestDTO;
import br.com.elotech.tributos.dto.ArquivoJasperResponseDTO;
import br.com.elotech.tributos.dto.ArquivoJasperSalvoDTO;
import br.com.elotech.tributos.dto.TipoArquivoJasperDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoJasperService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/arquivos-jasper"})
@Validated
public class ArquivoJasperResource {
    private final ArquivoJasperService arquivoJasperService;
    private final AuditService auditService;

    @GetMapping
    public ResponseEntity<Page<ArquivoJasperResponseDTO>> getAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.arquivoJasperService.listar(search, pageable));
    }

    @GetMapping(value={"/{idArquivo}"})
    public ResponseEntity<ArquivoJasperResponseDTO> get(@PathVariable(value="idArquivo") @Min(value=1L, message="Um identificador de Arquivo v\u00e1lido precisa ser informado") @NotNull(message="Um identificador de Arquivo precisa ser informado") @Min(value=1L, message="Um identificador de Arquivo v\u00e1lido precisa ser informado") @NotNull(message="Um identificador de Arquivo precisa ser informado") Long idArquivo) {
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarPorId(idArquivo);
        return ResponseEntity.ok((Object)ArquivoJasperResponseDTO.from((ArquivoJasper)arquivoJasper));
    }

    @PostMapping(params={"nomeInternoArquivo"})
    public ResponseEntity<ArquivoJasperSalvoDTO> save(@RequestParam(value="arquivo") @NotNull(message="Um arquivo precisa ser informado") @ValidFile(message="Somente arquivos .jrxml s\u00e3o permitidos", mimeType="application/octet-stream", checkExtension=true, expectedExtension="jrxml") @NotNull(message="Um arquivo precisa ser informado") @ValidFile(message="Somente arquivos .jrxml s\u00e3o permitidos", mimeType="application/octet-stream", checkExtension=true, expectedExtension="jrxml") MultipartFile arquivo, @Valid ArquivoJasperRequestDTO dto) throws IOException {
        ArquivoJasper arquivoJasper = dto.toEntity(SecurityUtils.getUserAise(), arquivo);
        ArquivoJasper saved = (ArquivoJasper)this.arquivoJasperService.save((EloEntity)arquivoJasper, (Authentication)SecurityUtils.getAuthentication());
        String resourceURI = ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{saved.getId()}).toUriString();
        return ResponseEntity.created((URI)URI.create(resourceURI)).body((Object)ArquivoJasperSalvoDTO.from((ArquivoJasper)saved));
    }

    @PutMapping(params={"id", "nomeInternoArquivo"})
    public ResponseEntity<ArquivoJasperSalvoDTO> update(@RequestParam(value="arquivo", required=false) @ValidFile(message="Somente arquivos .jrxml s\u00e3o permitidos", mimeType="application/octet-stream", checkExtension=true, expectedExtension="jrxml") @ValidFile(message="Somente arquivos .jrxml s\u00e3o permitidos", mimeType="application/octet-stream", checkExtension=true, expectedExtension="jrxml") MultipartFile arquivo, @Valid ArquivoJasperRequestDTO dto) throws IOException {
        ArquivoJasper arquivoJasper = dto.toEntity(SecurityUtils.getUserAise(), arquivo);
        return ResponseEntity.ok((Object)ArquivoJasperSalvoDTO.from((ArquivoJasper)this.arquivoJasperService.updateArquivo(arquivoJasper)));
    }

    @DeleteMapping(value={"/{idArquivo}"})
    public ResponseEntity<Void> delete(@PathVariable(value="idArquivo") @Min(value=1L, message="Um identificador de Arquivo v\u00e1lido precisa ser informado") @NotNull(message="Um identificador de Arquivo precisa ser informado") @Min(value=1L, message="Um identificador de Arquivo v\u00e1lido precisa ser informado") @NotNull(message="Um identificador de Arquivo precisa ser informado") Long idArquivo) {
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarPorId(idArquivo);
        this.arquivoJasperService.delete((EloEntity)arquivoJasper, (Authentication)SecurityUtils.getAuthentication());
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    @GetMapping(value={"/download/{idArquivo}"})
    public void download(@PathVariable(value="idArquivo") @Min(value=1L, message="Um identificador de Arquivo v\u00e1lido precisa ser informado") @NotNull(message="Um identificador de Arquivo precisa ser informado") @Min(value=1L, message="Um identificador de Arquivo v\u00e1lido precisa ser informado") @NotNull(message="Um identificador de Arquivo precisa ser informado") Long idArquivo, HttpServletResponse response) throws IOException {
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarPorId(idArquivo);
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        response.setHeader("Expires", "0");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Content-Disposition", "attachment; filename=".concat(arquivoJasper.getNomeArquivo().concat(".jrxml")));
        response.setContentType("application/octet-stream");
        response.setContentLength(arquivoJasper.getArquivo().length);
        response.getOutputStream().write(arquivoJasper.getArquivo());
    }

    @GetMapping(value={"/tipos"})
    public ResponseEntity<List<TipoArquivoJasperDTO>> getTipos() {
        List tipos = Stream.of(TipoArquivoJasper.values()).map(TipoArquivoJasperDTO::from).collect(Collectors.toList());
        return ResponseEntity.ok(tipos);
    }

    @GetMapping(value={"/historico/{id}"})
    public ResponseEntity<Page<ChangeWithRevision>> getHistorico(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.auditService.getRevisionForEntity(ArquivoJasper.class, (Serializable)id, search, pageable));
    }

    @GetMapping(value={"/historico/download/{id}"})
    public void findByIdAtDate(@PathVariable Long id, @RequestParam(value="referenceDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime date, HttpServletResponse response) throws IOException {
        ArquivoJasper arquivoJasper = (ArquivoJasper)this.auditService.getRecordAtDate(ArquivoJasper.class, (Serializable)id, date);
        if (Objects.isNull(arquivoJasper)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar dados com ID %d na data %s.", id, DateUtils.localDateTimeToStringFormatoBrasileiro((LocalDateTime)date)));
        }
        if (Objects.nonNull(arquivoJasper.getArquivo())) {
            response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Content-Disposition", "attachment; filename=".concat(arquivoJasper.getNomeArquivo().concat(".jrxml")));
            response.setContentType("application/octet-stream");
            response.setContentLength(arquivoJasper.getArquivo().length);
            response.getOutputStream().write(arquivoJasper.getArquivo());
        }
    }

    @Generated
    public ArquivoJasperResource(ArquivoJasperService arquivoJasperService, AuditService auditService) {
        this.arquivoJasperService = arquivoJasperService;
        this.auditService = auditService;
    }
}

