/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.simam.ConsultaSaldoCreditoDTO;
import br.com.elotech.tributos.dto.simam.ConsultaSaldoDividaDTO;
import br.com.elotech.tributos.dto.simam.FiltroConsultaSaldoDTO;
import br.com.elotech.tributos.util.SqlUtils;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ConsultaSaldoSimAmRepository {
    private static final String CONSULTA_SALDO_CREDITO = "sql/simam/consultadesaldo/saldoNrCredito.sql";
    private static final String CONSULTA_SALDO_DIVIDA = "sql/simam/consultadesaldo/saldoNrDivida.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public Page<ConsultaSaldoCreditoDTO> consultaCredito(FiltroConsultaSaldoDTO dto, Integer exercicioImplantacao, Pageable pageable) {
        if (Objects.isNull(exercicioImplantacao)) {
            throw new EloValidationException(String.format("O valor do parametro %s precisa ser configurado.", ParametroGeralEnum.SIMAM_EXERCICIO_IMPLANTACAO.getValue()));
        }
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("dataSaldo", (Object)dto.getDataInicial().with(TemporalAdjusters.firstDayOfYear()), 91);
        parameters.addValue("dataInicial", (Object)dto.getDataInicial(), 91);
        parameters.addValue("dataFinal", (Object)dto.getDataFinal(), 91);
        parameters.addValue("nranocredito", (Object)dto.getDataInicial().getYear(), 2);
        parameters.addValue("exercicioImplantacao", (Object)exercicioImplantacao, 2);
        String sql = String.format(FileUtils.readResourceAsString((String)CONSULTA_SALDO_CREDITO), dto.buildFiltro());
        Long numeroTotal = this.getTotal(sql, parameters);
        String sqlComPaginacao = this.montaSqlComPaginacao(sql, pageable);
        List pagedRows = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaSaldoCreditoDTO.class));
        return new PageImpl(pagedRows, pageable, Optional.ofNullable(numeroTotal).orElse(0L).longValue());
    }

    public Page<ConsultaSaldoDividaDTO> consultaDivida(FiltroConsultaSaldoDTO dto, Integer exercicioImplantacao, Pageable pageable) {
        if (Objects.isNull(exercicioImplantacao)) {
            throw new EloValidationException(String.format("O valor do parametro %s precisa ser configurado.", ParametroGeralEnum.SIMAM_EXERCICIO_IMPLANTACAO.getValue()));
        }
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("dataSaldo", (Object)dto.getDataInicial().with(TemporalAdjusters.firstDayOfYear()), 91);
        parameters.addValue("dataInicial", (Object)dto.getDataInicial(), 91);
        parameters.addValue("dataFinal", (Object)dto.getDataFinal(), 91);
        parameters.addValue("nranodivida", (Object)dto.getDataInicial().getYear(), 2);
        parameters.addValue("exercicioImplantacao", (Object)exercicioImplantacao, 2);
        String sql = String.format(FileUtils.readResourceAsString((String)CONSULTA_SALDO_DIVIDA), dto.buildFiltro());
        Long numeroTotal = this.getTotal(sql, parameters);
        String sqlComPaginacao = this.montaSqlComPaginacao(sql, pageable);
        List pagedRows = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaSaldoDividaDTO.class));
        return new PageImpl(pagedRows, pageable, Optional.ofNullable(numeroTotal).orElse(0L).longValue());
    }

    private Long getTotal(String sql, MapSqlParameterSource parameters) {
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sql);
        return (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
    }

    private String montaSqlComPaginacao(String sql, Pageable pageable) {
        String finalSort = SqlUtils.getFinalSort((Pageable)pageable);
        return SqlUtils.withPagination((String)sql.concat(finalSort), (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
    }

    @Generated
    public ConsultaSaldoSimAmRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

