/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.mobile;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.itbi.CadastroGeralCidadaoFiltroDTO;
import br.com.elotech.tributos.dto.itbi.CadastroGeralCidadaoMobileDTO;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CadastroGeralCidadaoRepository {
    private static final String SQL_CADASTRO_GERAL = "br/com/elotech/tributos/repository/mobile/find-cadastro-por-cpf-cnpj-modulo-cidadao.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public Page<CadastroGeralCidadaoMobileDTO> getCadastrosCidadao(CadastroGeralCidadaoFiltroDTO filtro, Pageable pageable) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("cpfcnpj", (Object)filtro.getCpfCnpj(), 12);
        String sort = pageable.getSort().toString().replace(":", "").replaceAll("(?i)unsorted", "");
        String finalSort = "";
        if (!sort.isEmpty()) {
            finalSort = finalSort.concat(" ORDER BY " + sort);
        }
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_CADASTRO_GERAL), filtro.buildFiltro());
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sql);
        Long numeroTotal = (Long)this.namedParameterJdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)sql.concat(" " + finalSort), (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        List list = this.namedParameterJdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CadastroGeralCidadaoMobileDTO.class));
        return new PageImpl(list, pageable, Optional.ofNullable(numeroTotal).orElse(0L).longValue());
    }

    @Generated
    public CadastroGeralCidadaoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

