/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.atendimento;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.atendimento.Atendimento;
import br.com.elotech.tributos.dto.atendimento.AtendimentoChartDTO;
import br.com.elotech.tributos.repository.atendimento.AtendimentoCustomRepository;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface AtendimentoRepository
extends CrudRepository<Atendimento, Long>,
AtendimentoCustomRepository {
    @Query(value=" select new br.com.elotech.tributos.dto.atendimento.AtendimentoChartDTO(day(horarioinicio), month(horarioinicio), year(horarioinicio), count(a.id))  from Atendimento a  where horarioinicio between :inicio and :fim  group by year(horarioInicio), month(horarioInicio), day(horarioInicio)  order by year(horarioInicio), month(horarioInicio), day(horarioInicio) ")
    public List<AtendimentoChartDTO> findAtendimentosNoPeriodo(@Param(value="inicio") LocalDateTime var1, @Param(value="fim") LocalDateTime var2);

    @Query(value=" select coalesce(avg( (day(a.horarioFim - a.horarioInicio) *24 *60) +  (hour(a.horarioFim - a.horarioInicio) *60) +  minute(a.horarioFim - a.horarioInicio)),0)  from Atendimento a  where a.horarioFim is not null ")
    public Long getTempoMedioAtendimento();

    @Query(value=" select a from Atendimento a where a.atendenteCpfCnpj = :atendenteCpfCnpj and a.horarioFim is null order by a.horarioInicio ")
    public List<Atendimento> findAtendimentoEmAbertoByAtendenteCpfCnpj(@Param(value="atendenteCpfCnpj") String var1);
}

