/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.dto.MotivoDeducaoDTO;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface MotivoDeducaoRepository
extends CrudRepository<MotivoDeducao, Long> {
    public MotivoDeducao findByDescricao(String var1);

    @Query(value="SELECT CASE WHEN COUNT(A.MOTIVODESCONTO) > 0 THEN 'true' ELSE 'false' END AS VALIDAMOTIVO FROM TRIBMOTIVODESCONTO A WHERE A.MOTIVODESCONTO = ?1 AND EXISTS (SELECT 1 FROM TRIBMOVIMENTACAODETALHE B WHERE A.ENTIDADE = B.ENTIDADE AND A.EXERCICIO = B.EXERCICIO AND A.MOTIVODESCONTO = B.MOTIVODESCONTO)", nativeQuery=true)
    public Boolean existsMotivoMovimentacao(Long var1);

    @Query(value="select new br.com.elotech.tributos.dto.MotivoDeducaoDTO(md.id, md.entidade, md.descricao, md.exercicio, md.tipoDeducao) from MotivoDeducao md where md.exercicio = :exercicio and md.entidade = :entidade and lower (md.descricao) like lower (concat('%',:descricao,'%'))")
    public Page<MotivoDeducaoDTO> findByEntidadeExercicioAndDescricao(@Param(value="exercicio") Long var1, @Param(value="entidade") Long var2, @Param(value="descricao") String var3, Pageable var4);

    @Query(value=" SELECT md  FROM MotivoDeducao md  WHERE LOWER(md.descricao) LIKE CONCAT('%', LOWER(:descricao), '%')    AND md.tipoOperacaoTce  IN ( SELECT tot                                 FROM TipoOperacaoTce tot                                 WHERE tot.id IN :tipoOperacaoTce )")
    public List<MotivoDeducao> findByDescricaoAndTipoOperacaoTce(@Param(value="descricao") String var1, @Param(value="tipoOperacaoTce") List<Long> var2);
}

