/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.mobile;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.dto.CadastroGeralDTO;
import br.com.elotech.tributos.dto.PessoaDTO;
import java.time.LocalDate;
import java.util.Optional;

public class DocumentoMobileDTO {
    private static final String SITUACAO_POSITIVA = "P";
    private static final String SITUACAO_NEGATIVA = "N";
    private static final String SITUACAO_POSITIVA_EFEITO_NEGATIVA = "X";
    private final Documento documento;
    private CadastroImobiliario cadastroImobiliarioEntity;
    private String urlImpressao;
    private String situacao;
    private CadastroGeralDTO cadastro;
    private PessoaDTO pessoa;

    public DocumentoMobileDTO(Documento documento, String urlImpressao) {
        this.documento = documento;
        this.urlImpressao = urlImpressao;
        this.pessoa = new PessoaDTO();
    }

    public CadastroImobiliario getCadastroImobiliarioEntity() {
        return this.cadastroImobiliarioEntity;
    }

    public void setCadastroImobiliarioEntity(CadastroImobiliario cadastroImobiliarioEntity) {
        this.cadastroImobiliarioEntity = cadastroImobiliarioEntity;
    }

    public void setUrlImpressao(String urlImpressao) {
        this.urlImpressao = urlImpressao;
    }

    public String getUrlImpressao() {
        return this.urlImpressao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public String getSituacao() {
        switch (this.documento.getSubTipo()) {
            case "P": {
                this.setSituacao("Positiva");
                break;
            }
            case "N": {
                this.setSituacao("Negativa");
                break;
            }
            case "X": {
                this.setSituacao("Positiva com efeito de negativa");
                break;
            }
            default: {
                this.setSituacao("");
            }
        }
        return this.situacao;
    }

    public void setExercicio(Long exercicio) {
        this.documento.setExercicio(exercicio);
    }

    public Long getExercicio() {
        return this.documento.getExercicio();
    }

    public String getCodigoAutenticidade() {
        return this.documento.getCodigoValidacao();
    }

    public void setCodigoAutenticidade(String codigoAutenticidade) {
        this.documento.setCodigoValidacao(codigoAutenticidade);
    }

    public void setDescricao() {
        this.documento.setTipoDocumento(this.documento.getTipoDocumento());
    }

    public String getDescricao() {
        return this.documento.getDocumentoTipo().getDescricao();
    }

    public void setDocumento(Long documento) {
        this.documento.setDocumento(documento);
    }

    public Long getDocumento() {
        return this.documento.getDocumento();
    }

    public void setTipoDocumento(DocumentoTipo tipoDocumento) {
        this.documento.setDocumentoTipo(tipoDocumento);
    }

    public Long getTipoDocumento() {
        return this.documento.getDocumentoTipo().getId();
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.documento.setCnpjCpf(cnpjCpf);
    }

    public String getCnpjCpf() {
        return this.documento.getCnpjCpf();
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.documento.setDataEmissao(dataEmissao);
    }

    public LocalDate getDataEmissao() {
        return this.documento.getDataEmissao();
    }

    public void setDataValidade(LocalDate dataValidade) {
        this.documento.setDataValidade(dataValidade);
    }

    public LocalDate getDataValidade() {
        return this.documento.getDataValidade();
    }

    public void setFinalidade(DocumentoFinalidade finalidade) {
        this.documento.setDocumentoFinalidade(finalidade);
    }

    public String getFinalidade() {
        return this.documento.getDocumentoFinalidade().getDescricao();
    }

    public void setOutraFinalidade(String outraFinalidade) {
        this.documento.setOutraFinalidade(outraFinalidade);
    }

    public String getOutraFinalidade() {
        return this.documento.getOutraFinalidade();
    }

    public CadastroGeralDTO getCadastro() {
        return this.cadastro;
    }

    public void setCadastro(CadastroGeralDTO cadastro) {
        this.cadastro = cadastro;
    }

    public void setRequerente(String requerente) {
        this.documento.setRequerente(requerente);
    }

    public String getRequerente() {
        return this.documento.getRequerente();
    }

    public void setCpfRequerente(String cpfRequerente) {
        this.documento.setCpfRequerente(cpfRequerente);
    }

    public String getCpfRequerente() {
        return this.documento.getCpfRequerente();
    }

    public void setTipoPessoaRequerente(TipoPessoa tipoPessoaRequerente) {
        this.documento.setTipoPessoaRequerente(tipoPessoaRequerente);
    }

    public TipoPessoa getTipoPessoaRequerente() {
        return this.documento.getTipoPessoaRequerente();
    }

    public PessoaDTO getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(PessoaDTO pessoa) {
        this.pessoa = pessoa;
    }

    public DocumentoMobileDTO from() {
        Optional.ofNullable(this.documento.getDocumento()).ifPresent(arg_0 -> this.setDocumento(arg_0));
        Optional.ofNullable(this.documento.getExercicio()).ifPresent(arg_0 -> this.setExercicio(arg_0));
        Optional.ofNullable(this.documento.getCodigoValidacao()).ifPresent(arg_0 -> this.setCodigoAutenticidade(arg_0));
        Optional.ofNullable(this.urlImpressao).ifPresent(arg_0 -> this.setUrlImpressao(arg_0));
        Optional.ofNullable(this.documento.getDataValidade()).ifPresent(arg_0 -> this.setDataValidade(arg_0));
        Optional.ofNullable(this.documento.getOutraFinalidade()).ifPresent(arg_0 -> this.setOutraFinalidade(arg_0));
        Optional.ofNullable(this.getSituacao()).ifPresent(arg_0 -> this.setSituacao(arg_0));
        Optional.ofNullable(this.documento.getDocumentoFinalidade()).ifPresent(arg_0 -> this.setFinalidade(arg_0));
        Optional.ofNullable(this.documento.getTipoPessoaRequerente()).ifPresent(arg_0 -> this.setTipoPessoaRequerente(arg_0));
        Optional.ofNullable(this.documento.getDocumentoTipo()).ifPresent(arg_0 -> this.setTipoDocumento(arg_0));
        Optional.ofNullable(this.documento.getCnpjCpf()).ifPresent(arg_0 -> this.setCnpjCpf(arg_0));
        Optional.ofNullable(this.documento.getDocumentoTipo()).ifPresent(tipoDocumento -> this.setDescricao());
        Optional.ofNullable(this.documento.getCpfRequerente()).ifPresent(arg_0 -> this.setCpfRequerente(arg_0));
        Optional.ofNullable(this.documento.getRequerente()).ifPresent(arg_0 -> this.setRequerente(arg_0));
        Optional.ofNullable(this.documento.getDataEmissao()).ifPresent(arg_0 -> this.setDataEmissao(arg_0));
        Optional.ofNullable(this.documento.getPessoa()).ifPresent(arg_0 -> this.loadAndSetPessoa(arg_0));
        if (Optional.ofNullable(this.documento.getCadastroGeral()).isPresent()) {
            if (this.documento.getCadastroGeral().getTipoCadastro().isImobiliario().booleanValue()) {
                this.setCadastro(this.cadastroImobiliarioEntity.toCadastroGeralDTO());
                this.setCadastroImobiliarioEntity(null);
            } else {
                this.setCadastro(this.documento.getCadastroGeral().toCadastroGeralDTO());
            }
        }
        return this;
    }

    private void loadAndSetPessoa(Pessoa pessoa) {
        PessoaDTO dto = new PessoaDTO();
        Optional.ofNullable(pessoa.getId()).ifPresent(arg_0 -> ((PessoaDTO)dto).setPessoa(arg_0));
        Optional.ofNullable(pessoa.getCnpjCpf()).ifPresent(arg_0 -> ((PessoaDTO)dto).setCnpjCpf(arg_0));
        Optional.ofNullable(pessoa.getTipoPessoa().getValue()).ifPresent(arg_0 -> ((PessoaDTO)dto).setTipoPessoa(arg_0));
        Optional.ofNullable(pessoa.getNome()).ifPresent(arg_0 -> ((PessoaDTO)dto).setNome(arg_0));
        Optional.ofNullable(pessoa.getNomeFantasia()).ifPresent(arg_0 -> ((PessoaDTO)dto).setNomeFantasia(arg_0));
        if (Optional.ofNullable(pessoa.getEnderecoPrincipal()).isPresent()) {
            EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
            Optional.ofNullable(enderecoPrincipal.getCidade()).ifPresent(cidade -> dto.setCidade(cidade.getDescricao()));
            Optional.ofNullable(enderecoPrincipal.getCidade()).ifPresent(cidade -> dto.setUf(cidade.getUnidadeFederacao()));
            Optional.ofNullable(enderecoPrincipal.getBairro()).ifPresent(bairro -> dto.setBairro(bairro.getDescricao()));
            if (Optional.ofNullable(enderecoPrincipal.getLogradouro()).isPresent()) {
                Logradouro logradouro = enderecoPrincipal.getLogradouro();
                Optional.ofNullable(logradouro.getTipoLogradouro()).ifPresent(tipo -> dto.setTipoLogradouro(tipo.getDescricao()));
                Optional.ofNullable(logradouro).ifPresent(endereco -> dto.setLogradouro(endereco.getDescricao()));
            }
            Optional.ofNullable(enderecoPrincipal.getNumero()).ifPresent(arg_0 -> ((PessoaDTO)dto).setNumero(arg_0));
            Optional.ofNullable(enderecoPrincipal.getComplemento()).ifPresent(arg_0 -> ((PessoaDTO)dto).setComplemento(arg_0));
            Optional.ofNullable(enderecoPrincipal.getCep().toString()).ifPresent(arg_0 -> ((PessoaDTO)dto).setCep(arg_0));
        }
        this.setPessoa(dto);
    }
}

