/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroBoletoDTO {
    private String boleto;
    private String exercicioBoleto;
    private Long tipoCadastro;
    private String cadastroGeral;
    private String exercicioDebito;
    private String divida;
    private String subDivida;
    private String parcela;
    private String nossoNumeroCodBarrasLinhaDigitavel;

    private String addAND(String clausula) {
        return " and " + clausula;
    }

    private void validaFiltro() {
        if (StringUtils.isBlank((CharSequence)this.boleto) && StringUtils.isBlank((CharSequence)this.exercicioBoleto) && Objects.isNull(this.tipoCadastro) && StringUtils.isBlank((CharSequence)this.cadastroGeral) && StringUtils.isBlank((CharSequence)this.exercicioDebito) && StringUtils.isBlank((CharSequence)this.divida) && StringUtils.isBlank((CharSequence)this.subDivida) && StringUtils.isBlank((CharSequence)this.parcela) && StringUtils.isBlank((CharSequence)this.nossoNumeroCodBarrasLinhaDigitavel)) {
            throw new EloValidationException("\u00c9 necess\u00e1rio informar ao menos um filtro.");
        }
        this.validaFiltroCadastro();
        this.validaFiltroBoleto();
        this.validaFiltroDebito();
    }

    private void validaFiltroDebito() {
        if (StringUtils.isBlank((CharSequence)this.cadastroGeral) && StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            throw new EloValidationException("Informe o tipo cadastro e cadastro do d\u00e9bito.");
        }
        if (StringUtils.isBlank((CharSequence)this.exercicioDebito) && StringUtils.isNotBlank((CharSequence)this.divida)) {
            throw new EloValidationException("Informe o tipo cadastro, cadastro e exerc\u00edcio do d\u00e9bito.");
        }
        if (StringUtils.isBlank((CharSequence)this.divida) && StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            throw new EloValidationException("Informe o tipo cadastro, cadastro, exerc\u00edcio e divida do d\u00e9bito.");
        }
        if (StringUtils.isBlank((CharSequence)this.subDivida) && StringUtils.isNotBlank((CharSequence)this.parcela)) {
            throw new EloValidationException("Informe a tipo cadastro, cadastro, exerc\u00edcio e divida, sub d\u00edvida e parcela do d\u00e9bito.");
        }
    }

    private void validaFiltroBoleto() {
        if (StringUtils.isBlank((CharSequence)this.boleto) && StringUtils.isNotBlank((CharSequence)this.exercicioBoleto)) {
            throw new EloValidationException("Informe o n\u00famero do boleto.");
        }
    }

    private void validaFiltroCadastro() {
        if (Objects.isNull(this.tipoCadastro) && StringUtils.isNotBlank((CharSequence)this.cadastroGeral) || Objects.nonNull(this.tipoCadastro) && StringUtils.isBlank((CharSequence)this.cadastroGeral)) {
            throw new EloValidationException("Filtro do cadastro est\u00e1 inv\u00e1lido.");
        }
    }

    public String buildFiltro() {
        this.validaFiltro();
        StringBuilder filtro = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.boleto)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.boleto, (String)"boleto.bloqueto")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioBoleto)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioBoleto, (String)"boleto.exercicioBloqueto")));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            filtro.append(this.addAND(String.format("debitoParcela.id.tipoCadastro=%s", this.tipoCadastro)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"debitoParcela.id.cadastroGeral")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"debitoParcela.id.exercicio")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"debitoParcela.id.divida")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"debitoParcela.id.subDivida")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.parcela)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.parcela, (String)"debitoParcela.id.parcela")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.nossoNumeroCodBarrasLinhaDigitavel)) {
            filtro.append(this.addAND(String.format("(boleto.nossoNumero='%s' or boleto.codigoBarras='%s' or concat(boleto.campo1, boleto.campo2, boleto.campo3, boleto.campo4, coalesce(boleto.campo5,''))='%s')", this.nossoNumeroCodBarrasLinhaDigitavel, this.nossoNumeroCodBarrasLinhaDigitavel, this.nossoNumeroCodBarrasLinhaDigitavel)));
        }
        return filtro.toString();
    }

    @Generated
    public FiltroBoletoDTO() {
    }

    @Generated
    public String getBoleto() {
        return this.boleto;
    }

    @Generated
    public String getExercicioBoleto() {
        return this.exercicioBoleto;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getParcela() {
        return this.parcela;
    }

    @Generated
    public String getNossoNumeroCodBarrasLinhaDigitavel() {
        return this.nossoNumeroCodBarrasLinhaDigitavel;
    }

    @Generated
    public void setBoleto(String boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setExercicioBoleto(String exercicioBoleto) {
        this.exercicioBoleto = exercicioBoleto;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(String parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setNossoNumeroCodBarrasLinhaDigitavel(String nossoNumeroCodBarrasLinhaDigitavel) {
        this.nossoNumeroCodBarrasLinhaDigitavel = nossoNumeroCodBarrasLinhaDigitavel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroBoletoDTO)) {
            return false;
        }
        FiltroBoletoDTO other = (FiltroBoletoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        String this$boleto = this.getBoleto();
        String other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !this$boleto.equals(other$boleto)) {
            return false;
        }
        String this$exercicioBoleto = this.getExercicioBoleto();
        String other$exercicioBoleto = other.getExercicioBoleto();
        if (this$exercicioBoleto == null ? other$exercicioBoleto != null : !this$exercicioBoleto.equals(other$exercicioBoleto)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        String this$parcela = this.getParcela();
        String other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !this$parcela.equals(other$parcela)) {
            return false;
        }
        String this$nossoNumeroCodBarrasLinhaDigitavel = this.getNossoNumeroCodBarrasLinhaDigitavel();
        String other$nossoNumeroCodBarrasLinhaDigitavel = other.getNossoNumeroCodBarrasLinhaDigitavel();
        return !(this$nossoNumeroCodBarrasLinhaDigitavel == null ? other$nossoNumeroCodBarrasLinhaDigitavel != null : !this$nossoNumeroCodBarrasLinhaDigitavel.equals(other$nossoNumeroCodBarrasLinhaDigitavel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroBoletoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        String $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : $boleto.hashCode());
        String $exercicioBoleto = this.getExercicioBoleto();
        result = result * 59 + ($exercicioBoleto == null ? 43 : $exercicioBoleto.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        String $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : $parcela.hashCode());
        String $nossoNumeroCodBarrasLinhaDigitavel = this.getNossoNumeroCodBarrasLinhaDigitavel();
        result = result * 59 + ($nossoNumeroCodBarrasLinhaDigitavel == null ? 43 : $nossoNumeroCodBarrasLinhaDigitavel.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroBoletoDTO(boleto=" + this.getBoleto() + ", exercicioBoleto=" + this.getExercicioBoleto() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", nossoNumeroCodBarrasLinhaDigitavel=" + this.getNossoNumeroCodBarrasLinhaDigitavel() + ")";
    }
}

