/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class DocumentoDividaAtivaDTO {
    private Long exercicioLivro;
    private Long livro;
    private Long exercicioDebito;
    private Long divida;
    private String dividaDescricao;
    private Long subDivida;
    private Long parcela;
    private String tributo;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private Long numeroInscricao;
    private LocalDate dataInscricao;
    private Long numeroFolha;
    private Long idDebito;

    public static DocumentoDividaAtivaDTO from(DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        DocumentoDividaAtivaDTO dto = new DocumentoDividaAtivaDTO();
        Optional.ofNullable(documentoItemDividaAtiva.getLivro()).ifPresent(livro -> {
            dto.setLivro(livro.getId().getLivro());
            dto.setExercicioLivro(livro.getId().getExercicio());
            dto.setDataInscricao(livro.getDataInclusao());
        });
        dto.setExercicioDebito(documentoItemDividaAtiva.getExercicioDebito());
        dto.setDivida(documentoItemDividaAtiva.getDivida().getDivida());
        dto.setDividaDescricao(documentoItemDividaAtiva.getDivida().getDescricao());
        dto.setSubDivida(documentoItemDividaAtiva.getSubDivida());
        dto.setParcela(documentoItemDividaAtiva.getParcela());
        dto.setTributo(documentoItemDividaAtiva.getTributo());
        dto.setValor(documentoItemDividaAtiva.getValor());
        dto.setValorJuros(documentoItemDividaAtiva.getValorJuros());
        dto.setValorMulta(documentoItemDividaAtiva.getValorMulta());
        dto.setValorCorrecao(documentoItemDividaAtiva.getValorCorrecao());
        dto.setValorTotal(documentoItemDividaAtiva.getTotal());
        dto.setNumeroInscricao(documentoItemDividaAtiva.getNumeroInscricao());
        dto.setNumeroFolha(documentoItemDividaAtiva.getNumeroFolha());
        Optional.ofNullable(documentoItemDividaAtiva.getDebito()).ifPresent(debito -> dto.setIdDebito(debito.getId()));
        return dto;
    }

    @Generated
    public DocumentoDividaAtivaDTO() {
    }

    @Generated
    public Long getExercicioLivro() {
        return this.exercicioLivro;
    }

    @Generated
    public Long getLivro() {
        return this.livro;
    }

    @Generated
    public Long getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public String getDividaDescricao() {
        return this.dividaDescricao;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Long getNumeroInscricao() {
        return this.numeroInscricao;
    }

    @Generated
    public LocalDate getDataInscricao() {
        return this.dataInscricao;
    }

    @Generated
    public Long getNumeroFolha() {
        return this.numeroFolha;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public void setExercicioLivro(Long exercicioLivro) {
        this.exercicioLivro = exercicioLivro;
    }

    @Generated
    public void setLivro(Long livro) {
        this.livro = livro;
    }

    @Generated
    public void setExercicioDebito(Long exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setDividaDescricao(String dividaDescricao) {
        this.dividaDescricao = dividaDescricao;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setNumeroInscricao(Long numeroInscricao) {
        this.numeroInscricao = numeroInscricao;
    }

    @Generated
    public void setDataInscricao(LocalDate dataInscricao) {
        this.dataInscricao = dataInscricao;
    }

    @Generated
    public void setNumeroFolha(Long numeroFolha) {
        this.numeroFolha = numeroFolha;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoDividaAtivaDTO)) {
            return false;
        }
        DocumentoDividaAtivaDTO other = (DocumentoDividaAtivaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$exercicioLivro = this.getExercicioLivro();
        Long other$exercicioLivro = other.getExercicioLivro();
        if (this$exercicioLivro == null ? other$exercicioLivro != null : !((Object)this$exercicioLivro).equals(other$exercicioLivro)) {
            return false;
        }
        Long this$livro = this.getLivro();
        Long other$livro = other.getLivro();
        if (this$livro == null ? other$livro != null : !((Object)this$livro).equals(other$livro)) {
            return false;
        }
        Long this$exercicioDebito = this.getExercicioDebito();
        Long other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !((Object)this$exercicioDebito).equals(other$exercicioDebito)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$numeroInscricao = this.getNumeroInscricao();
        Long other$numeroInscricao = other.getNumeroInscricao();
        if (this$numeroInscricao == null ? other$numeroInscricao != null : !((Object)this$numeroInscricao).equals(other$numeroInscricao)) {
            return false;
        }
        Long this$numeroFolha = this.getNumeroFolha();
        Long other$numeroFolha = other.getNumeroFolha();
        if (this$numeroFolha == null ? other$numeroFolha != null : !((Object)this$numeroFolha).equals(other$numeroFolha)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        String this$dividaDescricao = this.getDividaDescricao();
        String other$dividaDescricao = other.getDividaDescricao();
        if (this$dividaDescricao == null ? other$dividaDescricao != null : !this$dividaDescricao.equals(other$dividaDescricao)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        LocalDate this$dataInscricao = this.getDataInscricao();
        LocalDate other$dataInscricao = other.getDataInscricao();
        return !(this$dataInscricao == null ? other$dataInscricao != null : !((Object)this$dataInscricao).equals(other$dataInscricao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoDividaAtivaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $exercicioLivro = this.getExercicioLivro();
        result = result * 59 + ($exercicioLivro == null ? 43 : ((Object)$exercicioLivro).hashCode());
        Long $livro = this.getLivro();
        result = result * 59 + ($livro == null ? 43 : ((Object)$livro).hashCode());
        Long $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : ((Object)$exercicioDebito).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $numeroInscricao = this.getNumeroInscricao();
        result = result * 59 + ($numeroInscricao == null ? 43 : ((Object)$numeroInscricao).hashCode());
        Long $numeroFolha = this.getNumeroFolha();
        result = result * 59 + ($numeroFolha == null ? 43 : ((Object)$numeroFolha).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        String $dividaDescricao = this.getDividaDescricao();
        result = result * 59 + ($dividaDescricao == null ? 43 : $dividaDescricao.hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        LocalDate $dataInscricao = this.getDataInscricao();
        result = result * 59 + ($dataInscricao == null ? 43 : ((Object)$dataInscricao).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocumentoDividaAtivaDTO(exercicioLivro=" + this.getExercicioLivro() + ", livro=" + this.getLivro() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", dividaDescricao=" + this.getDividaDescricao() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", tributo=" + this.getTributo() + ", valor=" + this.getValor() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorTotal=" + this.getValorTotal() + ", numeroInscricao=" + this.getNumeroInscricao() + ", dataInscricao=" + this.getDataInscricao() + ", numeroFolha=" + this.getNumeroFolha() + ", idDebito=" + this.getIdDebito() + ")";
    }
}

