/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.converter.LadoQuadraConverter;
import br.com.elotech.tributos.domain.LadoQuadra;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestadaExercicio;
import br.com.elotech.tributos.domain.Quadricula;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.camposdinamicos.DynamicValidation;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaLogradouro;
import br.com.elotech.tributos.util.ListUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.springframework.util.Assert;

@Entity
@Table(name="TRIBLOGRADOUROTESTADA")
@Audited
public class LogradouroTestada
implements EloEntity<Long> {
    @Id
    @Caption(value="Id.")
    @Column(name="IDLOGRADOUROTESTADA")
    @EloSequence(sequenceName="S05IDLOGRADOUROTESTADA")
    private Long id;
    @ManyToOne
    @JoinColumn(name="LOGRADOURO_IDKEY")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Logradouro")
    @DynamicValidation(label="Logradouro")
    private Logradouro logradouro;
    @Column(length=15)
    @Caption(value="Face Quadra")
    private String faceQuadra;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="distrito", referencedColumnName="distrito"), @JoinColumn(name="setor", referencedColumnName="setor"), @JoinColumn(name="quadra", referencedColumnName="quadra")})
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Quadra")
    private SetorQuadra setorQuadra;
    @ManyToOne
    @JoinColumn(name="DELIMITACAOINICIAL_IDKEY")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DynamicValidation(label="Logradouro Inicial")
    private Logradouro logradouroInicial;
    @ManyToOne
    @JoinColumn(name="DELIMITACAOFINAL_IDKEY")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DynamicValidation(label="Logradouro Final")
    private Logradouro logradouroFinal;
    @Column(name="lado")
    @Caption(value="Lado Quadra")
    @Convert(converter=LadoQuadraConverter.class)
    private LadoQuadra lado;
    @Column(length=20)
    @Caption(value="Quadra Oposta")
    private String quadraOposta;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Exclus\u00e3o L\u00f3gica")
    private Boolean exclusaoLogica = Boolean.FALSE;
    @ManyToOne
    @JoinColumn
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Quadricula quadricula;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="IDLOGRADOUROTESTADA", updatable=false, nullable=false)
    @Caption(value="Testadas por Exerc\u00edcio")
    @NotAudited
    @OrderBy(value="exercicio DESC, sequencia DESC")
    private final List<LogradouroTestadaExercicio> logradouroTestadaExercicios = new ArrayList();
    @NotAudited
    @JsonIgnore
    @MetaModelIgnore
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="logradouroTestada")
    @Caption(value="Boletim Logradouro")
    private final List<RespostaLogradouro> respostasLogradouro = new ArrayList();

    private void updateReferenciaRespostaLogradouro() {
        this.respostasLogradouro.forEach(respostaLogradouro -> {
            if (Objects.isNull(respostaLogradouro.getLogradouroTestada())) {
                respostaLogradouro.setLogradouroTestada(this);
            }
        });
    }

    public LogradouroTestada mergeRespostasLogradouro(List<RespostaLogradouro> respostas) {
        List respostasMerged = ListUtils.merge((List)this.getRespostasLogradouro(), respostas, Resposta::getId, RespostaLogradouro::merge);
        this.getRespostasLogradouro().clear();
        this.getRespostasLogradouro().addAll(respostasMerged);
        this.updateReferenciaRespostaLogradouro();
        return this;
    }

    public LogradouroTestada mergeGeomais(LogradouroTestada logradouroTestadaToMerge) {
        Assert.isTrue((boolean)logradouroTestadaToMerge.getId().equals(this.getId()), (String)"Para fazer o merge, os cadastros devem ter o mesmo id");
        this.setFaceQuadra(logradouroTestadaToMerge.getFaceQuadra());
        this.setLado(logradouroTestadaToMerge.getLado());
        this.setLogradouro(logradouroTestadaToMerge.getLogradouro());
        this.setSetorQuadra(logradouroTestadaToMerge.getSetorQuadra());
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogradouroTestada)) {
            return false;
        }
        LogradouroTestada other = (LogradouroTestada)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogradouroTestada;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public LogradouroTestada() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getFaceQuadra() {
        return this.faceQuadra;
    }

    @Generated
    public SetorQuadra getSetorQuadra() {
        return this.setorQuadra;
    }

    @Generated
    public Logradouro getLogradouroInicial() {
        return this.logradouroInicial;
    }

    @Generated
    public Logradouro getLogradouroFinal() {
        return this.logradouroFinal;
    }

    @Generated
    public LadoQuadra getLado() {
        return this.lado;
    }

    @Generated
    public String getQuadraOposta() {
        return this.quadraOposta;
    }

    @Generated
    public Boolean getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public Quadricula getQuadricula() {
        return this.quadricula;
    }

    @Generated
    public List<LogradouroTestadaExercicio> getLogradouroTestadaExercicios() {
        return this.logradouroTestadaExercicios;
    }

    @Generated
    public List<RespostaLogradouro> getRespostasLogradouro() {
        return this.respostasLogradouro;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setFaceQuadra(String faceQuadra) {
        this.faceQuadra = faceQuadra;
    }

    @Generated
    public void setSetorQuadra(SetorQuadra setorQuadra) {
        this.setorQuadra = setorQuadra;
    }

    @Generated
    public void setLogradouroInicial(Logradouro logradouroInicial) {
        this.logradouroInicial = logradouroInicial;
    }

    @Generated
    public void setLogradouroFinal(Logradouro logradouroFinal) {
        this.logradouroFinal = logradouroFinal;
    }

    @Generated
    public void setLado(LadoQuadra lado) {
        this.lado = lado;
    }

    @Generated
    public void setQuadraOposta(String quadraOposta) {
        this.quadraOposta = quadraOposta;
    }

    @Generated
    public void setExclusaoLogica(Boolean exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setQuadricula(Quadricula quadricula) {
        this.quadricula = quadricula;
    }

    @Generated
    public String toString() {
        return "LogradouroTestada(id=" + this.getId() + ", logradouro=" + this.getLogradouro() + ", faceQuadra=" + this.getFaceQuadra() + ", setorQuadra=" + this.getSetorQuadra() + ", logradouroInicial=" + this.getLogradouroInicial() + ", logradouroFinal=" + this.getLogradouroFinal() + ", lado=" + this.getLado() + ", quadraOposta=" + this.getQuadraOposta() + ", exclusaoLogica=" + this.getExclusaoLogica() + ", quadricula=" + this.getQuadricula() + ", logradouroTestadaExercicios=" + this.getLogradouroTestadaExercicios() + ", respostasLogradouro=" + this.getRespostasLogradouro() + ")";
    }
}

