/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornodeducaocredito;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCancelamento;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCancelamentoId;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCredito;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCreditoCredito;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoCreditoCreditoId;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoPagamento;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoPagamentoId;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoParcelamento;
import br.com.elotech.tributos.domain.simam.EstornoDeducaoParcelamentoId;
import br.com.elotech.tributos.domain.simam.EstornoTipoDeducaoCredito;
import br.com.elotech.tributos.dto.simam.EstornoDeducaoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoBatchRepository;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoDeducaoCreditoBatchProcessor
implements ItemProcessor<EstornoDeducaoCreditoConsultaDTO, EstornoTipoDeducaoCredito> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoDeducaoCreditoBatchProcessor.class);
    private static final String ESTORNO_DEDUCAO_CREDITO = "SIM-AM - Estorno Dedu\u00e7\u00f5es de Cr\u00e9ditos - ";
    private final AtomicLong ultimoNrEstorno = new AtomicLong(0L);
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final EstornoDeducaoCreditoBatchRepository estornoDeducaoCreditoBatchRepository;
    private final EstornoDeducaoCreditoRepository estornoDeducaoCreditoRepository;
    private final EntidadeRepository entidadeRepository;
    private final ObjectMapper objectMapper;
    private Long nrAnoEstorno;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        log.info("{}Iniciando gera\u00e7\u00e3o de dados", (Object)ESTORNO_DEDUCAO_CREDITO);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        log.info("{}Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{ESTORNO_DEDUCAO_CREDITO, dataInicial, dataFinal, entidade});
        this.nrAnoEstorno = dataInicial.getYear();
        log.info("{}load da carga existente", (Object)ESTORNO_DEDUCAO_CREDITO);
        this.estornoDeducaoCreditoRepository.getCargaEstornoDeducaoCredito(entidade, dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.buildChave(), item.getId()));
        log.info("{}atualizando \u00faltimo NrEstorno", (Object)ESTORNO_DEDUCAO_CREDITO);
        this.ultimoNrEstorno.set(this.estornoDeducaoCreditoBatchRepository.findNextNrEstornoByExercicio(Long.valueOf(dataInicial.getYear())));
    }

    public EstornoTipoDeducaoCredito process(EstornoDeducaoCreditoConsultaDTO dto) {
        String chave = String.format("%d-%d-%d-%s-%d", dto.getNrDeducao(), dto.getNrAnoDeducao(), dto.getIdAto(), dto.getDtEstorno().toString(), dto.getIdTipoCredito());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextVal = this.sequenceGeneratorRepository.getNextVal("s_estornodeducaocredito_id");
            EstornoDeducaoCredito estornoDeducaoCredito = new EstornoDeducaoCredito();
            estornoDeducaoCredito.setId(nextVal);
            estornoDeducaoCredito.setNrDeducao(dto.getNrDeducao());
            estornoDeducaoCredito.setNrAnoDeducao(dto.getNrAnoDeducao());
            estornoDeducaoCredito.setCdControleLeiAto(dto.getIdAto());
            estornoDeducaoCredito.setDtEstorno(dto.getDtEstorno());
            estornoDeducaoCredito.setVlEstorno(dto.getVlEstorno());
            estornoDeducaoCredito.setDsMotivo(dto.getDsMotivo());
            estornoDeducaoCredito.setNrEstorno(Long.valueOf(this.ultimoNrEstorno.getAndIncrement()));
            estornoDeducaoCredito.setNrAnoEstorno(this.nrAnoEstorno);
            estornoDeducaoCredito.setIdTipoCredito(dto.getIdTipoCredito());
            log.info("{}gerando novo registro -> {} ({}/{})", new Object[]{ESTORNO_DEDUCAO_CREDITO, nextVal, estornoDeducaoCredito.getNrEstorno(), estornoDeducaoCredito.getNrAnoEstorno()});
            this.estornoDeducaoCreditoBatchRepository.save((Object)estornoDeducaoCredito);
            this.entityManager.flush();
            return nextVal;
        });
        if (!Objects.equals(dto.getIdCancelamento(), 0L)) {
            EstornoDeducaoCancelamentoId id = new EstornoDeducaoCancelamentoId();
            id.setEstornoDeducaoCredito((EstornoDeducaoCredito)this.entityManager.getReference(EstornoDeducaoCredito.class, (Object)finalId));
            id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)dto.getIdDebitoParcelaReceita()));
            id.setEntidade((Entidade)this.entidadeRepository.getOne((Object)dto.getEntidade()));
            id.setExercicio(dto.getExercicio());
            id.setIdCancelamento(dto.getIdCancelamento());
            EstornoDeducaoCancelamento estornoDeducaoCancelamento = new EstornoDeducaoCancelamento();
            estornoDeducaoCancelamento.setId(id);
            estornoDeducaoCancelamento.setValor(dto.getVlEstorno());
            return estornoDeducaoCancelamento;
        }
        if (!Objects.equals(dto.getIdPagamentoBloqueto(), 0L)) {
            EstornoDeducaoPagamentoId id = new EstornoDeducaoPagamentoId();
            id.setEstornoDeducaoCredito((EstornoDeducaoCredito)this.entityManager.getReference(EstornoDeducaoCredito.class, (Object)finalId));
            id.setIdPagamentoBoleto(dto.getIdPagamentoBloqueto());
            id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)dto.getIdDebitoParcelaReceita()));
            EstornoDeducaoPagamento estornoDeducaoPagamento = new EstornoDeducaoPagamento();
            estornoDeducaoPagamento.setId(id);
            estornoDeducaoPagamento.setValor(dto.getVlEstorno());
            return estornoDeducaoPagamento;
        }
        if (!Objects.equals(dto.getIdParcelamento(), 0L)) {
            EstornoDeducaoParcelamentoId id = new EstornoDeducaoParcelamentoId();
            id.setEstornoDeducaoCredito((EstornoDeducaoCredito)this.entityManager.getReference(EstornoDeducaoCredito.class, (Object)finalId));
            id.setIdParcelamento(dto.getIdParcelamento());
            id.setIdEstornoParcelamento(dto.getIdEstornoParcelamento());
            id.setIdDebitoReceita(dto.getIdDebitoParcelaReceita());
            EstornoDeducaoParcelamento estornoDeducaoParcelamento = new EstornoDeducaoParcelamento();
            estornoDeducaoParcelamento.setId(id);
            estornoDeducaoParcelamento.setValor(dto.getVlEstorno());
            return estornoDeducaoParcelamento;
        }
        EstornoDeducaoCreditoCreditoId id = new EstornoDeducaoCreditoCreditoId();
        id.setEstornoDeducaoCredito((EstornoDeducaoCredito)this.entityManager.getReference(EstornoDeducaoCredito.class, (Object)finalId));
        id.setCreditoContribuinteItem(dto.getIdCreditoContribuinteItem());
        id.setIdDebitoParcelaReceita(dto.getIdDebitoParcelaReceita());
        EstornoDeducaoCreditoCredito estornoDeducaoCreditoCredito = new EstornoDeducaoCreditoCredito();
        estornoDeducaoCreditoCredito.setId(id);
        return estornoDeducaoCreditoCredito;
    }

    @OnProcessError
    public void onProcessError(EstornoDeducaoCreditoConsultaDTO item, Exception e) throws JsonProcessingException {
        log.error("{}erro: {}\n{})", new Object[]{ESTORNO_DEDUCAO_CREDITO, e.getMessage(), this.objectMapper.writeValueAsString((Object)item)});
    }

    @Generated
    public EstornoDeducaoCreditoBatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, EstornoDeducaoCreditoBatchRepository estornoDeducaoCreditoBatchRepository, EstornoDeducaoCreditoRepository estornoDeducaoCreditoRepository, EntidadeRepository entidadeRepository, ObjectMapper objectMapper) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.estornoDeducaoCreditoBatchRepository = estornoDeducaoCreditoBatchRepository;
        this.estornoDeducaoCreditoRepository = estornoDeducaoCreditoRepository;
        this.entidadeRepository = entidadeRepository;
        this.objectMapper = objectMapper;
    }
}

