/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.simulacaocalculo;

import br.com.elotech.tributos.dto.ComunicadoSimulacaoCalculoDTO;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JpaPagingItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoSimulacaoCalculoBatchReader
extends JpaPagingItemReader<ComunicadoSimulacaoCalculoDTO> {
    private static final String ID_CALCULO = "idCalculo";

    public ComunicadoSimulacaoCalculoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, EntityManagerFactory entityManagerFactory) {
        Long idConsulta = (Long)jobParameters.get(ID_CALCULO);
        this.setPageSize(500);
        this.setName(ID_CALCULO);
        this.setEntityManagerFactory(entityManagerFactory);
        this.setQueryString(" select new br.com.elotech.tributos.dto.ComunicadoSimulacaoCalculoDTO( calc.id as calculoId, tcg.tipoCadastro , tcg.cadastroGeral, tcg.id, tcg.pessoa, p.nome as nomePessoa, sum(res.valor) as valor) from Calculo calc join calc.cadastros calcad join calcad.resultados res left join calcad.cadastro tcg left join tcg.pessoa p where calc.id = :idConsulta group by calc.id, tcg.tipoCadastro , tcg.cadastroGeral, tcg.id, tcg.pessoa, p.nome");
        this.setParameterValues(Collections.singletonMap("idConsulta", idConsulta));
    }
}

