/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.manual;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.batch.ComunicadoGeracaoBatchProcessor;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoCadastroId;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.ComunicadoConsultaReceitas;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoManualBatchProcessor
extends ComunicadoGeracaoBatchProcessor {
    protected ComunicadoManualBatchProcessor(ComunicadoCadastroService comunicadoCadastroService, EntityManager entityManager, ObjectMapper objectMapper) {
        super(comunicadoCadastroService, entityManager, objectMapper);
        LOG_PARAM = "COMUNICADO - Gera\u00e7\u00e3o manual ";
    }

    public ComunicadoCadastro process(ComunicadoDebitoConsultaDTO comunicadoDebitoConsultaDTO) {
        Long entidade = this.stepExecution.getJobExecution().getJobParameters().getLong("entidade");
        Long exercicioComunicado = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicioComunicado");
        Long idComunicadoParam = this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado");
        ComunicadoId idComunicado = new ComunicadoId();
        idComunicado.setIdComunicado(idComunicadoParam);
        idComunicado.setEntidade(entidade);
        idComunicado.setExercicio(exercicioComunicado);
        Comunicado comunicado = new Comunicado();
        comunicado.setId(idComunicado);
        ComunicadoCadastroId idComunicadoCadastro = new ComunicadoCadastroId();
        idComunicadoCadastro.setComunicado(comunicado);
        idComunicadoCadastro.setSequencia(Long.valueOf(this.sequencia.getAndIncrement()));
        ComunicadoCadastro comunicadoCadastro = new ComunicadoCadastro();
        comunicadoCadastro.setId(idComunicadoCadastro);
        comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.PRONTO_PARA_IMPRESSAO);
        comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.PRONTO_PARA_IMPRESSAO.getDescricao());
        Pessoa pessoa = new Pessoa();
        pessoa.setId(comunicadoDebitoConsultaDTO.getCodigoPessoa());
        comunicadoCadastro.setPessoa(pessoa);
        CadastroGeral cadastroGeral = new CadastroGeral();
        cadastroGeral.setId(comunicadoDebitoConsultaDTO.getIdCadastro());
        cadastroGeral.setTipoCadastro(TipoCadastro.fromValue((Long)comunicadoDebitoConsultaDTO.getTipocadastro()));
        cadastroGeral.setCadastroGeral(comunicadoDebitoConsultaDTO.getCadastrogeral());
        comunicadoCadastro.setCadastroGeral(cadastroGeral);
        this.comunicadoCadastroService.save((EloEntity)comunicadoCadastro, null);
        this.em.flush();
        return comunicadoCadastro;
    }

    protected List<ComunicadoConsultaReceitas> findReceitas(ComunicadoDebitoConsultaDTO comunicadoDebitoConsultaDTO) {
        return Collections.emptyList();
    }
}

