/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.batch.comunicadolivroda.ComunicadoLivroDABatchProcessor;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoCadastroId;
import br.com.elotech.tributos.domain.ComunicadoDebito;
import br.com.elotech.tributos.domain.ComunicadoDebitoId;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.ComunicadoConsultaReceitas;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.item.ItemProcessor;

public abstract class ComunicadoGeracaoBatchProcessor
implements ItemProcessor<ComunicadoDebitoConsultaDTO, ComunicadoCadastro> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComunicadoLivroDABatchProcessor.class);
    protected static String LOG_PARAM = "COMUNICADO - A partir de Livro DA - ";
    protected StepExecution stepExecution;
    protected final ComunicadoCadastroService comunicadoCadastroService;
    protected final EntityManager em;
    private final ObjectMapper objectMapper;
    protected AtomicLong sequencia;

    protected ComunicadoGeracaoBatchProcessor(ComunicadoCadastroService comunicadoCadastroService, EntityManager em, ObjectMapper objectMapper) {
        this.comunicadoCadastroService = comunicadoCadastroService;
        this.em = em;
        this.objectMapper = objectMapper;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        Long entidade = this.stepExecution.getJobExecution().getJobParameters().getLong("entidade");
        Long exercicioComunicado = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicioComunicado");
        Long idComunicadoParam = this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado");
        this.sequencia = this.comunicadoCadastroService.findNextSequencia(entidade, exercicioComunicado, idComunicadoParam);
        LOGGER.info(LOG_PARAM + "Iniciando gera\u00e7\u00e3o de dados");
    }

    public ComunicadoCadastro process(ComunicadoDebitoConsultaDTO comunicadoDebitoConsultaDTO) {
        Long entidade = this.stepExecution.getJobExecution().getJobParameters().getLong("entidade");
        Long exercicioComunicado = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicioComunicado");
        Long idComunicadoParam = this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado");
        ComunicadoId idComunicado = new ComunicadoId();
        idComunicado.setIdComunicado(idComunicadoParam);
        idComunicado.setEntidade(entidade);
        idComunicado.setExercicio(exercicioComunicado);
        Comunicado comunicado = new Comunicado();
        comunicado.setId(idComunicado);
        ComunicadoCadastroId idComunicadoCadastro = new ComunicadoCadastroId();
        idComunicadoCadastro.setComunicado(comunicado);
        idComunicadoCadastro.setSequencia(Long.valueOf(this.sequencia.getAndIncrement()));
        ComunicadoCadastro comunicadoCadastro = new ComunicadoCadastro();
        comunicadoCadastro.setId(idComunicadoCadastro);
        comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.SITUACAO_DEBITO);
        comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.SITUACAO_DEBITO.getDescricao());
        Pessoa pessoa = new Pessoa();
        pessoa.setId(comunicadoDebitoConsultaDTO.getCodigoPessoa());
        comunicadoCadastro.setPessoa(pessoa);
        CadastroGeral cadastroGeral = new CadastroGeral();
        cadastroGeral.setId(comunicadoDebitoConsultaDTO.getIdCadastro());
        cadastroGeral.setTipoCadastro(TipoCadastro.fromValue((Long)comunicadoDebitoConsultaDTO.getTipocadastro()));
        cadastroGeral.setCadastroGeral(comunicadoDebitoConsultaDTO.getCadastrogeral());
        comunicadoCadastro.setCadastroGeral(cadastroGeral);
        this.comunicadoCadastroService.save((EloEntity)comunicadoCadastro, null);
        this.em.flush();
        List receitas = this.findReceitas(comunicadoDebitoConsultaDTO);
        receitas.forEach(receita -> {
            ComunicadoDebitoId comunicadoDebitoId = new ComunicadoDebitoId();
            comunicadoDebitoId.setComunicadoCadastro(comunicadoCadastro);
            comunicadoDebitoId.setIdDebitoParcelaReceita(receita.getIdDebitoParcelaReceita());
            ComunicadoDebito comunicadoDebito = new ComunicadoDebito();
            comunicadoDebito.setId(comunicadoDebitoId);
            comunicadoDebito.setValorCorrecao(receita.getValorCorrecao());
            comunicadoDebito.setValorMulta(receita.getValorMulta());
            comunicadoDebito.setValorJuros(receita.getValorJuros());
            comunicadoDebito.setValorPrincipal(receita.getValor());
            comunicadoCadastro.getComunicadoDebitos().add(comunicadoDebito);
        });
        return comunicadoCadastro;
    }

    @OnProcessError
    public void onProcessError(ComunicadoDebitoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error(LOG_PARAM + "Erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }

    protected abstract List<ComunicadoConsultaReceitas> findReceitas(ComunicadoDebitoConsultaDTO var1);
}

