select
    debito.iddebito,
    parcelatributo.iddebitoparcelareceita,
    pessoa.pessoa,
    tributo.id as idtributo,
    tributo.classificacao as classificacaotributo,
    parcela.situacaolegal,
    contabancariaestorno.id as idcontacontabil,
    motivodeducao.motivodesconto as idmotivodeducao,
    tipooperacaotce.idtipooperacaotce as idtipooperacaodeducao,
    tributo.tiporeceita as tipoTributo,
    sum(coalesce(creditocontribuinteitem.valorprincipal,0)) as valorprincipal,
    sum(coalesce(creditocontribuinteitem.valorjuros,0)) as valorjuros,
    sum(coalesce(creditocontribuinteitem.valormulta,0)) as valormulta,
    sum(coalesce(creditocontribuinteitem.valorcorrecao,0)) as valorcorrecao,
    sum(coalesce(creditocontribuinteitem.valordescontoprincipal,0)) as valordescontoprincipal,
    sum(coalesce(creditocontribuinteitem.valordescontojuros,0)) as valordescontojuros,
    sum(coalesce(creditocontribuinteitem.valordescontomulta,0)) as valordescontomulta,
    sum(coalesce(creditocontribuinteitem.valordescontocorrecao,0)) as valordescontocorrecao,
    sum(coalesce(creditocontribuinteitem.valordescontojurosfinan,0)) as valordescontojurosfinan
from tribcreditocontribuinte creditocontribuinte
join tribcreditocontribuinteitem creditocontribuinteitem
	 on creditocontribuinte.entidade = creditocontribuinteitem.entidade
	and creditocontribuinte.exercicio = creditocontribuinteitem.exercicio
	and creditocontribuinte.creditocontribuinte = creditocontribuinteitem.creditocontribuinte
left join tribmotivodesconto motivodeducao on creditocontribuinte.motivodescontoestorno = motivodeducao.motivodesconto
left join tribtipooperacaotce tipooperacaotce on motivodeducao.idtipooperacaotce = tipooperacaotce.idtipooperacaotce
join contabancaria contabancariaestorno on creditocontribuinte.contabancariaestorno = contabancariaestorno.contabancaria
join tribdebitoparcelareceita parcelatributo on creditocontribuinteitem.iddebitoparcelareceita = parcelatributo.iddebitoparcelareceita
join tribreceita tributo
	 on parcelatributo.entidade = tributo.entidade
	and :exercicio = tributo.exercicio
	and parcelatributo.receita = tributo.receita
join tribdebitoparcela parcela
	 on parcelatributo.entidade = parcela.entidade
	and parcelatributo.exercicio = parcela.exercicio
	and parcelatributo.tipocadastro = parcela.tipocadastro
	and parcelatributo.cadastrogeral = parcela.cadastrogeral
	and parcelatributo.guiarecolhimento = parcela.guiarecolhimento
	and parcelatributo.subdivida = parcela.subdivida
	and parcelatributo.parcela = parcela.parcela
join tribdebito debito
	 on parcela.entidade = debito.entidade
	and parcela.exercicio = debito.exercicio
	and parcela.tipocadastro = debito.tipocadastro
	and parcela.cadastrogeral = debito.cadastrogeral
	and parcela.guiarecolhimento = debito.guiarecolhimento
	and parcela.subdivida = debito.subdivida
join tribcadastrogeral cadastrogeral
	 on debito.tipocadastro = cadastrogeral.tipocadastro
	and debito.cadastrogeral = cadastrogeral.cadastrogeral
join pessoa
	on cadastrogeral.pessoa = pessoa.pessoa
where contabancariaestorno.integraarrecadacao = 'S'
and creditocontribuinte.dataEstorno = :dataEstorno
and coalesce(creditocontribuinteitem.valorprincipal,0) > 0
group by debito.iddebito,
    parcelatributo.iddebitoparcelareceita,
    pessoa.pessoa,
    tributo.id,
    tributo.classificacao,
    parcela.situacaolegal,
    contabancariaestorno.id,
    motivodeducao.motivodesconto,
    tipooperacaotce.idtipooperacaotce,
    tributo.tiporeceita