/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.soap.client.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.soap.webservice.caixa.manutencao.DadosEntradaType;
import br.com.elotech.soap.webservice.caixa.manutencao.EnderecoType;
import br.com.elotech.soap.webservice.caixa.manutencao.IncluiBoletoEntradaType;
import br.com.elotech.soap.webservice.caixa.manutencao.JurosMoraType;
import br.com.elotech.soap.webservice.caixa.manutencao.MultaType;
import br.com.elotech.soap.webservice.caixa.manutencao.PagadorType;
import br.com.elotech.soap.webservice.caixa.manutencao.PagamentoType;
import br.com.elotech.soap.webservice.caixa.manutencao.PosVencimentoType;
import br.com.elotech.soap.webservice.caixa.manutencao.ServicoEntradaNegocialType;
import br.com.elotech.soap.webservice.caixa.manutencao.TIPOTYPE;
import br.com.elotech.soap.webservice.caixa.manutencao.TituloEntradaType;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoLogradouro;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.domain.cnab240.CNAB240Aceite;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoEspecieTitulo;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoJuros;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoMulta;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoProtesto;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.enums.cnab240.TipoAceite;
import br.com.elotech.tributos.enums.manutencaobancariacef.AcaoPosVencimento;
import br.com.elotech.tributos.enums.manutencaobancariacef.OperacaoServico;
import br.com.elotech.tributos.enums.manutencaobancariacef.SistemaOrigem;
import br.com.elotech.tributos.enums.manutencaobancariacef.TipoJurosMora;
import br.com.elotech.tributos.enums.manutencaobancariacef.TipoMulta;
import br.com.elotech.tributos.enums.manutencaobancariacef.TipoPagamento;
import br.com.elotech.tributos.enums.manutencaobancariacef.UsuarioServicoSGCP;
import br.com.elotech.tributos.enums.manutencaobancariacef.VersaoServico;
import br.com.elotech.tributos.util.BooleanToStringUtils;
import br.gov.caixa.sibar.HEADERBARRAMENTOTYPE;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ManutecaoCobrancaBancariaCEFDTO {
    private static final Short MOEDA_REAL = 9;
    private static final Short ESPECIE_OUTROS = 99;
    private static final Short QUANTIDADE_PAGAMENTO_PERMITIDO = 1;
    private static final Short DIAS_BAIXA_MINIMA = 0;
    private static final DateTimeFormatter DATETIMEFORMATTER_ANO_MES_DIA = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATETIMEFORMATER_YYYY_M_MDD_H_HMMSS = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter DATETIMEFORMATER_DD_M_MYYYY = DateTimeFormatter.ofPattern("ddMMyyyy");
    private static final int MAX_WIDTH_NOME_PAGADOR = 40;
    private static final int MAX_WIDTH_LOGRADOURO = 40;
    private static final int MAX_WIDTH_ENDERECO_PAGADOR = 15;
    private static final int MAX_WIDTH_UF_PAGADOR = 2;
    private static final int SCALE = 2;
    private ServicoEntradaNegocialType request;

    public static ManutecaoCobrancaBancariaCEFDTO from(Bloqueto boleto, ParametroCNAB240 parametrosCNAB240Caixa) {
        if (Objects.isNull(boleto) || Objects.isNull(parametrosCNAB240Caixa)) {
            return null;
        }
        ManutecaoCobrancaBancariaCEFDTO manutecaoCobrancaBancariaCEFDTO = new ManutecaoCobrancaBancariaCEFDTO();
        manutecaoCobrancaBancariaCEFDTO.setRequest(ManutecaoCobrancaBancariaCEFDTO.getRequestServicoEntradaNegocial((Bloqueto)boleto, (ParametroCNAB240)parametrosCNAB240Caixa));
        return manutecaoCobrancaBancariaCEFDTO;
    }

    private static ServicoEntradaNegocialType getRequestServicoEntradaNegocial(Bloqueto boleto, ParametroCNAB240 parametrosCNAB240Caixa) {
        ServicoEntradaNegocialType request = new ServicoEntradaNegocialType();
        Integer numeroConvenio = ManutecaoCobrancaBancariaCEFDTO.getConvenio((Bloqueto)boleto);
        request.setHEADER(ManutecaoCobrancaBancariaCEFDTO.getHeader((Bloqueto)boleto));
        request.getHEADER().setAUTENTICACAO(ManutecaoCobrancaBancariaCEFDTO.generateCodigoAutenticacao((Bloqueto)boleto, (ParametroCNAB240)parametrosCNAB240Caixa, (Integer)numeroConvenio));
        request.setDADOS(ManutecaoCobrancaBancariaCEFDTO.getBody((Bloqueto)boleto, (ParametroCNAB240)parametrosCNAB240Caixa, (Integer)numeroConvenio));
        return request;
    }

    private static HEADERBARRAMENTOTYPE getHeader(Bloqueto boleto) {
        HEADERBARRAMENTOTYPE header = new HEADERBARRAMENTOTYPE();
        header.setVERSAO(boleto.getModeloBloqueto().getConvenio().getUtilizaPix() != false ? VersaoServico.VERSION_THREE_DOT_TWO.getValue() : VersaoServico.VERSION_ONE_DOT_TWO.getValue());
        header.setUSUARIOSERVICO(UsuarioServicoSGCP.SGCBS02P.getValue());
        header.setOPERACAO(OperacaoServico.INCLUI_BOLETO.getValue());
        header.setSISTEMAORIGEM(SistemaOrigem.SIGCB.getValue());
        header.setDATAHORA(LocalDateTime.now().format(DATETIMEFORMATER_YYYY_M_MDD_H_HMMSS));
        return header;
    }

    private static String generateCodigoAutenticacao(Bloqueto boleto, ParametroCNAB240 parametrosCNAB240Caixa, Integer numeroConvenio) {
        try {
            String autenticacao = String.format("%s%s%s%s%s", StringUtils.leftPad((String)numeroConvenio.toString(), (int)7, (String)"0"), StringUtils.leftPad((String)ManutecaoCobrancaBancariaCEFDTO.getNossoNumeroByBoleto((Bloqueto)boleto), (int)17, (String)"0"), Optional.ofNullable(boleto.getDataVencimento()).map(vencimento -> vencimento.format(DATETIMEFORMATER_DD_M_MYYYY)).orElse(""), StringUtils.leftPad((String)Optional.ofNullable(boleto.getValorBloqueto()).map(x -> x.setScale(2, RoundingMode.HALF_EVEN).multiply(BigDecimal.valueOf(100L)).longValueExact()).orElse(0L).toString(), (int)15, (String)"0"), StringUtils.leftPad((String)Optional.ofNullable(parametrosCNAB240Caixa.getEntidade()).map(Entidade::getCnpj).orElse(""), (int)14, (String)"0"));
            return Base64.encodeBase64String((byte[])MessageDigest.getInstance("SHA-256").digest(autenticacao.getBytes("ISO8859-1")));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel realizar a gera\u00e7\u00e3o do c\u00f3digo de autentica\u00e7\u00e3o: %s", ex.getMessage()));
        }
    }

    private static DadosEntradaType getBody(Bloqueto boleto, ParametroCNAB240 parametrosCNAB240Caixa, Integer numeroConvenio) {
        try {
            IncluiBoletoEntradaType boletoEntrada = new IncluiBoletoEntradaType();
            boletoEntrada.setCODIGOBENEFICIARIO(numeroConvenio.intValue());
            TituloEntradaType titulo = new TituloEntradaType();
            String nossoNumero = ManutecaoCobrancaBancariaCEFDTO.getNossoNumeroByBoleto((Bloqueto)boleto);
            titulo.setNOSSONUMERO(Long.valueOf(!StringUtils.isEmpty((CharSequence)nossoNumero) ? Long.parseLong(nossoNumero) : 0L));
            titulo.setNUMERODOCUMENTO(StringUtils.leftPad((String)StringUtils.substring((String)nossoNumero, (int)7, (int)17), (int)11, (String)"0"));
            XMLGregorianCalendar dataVencimentoFuturo = null;
            if (Objects.nonNull(boleto.getDataVencimento())) {
                titulo.setDATAVENCIMENTO(DatatypeFactory.newInstance().newXMLGregorianCalendar(boleto.getDataVencimento().format(DATETIMEFORMATTER_ANO_MES_DIA)));
                dataVencimentoFuturo = DatatypeFactory.newInstance().newXMLGregorianCalendar(boleto.getDataVencimento().plusDays(1L).format(DATETIMEFORMATTER_ANO_MES_DIA));
            }
            Optional.ofNullable(boleto.getValorBloqueto()).ifPresent(valorBoleto -> titulo.setVALOR(valorBoleto.setScale(2, RoundingMode.HALF_EVEN)));
            titulo.setTIPOESPECIE(Optional.ofNullable(parametrosCNAB240Caixa.getIdEspecieTitulo()).map(CNAB240CodigoEspecieTitulo::getEspecieTitulo).map(Long::shortValue).orElse(ESPECIE_OUTROS).shortValue());
            titulo.setFLAGACEITE(Optional.ofNullable(parametrosCNAB240Caixa.getAceite()).map(CNAB240Aceite::getId).map(aceite -> BooleanToStringUtils.getBooleanAsString((Boolean)TipoAceite.ACEITE.getCodigo().equals(aceite))).orElse(BooleanToStringUtils.getBooleanAsString((Boolean)Boolean.TRUE)));
            if (Objects.nonNull(boleto.getDataEmissao())) {
                titulo.setDATAEMISSAO(DatatypeFactory.newInstance().newXMLGregorianCalendar(boleto.getDataEmissao().format(DATETIMEFORMATTER_ANO_MES_DIA)));
            }
            titulo.setJUROSMORA(ManutecaoCobrancaBancariaCEFDTO.getJurosMora((ParametroCNAB240)parametrosCNAB240Caixa, (XMLGregorianCalendar)dataVencimentoFuturo));
            titulo.setPOSVENCIMENTO(ManutecaoCobrancaBancariaCEFDTO.getPosVencimento((ParametroCNAB240)parametrosCNAB240Caixa, (Boolean)boleto.permitePagamentoAposVencimento()));
            titulo.setCODIGOMOEDA(MOEDA_REAL.shortValue());
            titulo.setPAGADOR(ManutecaoCobrancaBancariaCEFDTO.getPagador((Bloqueto)boleto));
            titulo.setMULTA(ManutecaoCobrancaBancariaCEFDTO.getMulta((ParametroCNAB240)parametrosCNAB240Caixa, (XMLGregorianCalendar)dataVencimentoFuturo));
            if (boleto.getModeloBloqueto().getConvenio().getUtilizaPix().booleanValue()) {
                titulo.setTIPO(TIPOTYPE.HIBRIDO);
            } else {
                titulo.setPAGAMENTO(ManutecaoCobrancaBancariaCEFDTO.getPagamento());
            }
            boletoEntrada.setTITULO(titulo);
            DadosEntradaType body = new DadosEntradaType();
            body.setINCLUIBOLETO(boletoEntrada);
            return body;
        }
        catch (DatatypeConfigurationException ex) {
            throw new EloValidationException(String.format("N\u00e3o foi montar os dados do webservice da CEF: %s", ex.getMessage()));
        }
    }

    private static Integer getConvenio(Bloqueto boleto) {
        return Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getConvenio).map(Convenio::getNumeroConvenio).map(Integer::parseInt).orElseThrow(() -> new EloValidationException("Conv\u00eanio n\u00e3o encontrado no modelo de boleto!"));
    }

    private static JurosMoraType getJurosMora(ParametroCNAB240 parametrosCNAB240Caixa, XMLGregorianCalendar dataVencimentoFuturo) {
        JurosMoraType jurosMora = new JurosMoraType();
        jurosMora.setTIPO(Optional.ofNullable(parametrosCNAB240Caixa.getCodigoJuros()).map(CNAB240CodigoJuros::getId).map(codigoJuros -> TipoJurosMora.fromValue((Long)codigoJuros).getDescricao()).orElse(TipoJurosMora.ISENTO.getDescricao()));
        jurosMora.setDATA(dataVencimentoFuturo);
        Optional.ofNullable(parametrosCNAB240Caixa.getValorJurosDiaTaxa()).ifPresent(valorJuros -> jurosMora.setVALOR(parametrosCNAB240Caixa.getValorJurosDiaTaxa().setScale(2, RoundingMode.HALF_EVEN)));
        return jurosMora;
    }

    private static PosVencimentoType getPosVencimento(ParametroCNAB240 parametrosCNAB240Caixa, Boolean permitePagamentoAposVencimento) {
        PosVencimentoType posVencimento = new PosVencimentoType();
        posVencimento.setACAO(AcaoPosVencimento.DEVOLVER.getDescricao());
        Optional.ofNullable(parametrosCNAB240Caixa.getCodigoProtesto()).map(CNAB240CodigoProtesto::getCodigo).filter(AcaoPosVencimento.PROTESTAR.getCodigo()::equals).ifPresent(codigoProtesto -> posVencimento.setACAO(AcaoPosVencimento.fromValue((Long)codigoProtesto).getDescricao()));
        if (AcaoPosVencimento.PROTESTAR.getDescricao().equals(posVencimento.getACAO())) {
            Optional.ofNullable(parametrosCNAB240Caixa.getDiasProtesto()).ifPresent(diasProtesto -> posVencimento.setNUMERODIAS(diasProtesto.shortValue()));
            return posVencimento;
        }
        Optional.ofNullable(parametrosCNAB240Caixa.getDiasBaixaDevolucao()).ifPresent(diasBaixaDevolucao -> posVencimento.setNUMERODIAS(diasBaixaDevolucao.shortValue()));
        if (permitePagamentoAposVencimento.booleanValue()) {
            posVencimento.setNUMERODIAS(DIAS_BAIXA_MINIMA.shortValue());
        }
        return posVencimento;
    }

    private static PagadorType getPagador(Bloqueto boleto) {
        Pessoa pessoa = boleto.getPessoa();
        if (Objects.isNull(pessoa) || Objects.isNull(pessoa.getTipoPessoa())) {
            return null;
        }
        PagadorType pagador = new PagadorType();
        String nomePagador = StringUtils.stripAccents((String)Optional.ofNullable(pessoa.getNome()).map(nome -> StringUtils.substring((String)nome, (int)0, (int)40)).orElse(""));
        Long cnpjCpf = Optional.ofNullable(pessoa.getCnpjCpfSemMascara()).map(Long::valueOf).orElse(null);
        if (pessoa.getTipoPessoa().equals((Object)TipoPessoa.FISICA)) {
            pagador.setCPF(cnpjCpf);
            pagador.setNOME(nomePagador);
        }
        if (pessoa.getTipoPessoa().equals((Object)TipoPessoa.JURIDICA)) {
            pagador.setCNPJ(cnpjCpf);
            pagador.setRAZAOSOCIAL(nomePagador);
        }
        pagador.setENDERECO(ManutecaoCobrancaBancariaCEFDTO.getEnderecoByPessoa((EnderecoPessoa)pessoa.getEnderecoPrincipal()));
        return pagador;
    }

    private static EnderecoType getEnderecoByPessoa(EnderecoPessoa endereco) {
        if (Objects.isNull(endereco)) {
            return null;
        }
        EnderecoType enderecoPagador = new EnderecoType();
        enderecoPagador.setLOGRADOURO(Optional.of(ManutecaoCobrancaBancariaCEFDTO.getLogradouro((EnderecoPessoa)endereco)).map(ManutecaoCobrancaBancariaCEFDTO::limpaCaracteres).map(logradrouro -> StringUtils.substring((String)logradrouro, (int)0, (int)40)).orElse(""));
        enderecoPagador.setBAIRRO(Optional.ofNullable(endereco.getBairro()).map(Bairro::getDescricao).map(ManutecaoCobrancaBancariaCEFDTO::limpaCaracteres).map(nomeBairro -> StringUtils.substring((String)nomeBairro, (int)0, (int)15)).orElse(""));
        enderecoPagador.setCIDADE(Optional.ofNullable(endereco.getCidade()).map(Cidade::getDescricao).map(ManutecaoCobrancaBancariaCEFDTO::limpaCaracteres).map(cidade -> StringUtils.substring((String)cidade, (int)0, (int)15)).orElse(""));
        enderecoPagador.setUF(Optional.ofNullable(endereco.getUnidadeFederacao()).map(UnidadeFederacao::getUnidadeFederacao).map(ManutecaoCobrancaBancariaCEFDTO::limpaCaracteres).map(uf -> StringUtils.substring((String)uf, (int)0, (int)2)).orElse(""));
        Optional.ofNullable(endereco.getCep()).ifPresent(cep -> enderecoPagador.setCEP(cep.intValue()));
        return enderecoPagador;
    }

    private static MultaType getMulta(ParametroCNAB240 parametrosCNAB240Caixa, XMLGregorianCalendar dataVencimentoFuturo) {
        Long identificadorMulta = Optional.ofNullable(parametrosCNAB240Caixa.getCodigoMulta()).map(CNAB240CodigoMulta::getId).orElse(0L);
        if (TipoMulta.SEM_MULTA.getCodigo().equals(identificadorMulta)) {
            return null;
        }
        MultaType multa = new MultaType();
        multa.setDATA(dataVencimentoFuturo);
        BigDecimal jurosDiaTaxa = parametrosCNAB240Caixa.getValorJurosDiaTaxa().setScale(2, RoundingMode.HALF_EVEN);
        if (TipoMulta.VALOR_FIXO.getCodigo().equals(identificadorMulta)) {
            multa.setVALOR(jurosDiaTaxa);
            return multa;
        }
        multa.setPERCENTUAL(jurosDiaTaxa);
        return multa;
    }

    private static PagamentoType getPagamento() {
        PagamentoType pagamento = new PagamentoType();
        pagamento.setTIPO(TipoPagamento.NAO_ACEITA_VALOR_DIVERGENTE.getValue());
        pagamento.setQUANTIDADEPERMITIDA(QUANTIDADE_PAGAMENTO_PERMITIDO.shortValue());
        pagamento.setVALORMINIMO(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_EVEN));
        pagamento.setVALORMAXIMO(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_EVEN));
        return pagamento;
    }

    private static String getLogradouro(EnderecoPessoa endereco) {
        return String.format("%s%s%s%s%s%s%s", Optional.ofNullable(endereco.getLogradouro()).map(Logradouro::getTipoLogradouro).map(TipoLogradouro::getSigla).orElse(""), " ", Optional.ofNullable(endereco.getLogradouro()).map(Logradouro::getDescricao).orElse(""), ", ", endereco.getNumero(), " ", endereco.getComplemento());
    }

    private static String getNossoNumeroByBoleto(Bloqueto boleto) {
        return String.format("%s%s", Optional.ofNullable(boleto.getModalidadeCarteira()).orElse(""), Optional.ofNullable(boleto.getNossoNumero()).orElse("")).trim();
    }

    private static String limpaCaracteres(String valor) {
        return StringUtils.stripAccents((String)valor).replaceAll("[^\\d\\w\\s]", "");
    }

    @Generated
    public ManutecaoCobrancaBancariaCEFDTO() {
    }

    @Generated
    public ServicoEntradaNegocialType getRequest() {
        return this.request;
    }

    @Generated
    public void setRequest(ServicoEntradaNegocialType request) {
        this.request = request;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManutecaoCobrancaBancariaCEFDTO)) {
            return false;
        }
        ManutecaoCobrancaBancariaCEFDTO other = (ManutecaoCobrancaBancariaCEFDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ServicoEntradaNegocialType this$request = this.getRequest();
        ServicoEntradaNegocialType other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ManutecaoCobrancaBancariaCEFDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ServicoEntradaNegocialType $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ManutecaoCobrancaBancariaCEFDTO(request=" + this.getRequest() + ")";
    }
}

