/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.parcelamento.FormaCobrancaJurosParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntrada;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntradaId;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseDebitoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.BuscarNumeroParcelasImpressaoBoletoDTO;
import br.com.elotech.tributos.dto.parcelamento.ImpressaoBoletoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.NumeroParcelasImpressaoBoletoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoPassivelQuitacaoDTO;
import br.com.elotech.tributos.dto.parcelamento.RequestParcelamentoPassivelQuitacaoDTO;
import br.com.elotech.tributos.dto.parcelamento.RequestSimularQuitarContratoDTO;
import br.com.elotech.tributos.dto.parcelamento.ResumoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoParcelamentoRequestDTO;
import br.com.elotech.tributos.dto.parcelamento.SimularQuitarContratoDTO;
import br.com.elotech.tributos.dto.parcelamento.ValorEntradaDTO;
import br.com.elotech.tributos.enums.TipoAcaoAtendimento;
import br.com.elotech.tributos.exception.GeracaoParcelamentoException;
import br.com.elotech.tributos.exception.ImpressaoBoletoParcelamentoException;
import br.com.elotech.tributos.exception.SimulacaoParcelamentoException;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.HistoricoAtendimentoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParamParcelamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.ws.AiseParcelamentoService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import br.com.elotech.tributos.ws.rest.dto.ParamDebitosPassiveisParcelamentoDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.Transactional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseParcelamentoServiceRest
implements AiseParcelamentoService {
    private static final Integer NUMERO_PADRAO_PARCELAS_IMPRESSAO = 6;
    private static final Integer LIMITE_PARCELAS_IMPRESSAO_BOLETO = 12;
    private static final Logger LOGGER = LoggerFactory.getLogger(AiseParcelamentoServiceRest.class);
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final TributosProperties tributosProperties;
    private final ParamParcelamentoService paramParcelamentoService;
    private final ParcelamentoService parcelamentoService;
    private final ParametroGeralService parametroGeralService;
    private final FormaPagamentoService formaPagamentoService;
    private final ContextService contextService;
    private final ConfigurableEnvironment environment;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private final ObjectMapper objectMapper;
    private final HistoricoAtendimentoService historicoAtendimentoService;

    public List<AiseDebitoParcelamentoDTO> findDebitosPassiveisParcelamento(ParamDebitosPassiveisParcelamentoDTO param) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        List debitos = (List)this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/DebitosPassiveisParcelamento", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)param, (HttpHeaders)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
        debitos.sort(Comparator.comparing(AiseDebitoParcelamentoDTO::getExercicio).thenComparing(AiseDebitoParcelamentoDTO::getGuiaRecolhimento).thenComparing(AiseDebitoParcelamentoDTO::getSubDivida));
        Boolean concedeDescontoNoPagamento = ((ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)Long.valueOf(param.getIdParametroParcelamento().intValue()))).getDescontosPorParcela().stream().anyMatch(desconto -> Boolean.TRUE.equals(desconto.getConcedeDescontoNoPagamento()));
        debitos.forEach(debito -> {
            debito.agruparValores();
            debito.setConcedeDescontoNoPagamento(concedeDescontoNoPagamento);
        });
        return debitos;
    }

    public SimulacaoParcelamentoDTO simularParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        this.validaParcelamento(simulacaoParcelamentoDTO);
        return this.internalSimularParcelamento(simulacaoParcelamentoDTO);
    }

    private void atualizarReferenciaDebitoParcela(AiseParcelamentoDTO parcelamentoDTO) {
        parcelamentoDTO.getDebitos().forEach(debito -> debito.getParcelaReceita().forEach(parcela -> parcela.setIdDebito(debito.getIdDebito())));
    }

    private SimulacaoParcelamentoDTO internalSimularParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        AiseParcelamentoDTO parcelamentoDTO = (AiseParcelamentoDTO)this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/simularparcelamento", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)simulacaoParcelamentoDTO, (HttpHeaders)headers), AiseParcelamentoDTO.class, new Object[0]).getBody();
        this.atualizarReferenciaDebitoParcela(parcelamentoDTO);
        Boolean concedeDescontoNoPagamento = ((ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)simulacaoParcelamentoDTO.getIdParametroParcelamento())).getDescontosPorParcela().stream().anyMatch(desconto -> Boolean.TRUE.equals(desconto.getConcedeDescontoNoPagamento()));
        parcelamentoDTO.getDebitos().forEach(debito -> {
            debito.agruparValores();
            debito.setConcedeDescontoNoPagamento(concedeDescontoNoPagamento);
        });
        return SimulacaoParcelamentoDTO.from((AiseParcelamentoDTO)parcelamentoDTO, (SimulacaoParcelamentoDTO)simulacaoParcelamentoDTO);
    }

    public ResumoParcelamentoDTO gerarParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, UserSecurityDTO userSecurityDTO) throws JsonProcessingException {
        if (!simulacaoParcelamentoDTO.verificaIntegridadeSimulacao()) {
            throw new GeracaoParcelamentoException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gravar o parcelamento, fa\u00e7a novamente a simula\u00e7\u00e3o!");
        }
        this.validaValorMinimoParametrizadoParaParcelamento(simulacaoParcelamentoDTO);
        if (this.environment.acceptsProfiles(new String[]{"onpremise"})) {
            simulacaoParcelamentoDTO.setExecutaMovimentacao(true);
        }
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        headers.set("usuario-aise", userSecurityDTO.getPreferredUsername());
        String url = String.format("%s/datasnap/rest/tparcelamentos/gerarparcelamento", this.tributosProperties.getAise().getWsBaseUrl());
        LOGGER.debug("Requesto to {} with {}", (Object)url, (Object)this.objectMapper.writeValueAsString((Object)simulacaoParcelamentoDTO));
        AiseParcelamentoDTO parcelamentoDTO = (AiseParcelamentoDTO)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)simulacaoParcelamentoDTO, (HttpHeaders)headers), AiseParcelamentoDTO.class, new Object[0]).getBody();
        LOGGER.debug("Response of {} with {}", (Object)url, (Object)this.objectMapper.writeValueAsString((Object)parcelamentoDTO));
        this.saveArquivoContratoParcelamento(simulacaoParcelamentoDTO, parcelamentoDTO);
        this.saveProcesso(simulacaoParcelamentoDTO, parcelamentoDTO);
        this.atualizarReferenciaDebitoParcela(parcelamentoDTO);
        this.historicoAtendimentoService.createHistoricoAtendimento(String.format("Gerado parcelamento %s/%s", parcelamentoDTO.getNumeroContrato(), parcelamentoDTO.getAnoContrato()), TipoAcaoAtendimento.GERACAO_PARCELAMENTO, simulacaoParcelamentoDTO.getHeaderAtendimento());
        return ResumoParcelamentoDTO.from((AiseParcelamentoDTO)parcelamentoDTO);
    }

    @Async
    @Transactional
    public void createGeracaoParcelamentoAssincrono(SimulacaoParcelamentoDTO param, UserSecurityDTO userSecurityDTO) {
        LOGGER.debug("Cria\u00e7\u00e3o da tarefa GERACAO_PARCELAMENTO_ASSINCROCNO para o parcelamento tipo cadastro:{}, cadastro geral:{}, data Contrato: {}]", new Object[]{param.getTipoCadastro(), param.getCadastroGeral(), param.getDataParcelamento()});
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaGeracaoParcelamento(SimulacaoParcelamentoDTO.getChaveParcelamentoAssincrono((SimulacaoParcelamentoDTO)param));
        Long tarefa = execucao.getTarefaAssincrona().getId();
        Optional notificacaoId = this.notificacaoService.send("Gera\u00e7\u00e3o Parcelamento Ass\u00edncrono", String.format("Iniciando a gera\u00e7\u00e3o do parcelamento %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        this.generateParcelamentoAssincrono(param, userSecurityDTO, execucao, tarefa, notificacaoId);
    }

    private void generateParcelamentoAssincrono(SimulacaoParcelamentoDTO param, UserSecurityDTO userSecurityDTO, TarefaAssincronaExecucao execucao, Long tarefa, Optional<UUID> notificacaoId) {
        try {
            LOGGER.debug("Iniciando Gera\u00e7\u00e3o do parcelamento [tipo cadastro:{}, cadastro geral:{}, data Contrato: {}]", new Object[]{param.getTipoCadastro(), param.getCadastroGeral(), param.getDataParcelamento()});
            ResumoParcelamentoDTO resumoParcelamentoDTO = this.gerarParcelamento(param, userSecurityDTO);
            LOGGER.debug("Finalizada com sucesso a Gera\u00e7\u00e3o do parcelamento da tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Gera\u00e7\u00e3o Parcelamento Ass\u00edncrono", String.format("Finalizada com sucesso a Gera\u00e7\u00e3o do parcelamento da tarefa %s.", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
            this.generateImpressaoCarne(resumoParcelamentoDTO);
        }
        catch (Exception exception) {
            LOGGER.debug("Ocorreu um erro na Gera\u00e7\u00e3o do parcelamento da tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
            this.notificacaoService.send("Gera\u00e7\u00e3o Parcelamento Ass\u00edncrono", String.format("Ocorreu um erro na Gera\u00e7\u00e3o do parcelamento da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
        }
    }

    private void generateImpressaoCarne(ResumoParcelamentoDTO resumoParcelamentoDTO) {
        if (Objects.nonNull(resumoParcelamentoDTO.getIdParcelamento()) && Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.GERACAO_CARNEPARCELAMENTO_OXY)) && Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.GERA_CARNE_PARCELAMENTO_AUTO)) && resumoParcelamentoDTO.getNumeroParcela() > 15) {
            LOGGER.debug("Iniciado gera\u00e7\u00e3o do carne de parcelamento com idparcelamento {}", (Object)resumoParcelamentoDTO.getIdParcelamento());
            this.parcelamentoService.gerarOuImprimirBoleto(resumoParcelamentoDTO.getIdParcelamento(), true);
        }
    }

    private void saveArquivoContratoParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, AiseParcelamentoDTO parcelamentoDTO) {
        if (Objects.nonNull(simulacaoParcelamentoDTO.getTenant()) && Objects.nonNull(parcelamentoDTO)) {
            Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)parcelamentoDTO.getIdParcelamento());
            this.parcelamentoService.uploadContratoParcelamento(simulacaoParcelamentoDTO.getTenant(), parcelamento);
        }
    }

    private void saveProcesso(SimulacaoParcelamentoDTO simulacao, AiseParcelamentoDTO aiseParcelamento) {
        if (Objects.nonNull(aiseParcelamento) && (Objects.nonNull(simulacao.getNumeroProcesso()) || Objects.nonNull(simulacao.getAnoProcesso()))) {
            Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)aiseParcelamento.getIdParcelamento());
            parcelamento.setNumeroProcesso(simulacao.getNumeroProcesso());
            parcelamento.setAnoProcesso(simulacao.getAnoProcesso());
            this.parcelamentoService.save((EloEntity)parcelamento, null);
        }
    }

    private void validaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        ParamParcelamento parametro = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)simulacaoParcelamentoDTO.getIdParametroParcelamento());
        this.validaParcelamento(simulacaoParcelamentoDTO, parametro);
    }

    public void validaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, ParamParcelamento parametro) {
        if (simulacaoParcelamentoDTO.getDataEntrada().isBefore(simulacaoParcelamentoDTO.getDataParcelamento())) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, "A data de entrada deve ser maior ou igual a data do parcelamento.");
        }
        this.validaValorMinimoParametrizadoParaParcelamento(simulacaoParcelamentoDTO, parametro);
        this.validaEntradaParcelamento(simulacaoParcelamentoDTO, parametro);
        this.validaParcelasParcelamento(simulacaoParcelamentoDTO, parametro);
    }

    private void validaEntradaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, ParamParcelamento parametro) {
        ValorEntradaDTO valorEntradaDTO;
        if (simulacaoParcelamentoDTO.getValorEntrada().compareTo(simulacaoParcelamentoDTO.getTotalSelecionado()) > 0) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("Valor de entrada %.2f maior que o total selecionado %.2f.", simulacaoParcelamentoDTO.getValorEntrada(), simulacaoParcelamentoDTO.getTotalSelecionado()));
        }
        Optional<ParamParcelamentoEntrada> entrada = parametro.getEntradas().stream().filter(e -> simulacaoParcelamentoDTO.getEntrada().equals(e.getId().getEntrada())).findFirst();
        BigDecimal percentualEntrada = entrada.map(ParamParcelamentoEntrada::getPercentualEntrada).orElseThrow(() -> new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, "Entrada n\u00e3o encontrada para o par\u00e2metro de parcelamento."));
        BigDecimal entradaMinimaCalculada = simulacaoParcelamentoDTO.getTotalSelecionado().multiply(Optional.ofNullable(percentualEntrada).orElse(BigDecimal.ZERO)).divide(BigDecimal.valueOf(100L)).setScale((int)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS, 6);
        if (entradaMinimaCalculada.compareTo(BigDecimal.ZERO) > 0 && simulacaoParcelamentoDTO.getValorEntrada().compareTo(BigDecimal.ZERO) == 0) {
            simulacaoParcelamentoDTO.setValorEntrada(entradaMinimaCalculada);
        }
        if (Objects.nonNull(valorEntradaDTO = Optional.ofNullable(this.buscarValorEntrada(simulacaoParcelamentoDTO)).orElseThrow(() -> new SimulacaoParcelamentoException(HttpStatus.INTERNAL_SERVER_ERROR, "N\u00e3o foi poss\u00edvel calcular o valor de entrada do parcelamento.")))) {
            if ((long)simulacaoParcelamentoDTO.getNumeroParcelas().intValue() > valorEntradaDTO.getNumeroParcela()) {
                throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O n\u00famero de parcelas deve ser alterado para %d afim de adequar o valor m\u00ednimo da parcela.", valorEntradaDTO.getNumeroParcela()));
            }
            Boolean digitouValorEntrada = simulacaoParcelamentoDTO.getValorEntrada().compareTo(entradaMinimaCalculada) != 0;
            simulacaoParcelamentoDTO.ajustarValorEntrada(digitouValorEntrada, parametro, valorEntradaDTO.getValorEntrada());
        }
        if (simulacaoParcelamentoDTO.getValorEntrada().compareTo(entradaMinimaCalculada) < 0) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O valor da entrada deve ser no m\u00ednimo %.2f.", entradaMinimaCalculada));
        }
    }

    private void validaParcelasParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, ParamParcelamento parametro) {
        Long numeroParcela = Optional.ofNullable(parametro.getNumeroParcela()).orElse(0L);
        if ((long)simulacaoParcelamentoDTO.getNumeroParcelas().intValue() > numeroParcela && !simulacaoParcelamentoDTO.hasProcessoPrazo().booleanValue()) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("N\u00famero de parcelas informado %d \u00e9 superior ao m\u00e1ximo permitido %d.", simulacaoParcelamentoDTO.getNumeroParcelas(), numeroParcela));
        }
        Long numeroParcelaRequerimento = Optional.ofNullable(parametro.getNumeroParcelaRequerimento()).orElse(0L);
        if ((long)simulacaoParcelamentoDTO.getNumeroParcelas().intValue() > numeroParcelaRequerimento && simulacaoParcelamentoDTO.hasProcessoPrazo().booleanValue()) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("N\u00famero de parcelas informado %d \u00e9 superior ao m\u00e1ximo permitido %d.", simulacaoParcelamentoDTO.getNumeroParcelas(), numeroParcelaRequerimento));
        }
    }

    public ValorEntradaDTO buscarValorEntrada(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        return (ValorEntradaDTO)this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/buscarvalorentrada", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)simulacaoParcelamentoDTO, (HttpHeaders)headers), ValorEntradaDTO.class, new Object[0]).getBody();
    }

    public List<ParcelamentoPassivelQuitacaoDTO> findParcelamentosCompativeis(Long idParcelamento) {
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)idParcelamento);
        RequestParcelamentoPassivelQuitacaoDTO request = new RequestParcelamentoPassivelQuitacaoDTO();
        request.setTipoCadastro(Integer.valueOf(parcelamento.getCadastroGeral().getTipoCadastro().getValue().intValue()));
        request.setCadastroGeral(Integer.valueOf(parcelamento.getCadastroGeral().getCadastroGeral().intValue()));
        request.setTipoParcelamento(parcelamento.getTipo().getCodigo());
        request.setDataParcelamento(parcelamento.getDataParcelamento());
        request.setIdParcelamento(Integer.valueOf(idParcelamento.intValue()));
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        return (List)this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/ParcelamentosPassiveisQuitacao", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
    }

    public SimularQuitarContratoDTO simularQuitarContrato(RequestSimularQuitarContratoDTO request) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        FormaPagamento formaPagamento = this.formaPagamentoService.getFormaPagamentoRestante().orElseGet(() -> this.formaPagamentoService.findFormaPagamentoPadrao(Optional.of(this.contextService.getExercicioAtual())));
        request.setFormaPagamento((Long)Optional.ofNullable(formaPagamento).map(FormaPagamento::getId).orElse(null));
        return (SimularQuitarContratoDTO)this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/SimularQuitarContrato", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), SimularQuitarContratoDTO.class, new Object[0]).getBody();
    }

    public byte[] imprimirSimulacaoQuitarContrato(SimularQuitarContratoDTO request) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        return (byte[])this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/ImprimirSimulacaoQuitarContrato", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), byte[].class, new Object[0]).getBody();
    }

    public BloquetoDTO quitarContrato(RequestSimularQuitarContratoDTO request) {
        FormaPagamento formaPagamento = this.formaPagamentoService.getFormaPagamentoRestante().orElseGet(() -> this.formaPagamentoService.findFormaPagamentoPadrao(Optional.of(this.contextService.getExercicioAtual())));
        request.setFormaPagamento((Long)Optional.ofNullable(formaPagamento).map(FormaPagamento::getId).orElse(null));
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        return (BloquetoDTO)this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/QuitarContrato", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), BloquetoDTO.class, new Object[0]).getBody();
    }

    public byte[] imprimirBoleto(ImpressaoBoletoParcelamentoDTO request) {
        ParcelamentoPassivelQuitacaoDTO parcelamentoDTO = (ParcelamentoPassivelQuitacaoDTO)request.getParcelamentos().stream().findFirst().orElseThrow(() -> new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, "N\u00e3o foi informado parcelamento."));
        request.setTipoCadastro(parcelamentoDTO.getTipoCadastro());
        request.setCadastroGeral(parcelamentoDTO.getCadastroGeral());
        request.setDataParcelamento(parcelamentoDTO.getDataContrato());
        this.validaImpressaoBoletoParcelamento(request);
        return this.imprimirBoletoAise(request);
    }

    private byte[] imprimirBoletoAise(ImpressaoBoletoParcelamentoDTO request) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        return (byte[])this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/ImprimirBoleto", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), byte[].class, new Object[0]).getBody();
    }

    private void validaImpressaoBoletoParcelamento(ImpressaoBoletoParcelamentoDTO request) {
        this.validaFormaCobrancaJurosParcelamento(request);
        this.validaParcelasImpressaoBoleto(request);
    }

    private void validaFormaCobrancaJurosParcelamento(ImpressaoBoletoParcelamentoDTO request) {
        ArrayList parcelamentosTaxaIndividualPorParcela = new ArrayList();
        request.getParcelamentos().forEach(parcelamento -> {
            ParamParcelamento parametro = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)parcelamento.getIdParametroParcelamento());
            if (parametro.getTipoJurosFinanciamento().equals((Object)FormaCobrancaJurosParcelamento.TAXA_INDIVIDUAL_POR_PARCELA)) {
                parcelamentosTaxaIndividualPorParcela.add(parcelamento);
            }
        });
        if (!parcelamentosTaxaIndividualPorParcela.isEmpty() && request.getParcelamentos().size() > parcelamentosTaxaIndividualPorParcela.size()) {
            String constratosTaxaIndividual = parcelamentosTaxaIndividualPorParcela.stream().map(elemento -> String.format("%d/%d", elemento.getNumeroContrato(), elemento.getAnoContrato())).reduce((accum, elemento) -> accum + ", " + String.format("%s", elemento)).orElse("");
            throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("Contratos configurados com o Tipo de Juros de Financiamento  'Taxa Individual por Parcela' n\u00e3o podem ser quitados juntamente  com outros contratos que n\u00e3o possuem essa configura\u00e7\u00e3o.  Contratos que est\u00e3o configurados com Taxa Individual por Parcela: %s.", constratosTaxaIndividual));
        }
    }

    private void validaParcelasImpressaoBoleto(ImpressaoBoletoParcelamentoDTO request) {
        ParametroGeral parametroImpressaoParcelamento;
        String pattern = "dd/MM/yyyy";
        DateTimeFormatter simpleDateFormat = DateTimeFormatter.ofPattern(pattern);
        if (request.getVencimentoInicial().isBefore(LocalDate.now())) {
            throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O vencimento inicial informado %s \u00e9 inferior a data atual %s.", simpleDateFormat.format(request.getVencimentoInicial()), simpleDateFormat.format(LocalDate.now())));
        }
        BuscarNumeroParcelasImpressaoBoletoDTO buscarNumeroParcelasDTO = new BuscarNumeroParcelasImpressaoBoletoDTO();
        buscarNumeroParcelasDTO.setTipoCadastro(request.getTipoCadastro());
        buscarNumeroParcelasDTO.setCadastroGeral(request.getCadastroGeral());
        buscarNumeroParcelasDTO.setDataParcelamento(request.getDataParcelamento());
        buscarNumeroParcelasDTO.getParcelamentos().addAll(request.getParcelamentos());
        NumeroParcelasImpressaoBoletoDTO numeroParcelas = this.buscarNumeroParcelasImpressaoBoleto(buscarNumeroParcelasDTO);
        if (Objects.nonNull(numeroParcelas)) {
            if (numeroParcelas.getQuantidadeParcelaAberta() == 0) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, "N\u00e3o existem parcelas abertas para o(s) contrato(s).");
            }
            if (request.getQuantidadeParcelas() > numeroParcelas.getQuantidadeParcelaAberta()) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("Quantidade de parcelas %d maior que a quantidade de parcelas em aberto %d.", request.getQuantidadeParcelas(), numeroParcelas.getQuantidadeParcelaAberta()));
            }
            if (numeroParcelas.getDataVencimentoInicio().isBefore(LocalDate.now())) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, "As parcelas para o(s) contrato(s) j\u00e1 est\u00e3o vencidas. Utilize a central de atendimento.");
            }
        }
        if (Objects.nonNull(parametroImpressaoParcelamento = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.VALIDACAO_EMISSAO_BLOQUETO_REPARC, ModuloEnum.MODULO_TRIBUTARIO.getValue())) && parametroImpressaoParcelamento.getValor().equals("S")) {
            if (request.getQuantidadeParcelas() > LIMITE_PARCELAS_IMPRESSAO_BOLETO) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("Quantidade de parcelas %d maior que a quantidade m\u00e1xima permitida %d.", request.getQuantidadeParcelas(), LIMITE_PARCELAS_IMPRESSAO_BOLETO));
            }
            if (Objects.nonNull(numeroParcelas) && request.getVencimentoFinal().isAfter(numeroParcelas.getDataLimiteVencimento())) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O vencimento final informado %s excede o limite de vencimento %s antes da atualiza\u00e7\u00e3o monet\u00e1ria do d\u00e9bito.", simpleDateFormat.format(request.getVencimentoFinal()), simpleDateFormat.format(numeroParcelas.getDataLimiteVencimento())));
            }
        }
    }

    public NumeroParcelasImpressaoBoletoDTO buscarNumeroParcelasImpressaoBoleto(BuscarNumeroParcelasImpressaoBoletoDTO request) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        ParcelamentoPassivelQuitacaoDTO parcelamentoDTO = (ParcelamentoPassivelQuitacaoDTO)request.getParcelamentos().stream().findFirst().orElseThrow(() -> new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, "N\u00e3o foi informado parcelamento."));
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)parcelamentoDTO.getIdParcelamento());
        request.setTipoCadastro(parcelamento.getCadastroGeral().getTipoCadastro().getValue());
        request.setCadastroGeral(parcelamento.getCadastroGeral().getCadastroGeral());
        request.setDataParcelamento(parcelamento.getDataParcelamento());
        request.setTipo(parcelamento.getTipo().getValue());
        NumeroParcelasImpressaoBoletoDTO numeroParcelasImpressaoBoletoDTO = (NumeroParcelasImpressaoBoletoDTO)this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/BuscarNumeroParcelaImpressao", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), NumeroParcelasImpressaoBoletoDTO.class, new Object[0]).getBody();
        numeroParcelasImpressaoBoletoDTO.setDataVencimentoFim(numeroParcelasImpressaoBoletoDTO.getDataLimiteVencimento());
        ParametroGeral parametroImpressaoParcelamento = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.VALIDACAO_EMISSAO_BLOQUETO_REPARC, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (Objects.nonNull(parametroImpressaoParcelamento) && parametroImpressaoParcelamento.getValor().equals("S")) {
            numeroParcelasImpressaoBoletoDTO.setNumeroParcela(this.getNumeroParcelaImpressaoBoleto(numeroParcelasImpressaoBoletoDTO));
            numeroParcelasImpressaoBoletoDTO.setDataVencimentoFim(this.getDataVencimentoFimImpressaoBoleto(numeroParcelasImpressaoBoletoDTO));
        }
        return numeroParcelasImpressaoBoletoDTO;
    }

    private NumeroParcelasImpressaoBoletoDTO buscarNumeroParcelasImpressaoBoleto(Parcelamento parcelamento, ParamParcelamento paramParcelamento, List<ParcelamentoDebitoParcelasDTO> parcelas) {
        List parcelasEmAberto = parcelas.stream().filter(ParcelamentoDebitoParcelasDTO::getAberto).collect(Collectors.toList());
        List parcelasPagas = parcelas.stream().filter(Predicate.not(ParcelamentoDebitoParcelasDTO::getAberto)).collect(Collectors.toList());
        ParcelamentoPassivelQuitacaoDTO parcelamentoPassivelQuitacaoDTO = ParcelamentoPassivelQuitacaoDTO.of((Parcelamento)parcelamento, (ParamParcelamento)paramParcelamento, (Integer)parcelasEmAberto.size(), (Integer)parcelasPagas.size());
        BuscarNumeroParcelasImpressaoBoletoDTO buscarNumeroParcelasDTO = new BuscarNumeroParcelasImpressaoBoletoDTO();
        buscarNumeroParcelasDTO.setTipoCadastro(parcelamento.getCadastroGeral().getTipoCadastro().getValue());
        buscarNumeroParcelasDTO.setCadastroGeral(parcelamento.getCadastroGeral().getCadastroGeral());
        buscarNumeroParcelasDTO.setDataParcelamento(parcelamento.getDataParcelamento());
        buscarNumeroParcelasDTO.getParcelamentos().addAll(Collections.singletonList(parcelamentoPassivelQuitacaoDTO));
        return this.buscarNumeroParcelasImpressaoBoleto(buscarNumeroParcelasDTO);
    }

    public byte[] imprimirCarne(Long idParcelamento) {
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findById((Serializable)idParcelamento).orElseThrow(() -> new EloValidationException(String.format("Parcelamento %d n\u00e3o encontrado", idParcelamento)));
        ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)parcelamento.getIdParametroParcelamento());
        FormaPagamento formaPagamento = Optional.ofNullable(paramParcelamento.getFormaPagamento()).orElseGet(() -> this.formaPagamentoService.findFormaPagamentoPadrao(Optional.of(this.contextService.getExercicioAtual())));
        List parcelamentoDebitoParcelasDTO = this.parcelamentoService.findParcelamentoDebitoParcelas(idParcelamento);
        NumeroParcelasImpressaoBoletoDTO numeroParcelas = this.buscarNumeroParcelasImpressaoBoleto(parcelamento, paramParcelamento, parcelamentoDebitoParcelasDTO);
        ImpressaoBoletoParcelamentoDTO impressaoBoletoParcelamentoDTO = ImpressaoBoletoParcelamentoDTO.of((Parcelamento)parcelamento, (ParamParcelamento)paramParcelamento, (List)parcelamentoDebitoParcelasDTO, (FormaPagamento)formaPagamento);
        impressaoBoletoParcelamentoDTO.setQuantidadeParcelas(numeroParcelas.getQuantidadeParcelaAberta());
        return this.imprimirBoletoAise(impressaoBoletoParcelamentoDTO);
    }

    public SimulacaoParcelamentoDTO getSimulacoesCidadao(SimulacaoParcelamentoRequestDTO request) {
        Assert.notNull((Object)request.getTipoCadastro(), (String)"Par\u00e2metro tipo cadastro est\u00e1 nulo.");
        Assert.notNull((Object)request.getCadastroGeral(), (String)"Par\u00e2metro cadastro geral est\u00e1 nulo.");
        Assert.notNull((Object)request.getIdParamParcelamento(), (String)"Par\u00e2metro id do par\u00e2metro parcelamento est\u00e1 nulo.");
        Assert.notNull((Object)request.getNumeroParcela(), (String)"Par\u00e2metro numero de parcela \u00e9 obrigat\u00f3rio.");
        Assert.notEmpty((Collection)request.getIdDebitos(), (String)"Lista de d\u00e9bitos est\u00e1 vazia.");
        ParamParcelamento paramParcelamento = this.getParamParcelamentoComApenasUmaEntrada(request.getIdParamParcelamento());
        Boolean concedeDescontoNoPagamento = paramParcelamento.getDescontosPorParcela().stream().anyMatch(desconto -> Boolean.TRUE.equals(desconto.getConcedeDescontoNoPagamento()));
        LocalDate dataCorrecao = LocalDate.now();
        LOGGER.info("Iniciando simula\u00e7\u00f5es para o parcelamento da lei {} cadastro {} com {} parcelas", new Object[]{request.getIdParamParcelamento(), request.getCadastroGeral(), request.getNumeroParcela()});
        SimulacaoParcelamentoDTO simulacaoParam = this.getSimulacaoParcelamentoDTO(request, paramParcelamento, dataCorrecao);
        this.validaParcelamento(simulacaoParam, paramParcelamento);
        paramParcelamento.getEntradas().stream().findFirst().ifPresent(paramParcelamentoEntrada -> {
            if (Boolean.TRUE.equals(paramParcelamentoEntrada.getEntradaValorNegociado())) {
                simulacaoParam.setNumeroParcelas(Integer.valueOf(1));
                simulacaoParam.setValorEntrada(BigDecimal.ZERO);
            }
        });
        SimulacaoParcelamentoDTO retorno = this.internalSimularParcelamento(simulacaoParam);
        retorno.setConcedeDescontoNoPagamento(concedeDescontoNoPagamento);
        retorno.setValorTotalAvista();
        return retorno;
    }

    private ParamParcelamento getParamParcelamentoComApenasUmaEntrada(Long idParamParcelamento) {
        ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoService.findById((Serializable)idParamParcelamento).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado par\u00e2metro de parcelamento %s", idParamParcelamento)));
        if (paramParcelamento.getEntradas().size() > 1) {
            LOGGER.error("Par\u00e2metro Parcelado {} possui {} entradas configuradas", (Object)idParamParcelamento, (Object)paramParcelamento.getEntradas().size());
            throw new EloValidationException(String.format("Par\u00e2metro Parcelamento %s possui mais de uma entrada configurada", idParamParcelamento));
        }
        return paramParcelamento;
    }

    private SimulacaoParcelamentoDTO getSimulacaoParcelamentoDTO(SimulacaoParcelamentoRequestDTO request, ParamParcelamento paramParcelamento, LocalDate dataCorrecao) {
        SimulacaoParcelamentoDTO simulacaoParam = new SimulacaoParcelamentoDTO();
        simulacaoParam.setTipoCadastro(Integer.valueOf(request.getTipoCadastro().intValue()));
        simulacaoParam.setCadastroGeral(request.getCadastroGeral());
        simulacaoParam.setTipo(paramParcelamento.getTipo());
        simulacaoParam.setIdParametroParcelamento(paramParcelamento.getId());
        simulacaoParam.setDataCorrecao(dataCorrecao);
        simulacaoParam.setNumeroParcelas(Integer.valueOf(request.getNumeroParcela().intValue()));
        simulacaoParam.setEntrada((Long)paramParcelamento.getEntradas().stream().findFirst().map(ParamParcelamentoEntrada::getId).map(ParamParcelamentoEntradaId::getEntrada).orElse(null));
        simulacaoParam.setRequerente(request.getRequerente());
        simulacaoParam.setDebitos(request.getIdDebitos());
        simulacaoParam.setTotalSelecionado(request.getValorTotal());
        simulacaoParam.setTipoDesconto(paramParcelamento.getTipoDesconto().getValue());
        return simulacaoParam;
    }

    private LocalDate getDataVencimentoFimImpressaoBoleto(NumeroParcelasImpressaoBoletoDTO dto) {
        LocalDate dataVencimentoCalculada = dto.getDataVencimentoInicio().plusMonths(dto.getNumeroParcela().intValue());
        return Stream.of(dataVencimentoCalculada, dto.getDataLimiteVencimento()).min(LocalDate::compareTo).orElse(dto.getDataLimiteVencimento());
    }

    private Integer getNumeroParcelaImpressaoBoleto(NumeroParcelasImpressaoBoletoDTO dto) {
        return Integer.min(NUMERO_PADRAO_PARCELAS_IMPRESSAO, dto.getNumeroParcela());
    }

    public byte[] imprimirCarneParcelamentoAise(ImpressaoBoletoParcelamentoDTO request) {
        request.getParcelamentos().forEach(p -> {
            Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)p.getIdParcelamento());
            p.setIdParametroParcelamento(parcelamento.getIdParametroParcelamento());
        });
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        return (byte[])this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tparcelamentos/ImprimirCarneParcelamento", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), byte[].class, new Object[0]).getBody();
    }

    private void validaValorMinimoParametrizadoParaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)simulacaoParcelamentoDTO.getIdParametroParcelamento());
        this.validaValorMinimoParametrizadoParaParcelamento(simulacaoParcelamentoDTO, paramParcelamento);
    }

    private void validaValorMinimoParametrizadoParaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, ParamParcelamento paramParcelamento) {
        BigDecimal valorMinimoExigido;
        BigDecimal valorTotalParcelamento = simulacaoParcelamentoDTO.getTotalSelecionado();
        if (valorTotalParcelamento.compareTo(valorMinimoExigido = paramParcelamento.getValorMinimoParcelamento()) < 0) {
            String valorComDuasCasasDecimais = valorMinimoExigido.setScale(2, RoundingMode.CEILING).toString().replace(".", ",");
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O valor da d\u00edvida a ser parcelada n\u00e3o pode ser inferior a R$ %s", valorComDuasCasasDecimais));
        }
    }

    @Generated
    public AiseParcelamentoServiceRest(RestTemplate restTemplate, AiseLoginServiceRest aiseLoginServiceRest, TributosProperties tributosProperties, ParamParcelamentoService paramParcelamentoService, ParcelamentoService parcelamentoService, ParametroGeralService parametroGeralService, FormaPagamentoService formaPagamentoService, ContextService contextService, ConfigurableEnvironment environment, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService, ObjectMapper objectMapper, HistoricoAtendimentoService historicoAtendimentoService) {
        this.restTemplate = restTemplate;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.tributosProperties = tributosProperties;
        this.paramParcelamentoService = paramParcelamentoService;
        this.parcelamentoService = parcelamentoService;
        this.parametroGeralService = parametroGeralService;
        this.formaPagamentoService = formaPagamentoService;
        this.contextService = contextService;
        this.environment = environment;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
        this.objectMapper = objectMapper;
        this.historicoAtendimentoService = historicoAtendimentoService;
    }
}

