/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoAtualizacaoMonetariaCredValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class EstornoAtualizacaoMonetariaCredValidacaoService {
    private static final Long CODIGO_ESCOPO_LEI = 22L;

    public List<ErrosImportacaoSIMAM> validateEstornoAtualizacaoMonetariaCred(EstornoAtualizacaoMonetariaCredValidacaoDTO dto, StepExecution stepExecution) {
        ArrayList<Optional> erros = new ArrayList<Optional>();
        erros.add(this.validateRegistroDuplicado(dto));
        erros.add(this.validateSequenciaNrEstorno(dto));
        erros.add(this.validateNrAtualizacaoNrAnoAtualizacao(dto));
        erros.add(this.validateCdControleLeiAto(dto));
        erros.add(this.validateDtEstorno(dto, stepExecution));
        erros.add(this.validateVlEstorno(dto));
        erros.add(this.validateDsMotivo(dto));
        erros.add(this.validateNrAnoEstorno(dto));
        return erros.stream().flatMap(Optional::stream).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicado(EstornoAtualizacaoMonetariaCredValidacaoDTO dto) {
        if (dto.getQtdRegistros() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceAtualizaMoneCredEst(), (String)"O conjunto (idPessoa, nrEstorno e nrAnoEstorno) da tabela (EstornoAtualizacaoCredito) apresenta-se com registro duplicado no ano de trabalho", (Long)1332L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateSequenciaNrEstorno(EstornoAtualizacaoMonetariaCredValidacaoDTO dto) {
        if (dto.getNrEstorno() - dto.getNrEstornoAnterior() != 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceAtualizaMoneCredEst(), (String)"A combina\u00e7\u00e3o (nrEstorno e nrAnoEstorno) da tabela (EstornoAtualizacaoCredito) apresenta-se quebra da ordem sequencial num\u00e9rica no ano de trabalho.", (Long)1333L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrAtualizacaoNrAnoAtualizacao(EstornoAtualizacaoMonetariaCredValidacaoDTO dto) {
        if (Objects.isNull(dto.getNrAtualizacao()) || Objects.isNull(dto.getNrAnoAtualizacao())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceAtualizaMoneCredEst(), (String)"A combina\u00e7\u00e3o (nrAtualizacao e nrAnoAtualizacao) da tabela (EstornoAtualizacaoCredito) n\u00e3o existe na tabela (AtualizacaoCredito).", (Long)1334L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateCdControleLeiAto(EstornoAtualizacaoMonetariaCredValidacaoDTO dto) {
        if (Objects.isNull(dto.getCdControleLeiAto()) || CODIGO_ESCOPO_LEI.equals(dto.getEscopoLei())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceAtualizaMoneCredEst(), (String)"O Controle da Lei/Ato (cdControleLeiAto) declarado da tabela (EstornoAtualizacaoCredito) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.", (Long)1335L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDtEstorno(EstornoAtualizacaoMonetariaCredValidacaoDTO dto, StepExecution stepExecution) {
        LocalDate mesValidacao = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Month mesEstorno = dto.getDtEstorno().getMonth();
        Year anoEstorno = Year.of(dto.getDtEstorno().getYear());
        if (Objects.isNull(dto.getDtAtualizacao()) || dto.getDtEstorno().isBefore(dto.getDtAtualizacao()) || !mesEstorno.equals(mesValidacao.getMonth()) || !anoEstorno.equals(Year.of(mesValidacao.getYear()))) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceAtualizaMoneCredEst(), (String)"A data do estorno (dtEstorno) declarada da tabela (EstornoAtualizacaoCredito) n\u00e3o pode sermenor que (dtAtualizacao) informada na tabela (AtualizacaoCredito) e nem maior que o m\u00eas/ano de trabalho.", (Long)1336L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVlEstorno(EstornoAtualizacaoMonetariaCredValidacaoDTO dto) {
        if (Objects.isNull(dto.getVlEstorno()) || dto.getVlEstorno().compareTo(BigDecimal.ZERO) < 0) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceAtualizaMoneCredEst(), (String)"O Valor do Estorno (vlEstorno) da tabela (EstornoAtualizacaoCredito) nao pode ser negativo.", (Long)1337L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDsMotivo(EstornoAtualizacaoMonetariaCredValidacaoDTO dto) {
        if (Objects.isNull(dto.getDsMotivo()) || dto.getDsMotivo().length() < 20) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceAtualizaMoneCredEst(), (String)"A descri\u00e7\u00e3o do motivo do estorno (dsMotivo) declarado na tabela (EstornoAtualizacaoCredito) n\u00e3o pode conter menos de 20 caracteres.", (Long)1338L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrAnoEstorno(EstornoAtualizacaoMonetariaCredValidacaoDTO dto) {
        if (dto.getNrAnoEstorno() < 2023L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceAtualizaMoneCredEst(), (String)"O registro declarado da tabela (EstornoAtualizacaoCredito) n\u00e3o pode estar vinculado com ano de cr\u00e9dito (nrAnoCredito) menor que o exerc\u00edcio financeiro de 2023.", (Long)2244L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }
}

