/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.DeducaoCreditoDaValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class DeducaoCreditoDaValidacaoAmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeducaoCreditoDaValidacaoAmService.class);
    private static final Long ESCOPO_LEI_MUNICIPAIS = 22L;
    private static final Long EXERCICIO_VALIDACAO_DIVIDA = 2023L;

    public List<ErrosImportacaoSIMAM> validate(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO, StepExecution stepExecution) {
        log.debug("Iniciando valida\u00e7\u00e3o de DeducaoCreditoDa do registro {}", (Object)deducaoCreditoDaValidacaoDTO);
        ArrayList<Optional> erros = new ArrayList<Optional>();
        erros.add(this.validateRegistroDeducaoDuplicado(deducaoCreditoDaValidacaoDTO));
        erros.add(this.validateSequencia(deducaoCreditoDaValidacaoDTO));
        erros.add(this.validateDivida(deducaoCreditoDaValidacaoDTO));
        erros.add(this.validateTipoDeducao(deducaoCreditoDaValidacaoDTO));
        erros.add(this.validateLeiAto(deducaoCreditoDaValidacaoDTO));
        erros.add(this.validateDataDeducao(deducaoCreditoDaValidacaoDTO, stepExecution));
        erros.add(this.validateValorDeducao(deducaoCreditoDaValidacaoDTO));
        erros.add(this.validateDescricaoMotivo(deducaoCreditoDaValidacaoDTO));
        erros.add(this.validateRegistroCreditoDuplicado(deducaoCreditoDaValidacaoDTO));
        erros.add(this.validateVinculoAnoDivida(deducaoCreditoDaValidacaoDTO));
        return erros.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDeducaoDuplicado(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO) {
        if (deducaoCreditoDaValidacaoDTO.getQtdRegistrosDeducaoDa() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"O conjunto (nrDeducao, nrAnoDeducao) declarado na tabela (DeducaoDividaAtiva) apresenta-se com registro duplicado.", (Long)1389L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateSequencia(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO) {
        if (deducaoCreditoDaValidacaoDTO.getNrDeducaoAnterior() != 0L && deducaoCreditoDaValidacaoDTO.getNrDeducao() - deducaoCreditoDaValidacaoDTO.getNrDeducaoAnterior() != 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"A combina\u00e7\u00e3o (nrDeducao e nrAnoDeducao) declarada na tabela (DeducaoDividaAtiva) apresenta-se com quebra da ordem sequencial no ano de trabalho.", (Long)1390L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDivida(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoDaValidacaoDTO.getNrDivida()) || Objects.isNull(deducaoCreditoDaValidacaoDTO.getNrAnoDivida())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"O N\u00famero e Ano da D\u00edvida Ativa (nrDivida e nrAnoDivida) declarados na tabela (DeducaoDividaAtiva) n\u00e3o existe na tabela (InscricaoDividaAtiva).", (Long)1391L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateTipoDeducao(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoDaValidacaoDTO.getTipoDeducao())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"O Tipo de Dedu\u00e7\u00e3o da D\u00edvida Ativa (idTipoDeducaoCredito) declarado na tabela (DeducaoDividaAtiva) n\u00e3o existe na tabela (TipoDeducaoCredito).", (Long)1392L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateLeiAto(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoDaValidacaoDTO.getEscopolei()) || !deducaoCreditoDaValidacaoDTO.getEscopolei().equals(ESCOPO_LEI_MUNICIPAIS)) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"O Controle de Lei/Ato (cdControleLeiAto) declarado na tabela (DeducaoDividaAtiva) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.", (Long)1393L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDataDeducao(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO, StepExecution stepExecution) {
        LocalDate dataReferencia = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        if (Objects.isNull(deducaoCreditoDaValidacaoDTO.getDtDeducao()) || Objects.isNull(deducaoCreditoDaValidacaoDTO.getDtInscricao()) || deducaoCreditoDaValidacaoDTO.getDtDeducao().isBefore(deducaoCreditoDaValidacaoDTO.getDtInscricao()) || YearMonth.from(deducaoCreditoDaValidacaoDTO.getDtDeducao()).isAfter(YearMonth.from(dataReferencia))) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"A data da dedu\u00e7\u00e3o (dtDeducao) declarada na tabela (DeducaoDividaAtiva) n\u00e3o pode ser menor que (dtInscricao) informada na tabela (InscricaoDividaAtiva).", (Long)1394L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateValorDeducao(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoDaValidacaoDTO.getVlDeducao()) || deducaoCreditoDaValidacaoDTO.getVlDeducao().signum() == -1) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"O valor da dedu\u00e7\u00e3o da d\u00edvida ativa (vlDeducao) declarado na tabela (DeducaoDividaAtiva) n\u00e3o pode ser negativo.", (Long)1395L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDescricaoMotivo(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoDaValidacaoDTO.getDsMotivo()) || deducaoCreditoDaValidacaoDTO.getDsMotivo().length() < 20) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"A descri\u00e7\u00e3o do motivo da dedu\u00e7\u00e3o da d\u00edvida ativa (dsMotivo) declarada na tabela (DeducaoDividaAtiva) deve conter no m\u00ednimo 20 (vinte) caracteres.", (Long)1396L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroCreditoDuplicado(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoDaValidacaoDTO.getQtdRegistrosDivida()) || deducaoCreditoDaValidacaoDTO.getQtdRegistrosDivida() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"O registro declarado na tabela (DeducaoDividaAtiva) para o conjunto (nrAnoDeducao, nrDivida, nrAnoDivida, idTipoDeducaoCredito, cdControleLeiAto, dtDeducao) n\u00e3o pode ser duplicado ou ausente.", (Long)2119L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVinculoAnoDivida(DeducaoCreditoDaValidacaoDTO deducaoCreditoDaValidacaoDTO) {
        if (Objects.isNull(deducaoCreditoDaValidacaoDTO.getNrAnoDivida()) || deducaoCreditoDaValidacaoDTO.getNrAnoDivida() < EXERCICIO_VALIDACAO_DIVIDA) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)deducaoCreditoDaValidacaoDTO.getIdTceDeducaoCreditoDa(), (String)"O registro declarado na linha xxxx da tabela (DeducaoDividaAtiva) n\u00e3o pode estar vinculado com ano de d\u00edvida (nrAnoDivida) menor que o exerc\u00edcio financeiro de 2023.", (Long)2251L, (TipoRegistroSimAm)TipoRegistroSimAm.DEDUCAO_CREDITO_DIVIDA_ATIVA));
        }
        return Optional.empty();
    }
}

