/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sanepar;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar;
import br.com.elotech.tributos.repository.sanepar.BaixaSaneparItemRepository;
import br.com.elotech.tributos.service.sanepar.SaneparMatriculaService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VerificacaoSaneparService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerificacaoSaneparService.class);
    private final BaixaSaneparItemRepository baixaSaneparItemRepository;
    private final SaneparMatriculaService saneparMatriculaService;
    private final SituacaoItemSanepar ERROR = SituacaoItemSanepar.ERRO_VALIDACAO;
    private final SituacaoItemSanepar SUCCESS = SituacaoItemSanepar.VALIDADO;
    private final String SUCCESS_MESSAGE = "Apto para baixa";

    public void verificarBatch(BaixaSaneparItem item) {
        this.verifica(item);
    }

    public void verificar(Long idBaixaSanepar, Long idBaixaSaneparItem) {
        BaixaSaneparItem item = this.findBaixaSaneparItems(idBaixaSanepar, idBaixaSaneparItem);
        this.verifica(item);
        this.save(item);
    }

    private BaixaSaneparItem findBaixaSaneparItems(Long idBaixaSanepar, Long idBaixaSaneparItem) {
        return (BaixaSaneparItem)this.baixaSaneparItemRepository.findById((Object)idBaixaSaneparItem).orElseThrow(() -> new EloValidationException(String.format("Item %s do lote %s n\u00e3o encontrado", idBaixaSaneparItem, idBaixaSanepar)));
    }

    public void verifica(BaixaSaneparItem item) {
        long loteId = item.getBaixa().getId();
        log.debug("Iniciando processo de valida\u00e7\u00e3o dos itens do lote: [{}] ", (Object)loteId);
        try {
            this.validate(item);
            item.setSituacao(this.SUCCESS);
            item.setMensagem("Apto para baixa");
        }
        catch (Exception e) {
            item.setSituacao(this.ERROR);
            item.setMensagem(e.getMessage());
        }
        log.debug("Finalizando processo de valida\u00e7\u00e3o dos itens do lote: [{}] ", (Object)loteId);
    }

    public void validate(BaixaSaneparItem item) {
        this.validaSeTemMatriculaCadastrada(item);
        this.validaSeTemMaisDeUmCadastroDaMatricula(item);
        this.validaSeTemVinculoComCadastroAvulsoRuralMobiliarioOuImobiliario(item);
    }

    private void validaSeTemMatriculaCadastrada(BaixaSaneparItem item) {
        boolean exists = this.saneparMatriculaService.existsByMatricula(item.getMatricula());
        if (!exists) {
            this.registraInconsistencia("Matr\u00edcula n\u00e3o cadastrada");
        }
    }

    private void validaSeTemMaisDeUmCadastroDaMatricula(BaixaSaneparItem item) {
        int count = this.saneparMatriculaService.countByMatricula(item.getMatricula());
        if (count > 1) {
            this.registraInconsistencia("Matr\u00edcula est\u00e1 registrada para mais de um cadastro");
        }
    }

    private void validaSeTemVinculoComCadastroAvulsoRuralMobiliarioOuImobiliario(BaixaSaneparItem item) {
        boolean exists = this.saneparMatriculaService.existsVinculoComCadastroAvulsoRuralMobiliarioOuImobiliario(item.getMatricula());
        if (!exists) {
            this.registraInconsistencia("Matr\u00edcula n\u00e3o est\u00e1 vinculada \u00e0 cadastros dos tipos Avulso, Imobili\u00e1rio, Mobili\u00e1rio ou Rural");
        }
    }

    private void save(BaixaSaneparItem item) {
        this.baixaSaneparItemRepository.save((Object)item);
    }

    private void registraInconsistencia(String message) {
        throw new EloValidationException(message);
    }

    @Generated
    public VerificacaoSaneparService(BaixaSaneparItemRepository baixaSaneparItemRepository, SaneparMatriculaService saneparMatriculaService) {
        this.baixaSaneparItemRepository = baixaSaneparItemRepository;
        this.saneparMatriculaService = saneparMatriculaService;
    }
}

