/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.requerimento;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.domain.TipoRequerimentoItem;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.RelatorioPK;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.domain.requerimento.Requerimento;
import br.com.elotech.tributos.domain.requerimento.RequerimentoId;
import br.com.elotech.tributos.domain.requerimento.RequerimentoItem;
import br.com.elotech.tributos.domain.requerimento.RequerimentoItemId;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.GerarDebitoRequestDTO;
import br.com.elotech.tributos.dto.GerarDebitoResponseDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.requerimento.RequerimentoDTO;
import br.com.elotech.tributos.enums.TipoAcaoAtendimento;
import br.com.elotech.tributos.repository.requerimento.RequerimentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AiseDebitoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.HistoricoAtendimentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.TipoRequerimentoItemService;
import br.com.elotech.tributos.service.TipoRequerimentoService;
import br.com.elotech.tributos.service.TributoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.util.LongUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class RequerimentoService
extends CrudService<Requerimento, RequerimentoId> {
    private final CadastroGeralService cadastroGeralService;
    private final PessoaService pessoaService;
    private final TipoRequerimentoService tipoRequerimentoService;
    private final TipoRequerimentoItemService tipoRequerimentoItemService;
    private final TributoService tributoService;
    private final AiseDebitoService aiseDebitoService;
    private final GeraBoletoService geraBoletoService;
    private final RequerimentoRepository requerimentoRepository;
    private final ContextService contextService;
    private final AisePdfService aisePdfService;
    private final ParametroGeralService parametroGeralService;
    private final HistoricoAtendimentoService historicoAtendimentoService;

    public RequerimentoId gerar(RequerimentoDTO requerimentoDTO) {
        Pessoa pessoaRequerente = (Pessoa)this.pessoaService.findById(requerimentoDTO.getRequerente()).orElseThrow(() -> new EloValidationException("Requerente n\u00e3o encontrado"));
        TipoRequerimento tipoRequerimento = (TipoRequerimento)this.tipoRequerimentoService.findById((Serializable)requerimentoDTO.getTipoRequerimento()).orElseThrow(() -> new EloValidationException("Tipo do requerimento n\u00e3o encontrado"));
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)requerimentoDTO.getTipoCadastro()), requerimentoDTO.getCadastroGeral()).orElseThrow(() -> new EloValidationException("Cadastro n\u00e3o encontrado"));
        if (Objects.nonNull(requerimentoDTO.getIdProcesso()) && Objects.isNull(requerimentoDTO.getExercicioProcesso()) || Objects.isNull(requerimentoDTO.getIdProcesso()) && Objects.nonNull(requerimentoDTO.getExercicioProcesso())) {
            throw new EloValidationException("Os campos ano processo e n\u00b0 processo s\u00e3o dependentes e n\u00e3o podem ser preenchidos separadamente");
        }
        RequerimentoId id = new RequerimentoId();
        id.setEntidade(requerimentoDTO.getEntidade());
        id.setExercicio(requerimentoDTO.getExercicio());
        Requerimento requerimento = new Requerimento();
        requerimento.setId(id);
        requerimento.setTipoRequerimento(tipoRequerimento);
        requerimento.setCadastroGeral(cadastroGeral);
        requerimento.setPessoa(pessoaRequerente);
        requerimento.setDataRequerimento(requerimentoDTO.getDataLancamento());
        requerimento.setIdProcesso(requerimentoDTO.getIdProcesso());
        requerimento.setExercicioProcesso(requerimentoDTO.getExercicioProcesso());
        requerimento.setUsuario(SecurityUtils.getUserAise());
        requerimento.setData(LocalDate.now());
        Requerimento savedEntity = (Requerimento)this.requerimentoRepository.save((Object)requerimento);
        savedEntity.getItens().addAll(this.getRequerimentoItems(requerimentoDTO, tipoRequerimento, savedEntity));
        savedEntity.addParcela(requerimentoDTO.getDataVencimento());
        savedEntity.addObservacoes(requerimentoDTO.getObservacoes());
        DebitoIdDTO debitoIdDTO = this.gerarDebitoRequerimento(savedEntity);
        this.getEm().flush();
        Bloqueto boleto = this.geraBoletoRequerimento(debitoIdDTO.getIdDebito());
        savedEntity.setExercicioDebito(debitoIdDTO.getExercicio());
        savedEntity.setDivida(debitoIdDTO.getDivida());
        savedEntity.setSubDivida(debitoIdDTO.getSubDivida());
        savedEntity.setBoleto(boleto);
        this.historicoAtendimentoService.createHistoricoAtendimento(String.format("Gerado requerimento %s/%s do tipo %s ", savedEntity.getId().getRequerimento(), savedEntity.getId().getExercicio(), savedEntity.getTipoRequerimento().getDescricao()), TipoAcaoAtendimento.GERACAO_REQUERIMENTO);
        return ((Requerimento)this.requerimentoRepository.save((Object)savedEntity)).getId();
    }

    private List<RequerimentoItem> getRequerimentoItems(RequerimentoDTO requerimentoDTO, TipoRequerimento tipoRequerimento, Requerimento savedEntity) {
        RequerimentoId id = savedEntity.getId();
        return requerimentoDTO.getItens().stream().filter(item -> item.getQuantidade().multiply(item.getValorUnitario()).compareTo(BigDecimal.ZERO) > 0).map(itemDto -> {
            TipoRequerimentoItem tipoRequerimentoItem = (TipoRequerimentoItem)this.tipoRequerimentoItemService.findById((Serializable)itemDto.getTipoRequerimentoItem()).orElseThrow(() -> new EloValidationException("Item do Tipo Requerimento n\u00e3o encontrado."));
            if (!tipoRequerimento.equals((Object)tipoRequerimentoItem.getTipoRequerimento())) {
                throw new EloValidationException("Item n\u00e3o pertence ao Tipo do Requerimento informado.");
            }
            Tributo tributo = this.tributoService.findByEntidadeAndExercicioAndTributo(id.getEntidade(), id.getExercicio(), tipoRequerimentoItem.getTributo());
            if (Objects.isNull(tributo)) {
                throw new EloValidationException(String.format("Tributo %s n\u00e3o encontrado na entidade %d e exerc\u00edcio %d.", tipoRequerimentoItem.getTributo(), id.getEntidade(), id.getExercicio()));
            }
            RequerimentoItem requerimentoItem = new RequerimentoItem();
            requerimentoItem.setId(new RequerimentoItemId(id, tipoRequerimentoItem.getId()));
            requerimentoItem.setDescricao(tipoRequerimentoItem.getDescricao());
            requerimentoItem.setQuantidade(itemDto.getQuantidade());
            requerimentoItem.setValorUnitario(itemDto.getValorUnitario());
            requerimentoItem.setTributo(tributo);
            return requerimentoItem;
        }).collect(Collectors.toList());
    }

    private Bloqueto geraBoletoRequerimento(Long idDebito) {
        DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
        debitoParcelaDTO.setIdDebito(idDebito);
        debitoParcelaDTO.setParcela(Long.valueOf(1L));
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.PARCELADO);
        geraBoletoDTO.setDebitos(Collections.singletonList(debitoParcelaDTO));
        geraBoletoDTO.setDataReferencia(this.contextService.getDataAtual());
        geraBoletoDTO.setSomenteConstituidos(Boolean.FALSE);
        return (Bloqueto)this.geraBoletoService.geraBoleto(geraBoletoDTO).stream().findFirst().orElseThrow(() -> new IllegalStateException("Erro ao gerar boleto"));
    }

    private DebitoIdDTO gerarDebitoRequerimento(Requerimento requerimento) {
        Optional requerimentoObservacao = requerimento.getObservacoes().stream().findFirst();
        Optional requerimentoParcela = requerimento.getParcelas().stream().findFirst();
        String receitas = requerimento.getItens().stream().map(arg_0 -> this.mountReceita(arg_0)).reduce("", (accum, elemento) -> accum + elemento);
        GerarDebitoRequestDTO gerarDebitoRequestDTO = new GerarDebitoRequestDTO();
        gerarDebitoRequestDTO.setEntidade(requerimento.getId().getEntidade());
        gerarDebitoRequestDTO.setExercicio(requerimento.getId().getExercicio());
        gerarDebitoRequestDTO.setTipoCadastro(requerimento.getCadastroGeral().getTipoCadastro().getValue());
        gerarDebitoRequestDTO.setCadastroGeral(requerimento.getCadastroGeral().getCadastroGeral());
        gerarDebitoRequestDTO.setGuiaRecolhimento(requerimento.getTipoRequerimento().getDivida().getDivida());
        Optional.of(receitas).ifPresent(arg_0 -> ((GerarDebitoRequestDTO)gerarDebitoRequestDTO).setReceitaLista(arg_0));
        gerarDebitoRequestDTO.setDataLancamento(requerimento.getDataRequerimento());
        requerimentoParcela.ifPresent(parcela -> gerarDebitoRequestDTO.setDataVencimento(parcela.getDataVencimento()));
        requerimentoParcela.ifPresent(parcela -> gerarDebitoRequestDTO.setValorPrincipal(parcela.getValor()));
        requerimentoObservacao.ifPresent(observacao -> gerarDebitoRequestDTO.setObservacao(observacao.getObservacao()));
        return DebitoIdDTO.from((GerarDebitoResponseDTO)this.aiseDebitoService.geraDebito(gerarDebitoRequestDTO));
    }

    public ImpressaoDTO imprimirBoletoRequerimento(RequerimentoId id) {
        Requerimento requerimento = this.findRequerimentoParaImpressao(id);
        Long boleto = requerimento.getBoleto().getBloqueto();
        Long exercicioBoleto = requerimento.getBoleto().getExercicioBloqueto();
        return Optional.ofNullable(requerimento.getTipoRequerimento()).map(TipoRequerimento::getRelatorioBoleto).map(Relatorio::getId).or(() -> {
            Long relatorioParamGeral = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.RELATORIO_PADRAO_REQUERIMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            String tipoRelatorioParamGeral = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TIPO_RELATORIO_PADRAO_REQUERIMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            TipoRelatorio tipoRelatorio = TipoRelatorio.fromValue((String)tipoRelatorioParamGeral);
            return !LongUtils.isNullOrZero((Long)relatorioParamGeral) && Objects.nonNull(tipoRelatorio) ? Optional.of(RelatorioPK.from((String)ModuloEnum.MODULO_TRIBUTARIO.getValue(), (TipoRelatorio)tipoRelatorio, (Integer)relatorioParamGeral.intValue())) : Optional.empty();
        }).map(idRelatorio -> ImpressaoDTO.from((String)this.aisePdfService.fetchBoletoRequerimento(boleto, exercicioBoleto, Long.valueOf(idRelatorio.getRelatorio().longValue()), idRelatorio.getTipoRelatorio().getTipo()))).orElseGet(() -> ImpressaoDTO.from((String)this.aisePdfService.fetchBloquetoByExercicio(boleto, exercicioBoleto)));
    }

    private Requerimento findRequerimentoParaImpressao(RequerimentoId id) {
        Requerimento requerimento = (Requerimento)this.requerimentoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException("Requerimento n\u00e3o encontrado!"));
        Bloqueto boleto = requerimento.getBoleto();
        if (Objects.isNull(boleto)) {
            throw new EloValidationException("Requerimento n\u00e3o possui um boleto.");
        }
        if (boleto.getPago().booleanValue()) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel imprimir um boleto pago.");
        }
        if (boleto.getVencido().booleanValue()) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel imprimir um boleto vencido.");
        }
        return requerimento;
    }

    private String mountReceita(RequerimentoItem item) {
        String tributo = item.getTributo().getTributo();
        BigDecimal valor = item.getValorTotal();
        Locale locale = new Locale("pt", "BR");
        return String.format(locale, "%s|%.2f|0|0|0|%.2f;", tributo, valor, valor);
    }

    @Generated
    public RequerimentoService(CadastroGeralService cadastroGeralService, PessoaService pessoaService, TipoRequerimentoService tipoRequerimentoService, TipoRequerimentoItemService tipoRequerimentoItemService, TributoService tributoService, AiseDebitoService aiseDebitoService, GeraBoletoService geraBoletoService, RequerimentoRepository requerimentoRepository, ContextService contextService, AisePdfService aisePdfService, ParametroGeralService parametroGeralService, HistoricoAtendimentoService historicoAtendimentoService) {
        this.cadastroGeralService = cadastroGeralService;
        this.pessoaService = pessoaService;
        this.tipoRequerimentoService = tipoRequerimentoService;
        this.tipoRequerimentoItemService = tipoRequerimentoItemService;
        this.tributoService = tributoService;
        this.aiseDebitoService = aiseDebitoService;
        this.geraBoletoService = geraBoletoService;
        this.requerimentoRepository = requerimentoRepository;
        this.contextService = contextService;
        this.aisePdfService = aisePdfService;
        this.parametroGeralService = parametroGeralService;
        this.historicoAtendimentoService = historicoAtendimentoService;
    }
}

