/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.dto.deducaoanaliticacontribuinte.DeducaoAnaliticaContribuinteDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroDeducaoAnaliticaContribuinteDTO;
import br.com.elotech.tributos.repository.integracaocontabil.DeducaoAnaliticaContribuinteRepository;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DeducaoAnaliticaContribuinteService {
    private final DeducaoAnaliticaContribuinteRepository deducaoAnaliticaContribuinteRepository;
    private final EntidadeServiceImpl entidadeServiceImpl;

    public List<DeducaoAnaliticaContribuinteDTO> findAllDeducoesAnaliticasContribuinte(Long idEntidade, LocalDate dataInicial, LocalDate dataFinal) {
        Entidade entidade = this.findEntidade(idEntidade);
        FiltroDeducaoAnaliticaContribuinteDTO filtroDeducaoAnalitica = new FiltroDeducaoAnaliticaContribuinteDTO();
        filtroDeducaoAnalitica.setIdEntidade(entidade.getId());
        filtroDeducaoAnalitica.setDataDeducaoInicial(dataInicial);
        filtroDeducaoAnalitica.setDataDeducaoFinal(dataFinal);
        return this.deducaoAnaliticaContribuinteRepository.findAllDeducoesAnaliticasContribuinte(filtroDeducaoAnalitica).stream().map(DeducaoAnaliticaContribuinteDTO::of).collect(Collectors.toList());
    }

    private Entidade findEntidade(Long idEntidade) {
        return (Entidade)this.entidadeServiceImpl.findById((Serializable)idEntidade).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado entidade com id %d.", idEntidade)));
    }

    @Generated
    public DeducaoAnaliticaContribuinteService(DeducaoAnaliticaContribuinteRepository deducaoAnaliticaContribuinteRepository, EntidadeServiceImpl entidadeServiceImpl) {
        this.deducaoAnaliticaContribuinteRepository = deducaoAnaliticaContribuinteRepository;
        this.entidadeServiceImpl = entidadeServiceImpl;
    }
}

