/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.tributos.domain.integracoes.IntegracaoToken;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.repository.integracoes.IntegracaoTokenRepository;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.JWTTokenUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoTokenJWTServiceImpl
implements IntegracaoTokenService {
    private final IntegracaoTokenRepository repository;

    public IntegracaoTokenJWTServiceImpl(IntegracaoTokenRepository repository) {
        this.repository = repository;
    }

    public Optional<String> getAccessToken(Long codigoBanco, IntegracaoTokenOperation operation) {
        return this.getIntegracaoToken(codigoBanco, operation).filter(IntegracaoToken::isValid).map(IntegracaoToken::getValor);
    }

    public boolean accept(String tipo) {
        return "JWT".equals(tipo);
    }

    public String saveIntegracaoToken(Long codigoBanco, IntegracaoTokenOperation operation, JsonNode json) {
        Optional token = this.getIntegracaoToken(codigoBanco, operation);
        String newAccessToken = json.get("access_token").asText();
        return token.isEmpty() ? this.createIntegracaoToken(codigoBanco, operation, newAccessToken).getValor() : this.updateIntegracaoToken((IntegracaoToken)token.get(), newAccessToken).getValor();
    }

    private Optional<IntegracaoToken> getIntegracaoToken(Long codigoBanco, IntegracaoTokenOperation operation) {
        return this.repository.findIntegracaoTokenByBancoAndAndOperation(codigoBanco, operation);
    }

    private IntegracaoToken createIntegracaoToken(Long codigoBanco, IntegracaoTokenOperation operation, String newAccessToken) {
        IntegracaoToken token = new IntegracaoToken();
        token.setBanco(codigoBanco);
        token.setOperation(operation);
        token.setValor(newAccessToken);
        token.setExpiracao(this.getExpirationTimeInSecondsFromJWTToken(newAccessToken));
        return (IntegracaoToken)this.repository.save((Object)token);
    }

    private IntegracaoToken updateIntegracaoToken(IntegracaoToken token, String newAccessToken) {
        token.setValor(newAccessToken);
        token.setExpiracao(this.getExpirationTimeInSecondsFromJWTToken(newAccessToken));
        return (IntegracaoToken)this.repository.save((Object)token);
    }

    private String getExpirationTimeInSecondsFromJWTToken(String encodedToken) {
        return (String)((HashMap)JWTTokenUtils.decodeToken((String)encodedToken).get("payload")).get("exp");
    }
}

