/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.comunicado;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.enums.comunicado.TipoComunicadoGeracaoManual;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ComunicadoManualJobStarter {
    @Qualifier(value="comunicadoManualBatchJob")
    private final Job comunicadoManualBatchJob;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;

    public ComunicadoManualJobStarter(@Qualifier(value="comunicadoManualBatchJob") Job comunicadoManualBatchJob, JobLauncher jobLauncher, JobExplorer jobExplorer) {
        this.comunicadoManualBatchJob = comunicadoManualBatchJob;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
    }

    public JobExecution startJob(Comunicado comunicado, TipoComunicadoGeracaoManual tipoComunicado) {
        this.validaExecucaoDeJobComMesmosFiltros(comunicado);
        return this.start(this.buildJobParameters(comunicado, tipoComunicado));
    }

    private void validaExecucaoDeJobComMesmosFiltros(Comunicado comunicado) {
        boolean existsJobNaoFinalizado = this.jobExplorer.findRunningJobExecutions(JobType.COMUNICADO_GERACAO_MANUAL.getTipo()).stream().anyMatch(jobExecution -> Objects.equals(jobExecution.getJobParameters().getLong("entidade"), comunicado.getId().getEntidade()) && Objects.equals(jobExecution.getJobParameters().getLong("exercicioComunicado"), comunicado.getId().getExercicio()) && Objects.equals(jobExecution.getJobParameters().getLong("idComunicado"), comunicado.getId().getIdComunicado()));
        if (existsJobNaoFinalizado) {
            throw new EloValidationException(String.format("J\u00e1 existe um job sendo executado com os parametro entidade: %s, exercicio: %s e idComunicado: %s", comunicado.getId().getEntidade(), comunicado.getId().getExercicio(), comunicado.getId().getIdComunicado()));
        }
    }

    private JobParameters buildJobParameters(Comunicado comunicado, TipoComunicadoGeracaoManual tipoComunicado) {
        JobParametersBuilder builder = new JobParametersBuilder();
        builder.addLong("entidade", comunicado.getId().getEntidade());
        builder.addLong("exercicioComunicado", comunicado.getId().getExercicio());
        builder.addLong("idComunicado", comunicado.getId().getIdComunicado());
        builder.addString("tipoComunicado", tipoComunicado.toString());
        builder.addString("filtroUtilizado", comunicado.getFiltroUtilizado());
        return builder.toJobParameters();
    }

    private JobExecution start(JobParameters parameters) {
        try {
            return this.jobLauncher.run(this.comunicadoManualBatchJob, parameters);
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new EloValidationException("Job Gera\u00e7\u00e3o de Comunicado Manual j\u00e1 est\u00e1 sendo executado");
        }
        catch (JobRestartException e) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel reiniciar o Job Gera\u00e7\u00e3o de Comunicado Manual");
        }
        catch (JobParametersInvalidException e) {
            throw new EloValidationException("Par\u00e2metros para o Job Gera\u00e7\u00e3o de Comunicado Manual est\u00e1 inv\u00e1lido. Verifique!");
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel reiniciar o Job Gera\u00e7\u00e3o de Comunicado Manual, pois foi conclu\u00eddo com sucesso");
        }
    }
}

