/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroDTO;
import br.com.elotech.tributos.report.loader.LivroDividaAtivaParamLoader;
import br.com.elotech.tributos.repository.LivroRepository;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LivroService
extends CrudService<Livro, LivroId> {
    private final LivroRepository livroRepository;
    private final LivroDividaAtivaParamLoader livroDividaAtivaParamLoader;

    LivroService(LivroRepository livroRepository, LivroDividaAtivaParamLoader livroDividaAtivaParamLoader) {
        this.livroRepository = livroRepository;
        this.livroDividaAtivaParamLoader = livroDividaAtivaParamLoader;
    }

    protected void beforeSave(Livro entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.setLivroRegistroId();
    }

    public Page<LivroDTO> getLivros(String search, Pageable page) {
        if (!StringUtils.isBlank((String)search)) {
            Specification specification = Specification.where((Specification)RsqlUtils.createSpecFrom((EntityManager)this.getEm(), Livro.class, (String)search, Optional.empty()));
            return this.livroRepository.findAll(specification, page).map(livro -> LivroDTO.ofWithTotal((Livro)livro, (Long)this.livroRepository.countTotalRegistros(livro)));
        }
        return this.livroRepository.findAll(page).map(livro -> LivroDTO.ofWithTotal((Livro)livro, (Long)this.livroRepository.countTotalRegistros(livro)));
    }

    public LivroDTO getLivroResumo(Long entidade, Long exercicio, Long livro) {
        return this.livroRepository.getLivroResumo(entidade, exercicio, livro);
    }

    public ImprimirRelatorioDTO getImprimirLivro(Long entidade, Long exercicio, Long livro) {
        Integer REL_LIVRO_DA = 126;
        String filtro = String.format("(a.Entidade = %d and a.Exercicio = %d and a.livro = %d)", entidade, exercicio, livro);
        ImprimirRelatorioDTO imprimirRelatorioDTO = new ImprimirRelatorioDTO();
        imprimirRelatorioDTO.setRelatorio(REL_LIVRO_DA);
        imprimirRelatorioDTO.setListParametros(this.livroDividaAtivaParamLoader.load(Boolean.valueOf(false)));
        imprimirRelatorioDTO.setSubReports(this.createSubreportLivro(filtro));
        return imprimirRelatorioDTO;
    }

    private SubReportDTO createSubreportLivro(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("TermoAbertura", filtro), new SubReportItemDTO("TermoEncerramento", filtro), new SubReportItemDTO("Registro", filtro)}));
        return subReportDTO;
    }
}

