/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.TipoLogradouroGeomaisDTO;
import br.com.elotech.tributos.service.integracaogeomais.TipoLogradouroGeomaisService;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/tipo-logradouro"})
public class TipoLogradouroGeomaisResource {
    private final TipoLogradouroGeomaisService tipoLogradouroGeomaisService;

    public TipoLogradouroGeomaisResource(TipoLogradouroGeomaisService tipoLogradouroGeomaisService) {
        this.tipoLogradouroGeomaisService = tipoLogradouroGeomaisService;
    }

    @ApiOperation(value="Retorna uma lista de tipos de logradouro")
    @GetMapping
    public ResponseEntity<Page<TipoLogradouroGeomaisDTO>> findAll(Pageable page) {
        Page tipos = this.tipoLogradouroGeomaisService.findAll(page).map(TipoLogradouroGeomaisDTO::from);
        return ResponseEntity.ok((Object)tipos);
    }

    @ApiOperation(value="Retorna um tipo de logradouro em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<TipoLogradouroGeomaisDTO> findById(@PathVariable Long id) {
        TipoLogradouroGeomaisDTO tipoLogradouroDTO = this.tipoLogradouroGeomaisService.findById((Serializable)id).map(TipoLogradouroGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Tipo Logradouro com o id '%d'.", id)));
        return ResponseEntity.ok((Object)tipoLogradouroDTO);
    }
}

