/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import br.com.elotech.tributos.dto.FiltroArrecadacaoPorTributoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoResumoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoValoresDTO;
import br.com.elotech.tributos.service.integracaocontabil.ArrecadacaoPorTributoService;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/arrecadacao-por-tributos"})
public class ArrecadacaoPorTributoResource {
    private ArrecadacaoPorTributoService arrecadacaoPorTributoService;
    private final BaseExport baseExport;

    public ArrecadacaoPorTributoResource(ArrecadacaoPorTributoService arrecadacaoPorTributoService, BaseExport baseExport) {
        this.arrecadacaoPorTributoService = arrecadacaoPorTributoService;
        this.baseExport = baseExport;
    }

    @PostMapping(value={"/imprimir"})
    public ModelAndView printArrecadacaoPorTributos(@RequestBody @Valid FiltroArrecadacaoPorTributoDTO filtro, @RequestParam(value="fields") String fields, @RequestParam(value="sumFields") String sumFields, Pageable pageable) {
        Page tributoValoresDTOSPage = this.arrecadacaoPorTributoService.imprimir(filtro, pageable);
        ReportParam reportParam = ReportParam.builder().clazzDTO(ArrecadacaoPorTributoValoresDTO.class).fields(fields).sumFields(sumFields).maxRecord((int)tributoValoresDTOSPage.getTotalElements()).page(tributoValoresDTOSPage).reportTitle("Consulta Resumo de Arrecada\u00e7\u00e3o por Tributo").searchFilter(filtro.getSearch()).build();
        return this.baseExport.toHTML(reportParam);
    }

    @PostMapping(value={"/consulta"})
    public ResponseEntity<ArrecadacaoPorTributoResumoDTO> findArrecadacaoPorTributos(@RequestBody @Valid FiltroArrecadacaoPorTributoDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.arrecadacaoPorTributoService.getArrecadacaoPorTributo(filtro, pageable));
    }
}

