/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.repository.IntegracaoItbiRepository;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao/itbi"})
public class IntegracaoItbiResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegracaoItbiResource.class);
    private final IntegracaoItbiRepository repository;

    public IntegracaoItbiResource(IntegracaoItbiRepository repository) {
        this.repository = repository;
    }

    @GetMapping(value={"/enderecos"})
    public ResponseEntity<Map<String, Object>> getPackageEndereco(@RequestParam(value="getTodos", defaultValue="false") Boolean getTodos) {
        LOGGER.debug("Consulta de integra\u00e7\u00e3o do ITBI - buscando enderecos");
        List cidades = this.repository.findAllCidade(getTodos);
        LOGGER.debug("Foram encontradas {} cidades", (Object)cidades.size());
        List bairros = this.repository.findAllBairro(getTodos);
        LOGGER.debug("Foram encontrados {} bairros", (Object)bairros.size());
        List tipoLogradouro = this.repository.findAllTipoLogradouro();
        LOGGER.debug("Foram encontrados {} tipoLogradouro", (Object)tipoLogradouro.size());
        List logradouros = this.repository.findAllLogradouro(getTodos);
        LOGGER.debug("Foram encontrados {} logradouros", (Object)logradouros.size());
        TreeMap<String, List> result = new TreeMap<String, List>();
        result.put("cidades", cidades);
        result.put("bairros", bairros);
        result.put("tiposlogradouro", tipoLogradouro);
        result.put("logradouros", logradouros);
        return ResponseEntity.ok(result);
    }

    @GetMapping
    public ResponseEntity<Map<String, List<Map<String, Object>>>> getPackage(@RequestParam(value="since") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) Optional<LocalDate> since, @RequestParam(value="incluiCadastroRural") Optional<Boolean> incluiCadastroRural) {
        LOGGER.info("Consulta de integra\u00e7\u00e3o do ITBI - buscando altera\u00e7\u00f5es desde {}", since);
        List cadastros = this.repository.findAllCadastros(TipoCadastro.IMOBILIARIO, since);
        LOGGER.debug("Foram encontrados {} cadastroimobiliario", (Object)cadastros.size());
        List proprietarios = this.repository.findAllProprietariosPorTipoCadastro(since, TipoCadastro.IMOBILIARIO);
        LOGGER.debug("Foram encontrados {} proprietarios", (Object)proprietarios.size());
        Map<Object, List<Map>> groupedByCadastro = proprietarios.stream().collect(Collectors.groupingBy(item -> item.get("idCadastro")));
        cadastros.forEach(cadastro -> cadastro.put("proprietarios", groupedByCadastro.get(cadastro.get("id"))));
        TreeMap<String, List> result = new TreeMap<String, List>();
        result.put("tipoitbi", this.repository.findAllTipoItbi());
        LOGGER.debug("Foram encontrados {} tipoitbi", (Object)((List)result.get("tipoitbi")).size());
        result.put("tiposegmento", this.repository.findAllTipoSegmento());
        LOGGER.debug("Foram encontrados {} tiposegmento", (Object)((List)result.get("tiposegmento")).size());
        result.put("tipovinculo", this.repository.findAllTipoVinculo());
        LOGGER.debug("Foram encontrados {} tipovinculo", (Object)((List)result.get("tipovinculo")).size());
        result.put("cadastroimobiliario", cadastros);
        result.put("parametroitbi", this.repository.findAllParametrosItbi());
        LOGGER.debug("Foram encontrados {} parametroitbi", (Object)((List)result.get("parametroitbi")).size());
        if (incluiCadastroRural.orElse(Boolean.FALSE).booleanValue()) {
            List cadastrosRurais = this.repository.findAllCadastros(TipoCadastro.RURAL, since);
            result.put("cadastroRural", cadastrosRurais);
            LOGGER.debug("Foram encontrados {} cadastros rurais", (Object)((List)result.get("cadastroRural")).size());
            List proprietariosRural = this.repository.findAllProprietariosPorTipoCadastro(since, TipoCadastro.RURAL);
            LOGGER.debug("Foram encontrados {} proprietarios de cadastro rurais", (Object)proprietariosRural.size());
            Map<Object, List<Map>> groupedByCadastroRural = proprietariosRural.stream().collect(Collectors.groupingBy(item -> item.get("idCadastro")));
            cadastrosRurais.forEach(cadastroRural -> cadastroRural.put("proprietarios", groupedByCadastroRural.get(cadastroRural.get("id"))));
        }
        LOGGER.info("Consulta de integra\u00e7\u00e3o do ITBI - finalizada requisi\u00e7\u00e3o de busca de altera\u00e7\u00f5es do tributos.");
        return ResponseEntity.ok(result);
    }
}

