/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/alvara-taxi"})
public class AlvaraTaxiResource {
    private final AisePdfService aisePdfService;
    private final DocumentoService documentoService;

    public AlvaraTaxiResource(AisePdfService aisePdfService, DocumentoService documentoService) {
        this.aisePdfService = aisePdfService;
        this.documentoService = documentoService;
    }

    @PostMapping(value={"/valores-iniciais"})
    public ResponseEntity<DocumentoGenericoDTO> getInitialValues(@RequestBody DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ResponseEntity.ok((Object)this.documentoService.getInitialValues(documentoSearchInitialValuesDTO, TipoDocumentoEnum.ALVARA_TAXI));
    }

    @PostMapping
    public ResponseEntity<ImpressaoDTO> gerar(@RequestBody @Valid DocumentoGenericoDTO documentoGenericoDTO) {
        DocumentoDTO dto = this.documentoService.gerar(documentoGenericoDTO, TipoDocumentoEnum.ALVARA_TAXI);
        dto.setUrl(this.aisePdfService.fetchDocumento(dto.getDocumento(), dto.getTipoDocumento(), dto.getExercicio()));
        return ResponseEntity.ok((Object)ImpressaoDTO.from((Long)dto.getId(), (String)dto.getUrl()));
    }
}

