/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.tributos.domain.RolDividaTributoDTO;
import java.util.List;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RolRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public RolRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<RolDividaTributoDTO> findRolDividaTributo(@Param(value="idRol") Long idRol) {
        String sql = "SELECT C.ENTIDADE, A.IDROL, A.IDDEBITO, C.EXERCICIO, C.GUIARECOLHIMENTO, A.PARCELA, A.IDDEBITOPARCELARECEITA, A.RECEITA, A.VALOR, A.VALORJUROS,   A.VALORMULTA, A.VALORCORRECAO, A.VALORATUALIZADO, B.DATALANCAMENTO, B.DATAVENCIMENTO, B.SITUACAOLEGAL, C.FORMACORRECAO,   C.PARCELADO, C.REPARCELADO FROM TRIBROLDEBITOPARCELARECEITA A JOIN TRIBROLDEBITOPARCELA B ON A.IDROL = B.IDROL AND A.IDDEBITO = B.IDDEBITO AND A.PARCELA = B.PARCELA JOIN TRIBROLDEBITO C ON B.IDROL = C.IDROL AND B.IDDEBITO = C.IDDEBITO WHERE A.IDROL = :idRol ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idRol", (Object)idRol);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (rs, rowNum) -> {
            RolDividaTributoDTO dto = new RolDividaTributoDTO();
            dto.setEntidade(Long.valueOf(rs.getLong("entidade")));
            dto.setIdRol(Long.valueOf(rs.getLong("idrol")));
            dto.setIdDebito(Long.valueOf(rs.getLong("iddebito")));
            dto.setExercicio(Long.valueOf(rs.getLong("exercicio")));
            dto.setDivida(Long.valueOf(rs.getLong("guiarecolhimento")));
            dto.setParcela(Long.valueOf(rs.getLong("parcela")));
            dto.setSituacaoLegal(Long.valueOf(rs.getLong("situacaolegal")));
            dto.setParcelado(Boolean.valueOf("S".equals(rs.getString("parcelado")) || "S".equals(rs.getString("reparcelado"))));
            dto.setIdDebitoParcelaReceita(Long.valueOf(rs.getLong("iddebitoparcelareceita")));
            dto.setTributo(rs.getString("receita"));
            dto.setValor(rs.getBigDecimal("valor"));
            dto.setValorJuros(rs.getBigDecimal("valorjuros"));
            dto.setValorMulta(rs.getBigDecimal("valormulta"));
            dto.setValorCorrecao(rs.getBigDecimal("valorcorrecao"));
            dto.setValorAtualizado(rs.getBigDecimal("valoratualizado"));
            dto.setDataLancamento(rs.getDate("datalancamento").toLocalDate());
            dto.setDataVencimento(rs.getDate("datavencimento").toLocalDate());
            dto.setFormaCorrecao(Long.valueOf(rs.getLong("formacorrecao")));
            return dto;
        });
    }
}

