/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelaReceitaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jsonwebtoken.lang.Assert;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class AiseDebitoParcelamentoDTO {
    private Integer entidade;
    private Integer exercicio;
    @JsonProperty(value="tipocadastro")
    private TipoCadastro tipoCadastro;
    @JsonProperty(value="cadastrogeral")
    private Long cadastroGeral;
    @JsonProperty(value="guiarecolhimento")
    private Integer guiaRecolhimento;
    @JsonProperty(value="guiarecolhimento_descr")
    private String descricaoGuiaRecolhimento;
    @JsonProperty(value="subdivida")
    private Integer subDivida;
    @JsonProperty(value="iddebito")
    private Long idDebito;
    @JsonProperty(value="valordebito")
    private BigDecimal valorDebito;
    @JsonProperty(value="numerocontrato")
    private Long numeroContrato;
    @JsonProperty(value="anocontrato")
    private Integer anoContrato;
    @JsonProperty(value="noprocessocomumunica")
    private String noProcessoComumUnica;
    @JsonProperty(value="valordescontoprincipal")
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    @JsonProperty(value="valordescontojuros")
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    @JsonProperty(value="valordescontomulta")
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    @JsonProperty(value="valordescontocorrecao")
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    @JsonProperty(value="descontoparcelamento")
    private BigDecimal valorDescontoParcelamento = BigDecimal.ZERO;
    @JsonProperty(value="descontojurosparcelamento")
    private BigDecimal valorDescontoJurosParcelamento = BigDecimal.ZERO;
    @JsonProperty(value="descontomultaparcelamento")
    private BigDecimal valorDescontoMultaParcelamento = BigDecimal.ZERO;
    @JsonProperty(value="descontojurosfinanparcelamento")
    private BigDecimal valorDescontoJurosFinanciamentoParcelamento = BigDecimal.ZERO;
    @JsonProperty(value="valorbasecalculo")
    private BigDecimal valorBaseCalculo = BigDecimal.ZERO;
    @JsonProperty(value="parcelareceita")
    private List<AiseParcelaReceitaParcelamentoDTO> parcelaReceita = new ArrayList();
    @JsonProperty(value="tipoguiarecolhimento")
    private TipoDivida tipoDivida;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorAcrescimos = BigDecimal.ZERO;
    private BigDecimal valorAvista = BigDecimal.ZERO;
    private Boolean concedeDescontoNoPagamento = Boolean.FALSE;

    @JsonProperty(value="dataVencimento")
    public LocalDate getDataVencimento() {
        Optional primeiraParcela = this.parcelaReceita.stream().findFirst();
        return primeiraParcela.map(AiseParcelaReceitaParcelamentoDTO::getDataVencimento).orElse(null);
    }

    @JsonProperty(value="situacaoLegal")
    public String getSituacaoLegal() {
        Optional primeiraParcela = this.parcelaReceita.stream().findFirst();
        return primeiraParcela.map(AiseParcelaReceitaParcelamentoDTO::getSituacaoLegal).map(SituacaoLegal::fromValue).map(SituacaoLegal::getDescricao).orElse("");
    }

    @JsonProperty(value="idSituacaoLegal")
    public Integer getIdSituacaoLegal() {
        return this.parcelaReceita.stream().findFirst().map(AiseParcelaReceitaParcelamentoDTO::getSituacaoLegal).orElse(null);
    }

    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = Long.valueOf(0L).equals(numeroContrato) ? null : numeroContrato;
    }

    public void setAnoContrato(Integer anoContrato) {
        this.anoContrato = Integer.valueOf(0).equals(anoContrato) ? null : anoContrato;
    }

    public ParcelamentoDebitoDTO toParcelamentoDebitoDTO() {
        Assert.notNull((Object)this.getIdDebito(), (String)"Erro ao fazer convers\u00e3o de dados: Id do D\u00e9bito est\u00e1 nulo.");
        Assert.notNull((Object)this.getEntidade(), (String)"Erro ao fazer convers\u00e3o de dados: Entidade est\u00e1 nulo.");
        Assert.notNull((Object)this.getExercicio(), (String)"Erro ao fazer convers\u00e3o de dados: Exerc\u00edcio est\u00e1 nulo.");
        Assert.notNull((Object)this.getTipoCadastro(), (String)"Erro ao fazer convers\u00e3o de dados: Tipo Cadastro est\u00e1 nulo.");
        Assert.notNull((Object)this.getCadastroGeral(), (String)"Erro ao fazer convers\u00e3o de dados: Cadastro Geral est\u00e1 nulo.");
        Assert.notNull((Object)this.getGuiaRecolhimento(), (String)"Erro ao fazer convers\u00e3o de dados: D\u00edvida est\u00e1 nulo.");
        Assert.notNull((Object)this.getSubDivida(), (String)"Erro ao fazer convers\u00e3o de dados: Subdivida est\u00e1 nulo.");
        ParcelamentoDebitoDTO dto = new ParcelamentoDebitoDTO();
        dto.setIdDebito(this.getIdDebito());
        dto.setEntidade(Long.valueOf(this.getEntidade().longValue()));
        dto.setExercicio(Long.valueOf(this.getExercicio().longValue()));
        dto.setTipoCadastro(this.getTipoCadastro().getValue());
        dto.setCadastroGeral(this.getCadastroGeral());
        dto.setGuiaRecolhimento(Long.valueOf(this.getGuiaRecolhimento().longValue()));
        dto.setSubDivida(Long.valueOf(this.getSubDivida().longValue()));
        dto.setValor(this.getValorPrincipal());
        dto.setValorJuros(this.getValorJuros());
        dto.setValorMulta(this.getValorMulta());
        dto.setValorCorrecao(this.getValorCorrecao());
        dto.setValorAVista(this.getValorAvista());
        dto.setValorDescontoParcelamento(this.getValorDescontoParcelamento());
        dto.setValorDescontoJurosParcelamento(this.getValorDescontoJurosParcelamento());
        dto.setValorDescontoMultaParcelamento(this.getValorDescontoMultaParcelamento());
        dto.setValorDescontoJurosFinanciamentoParcelamento(this.getValorDescontoJurosFinanciamentoParcelamento());
        return dto;
    }

    public String getTipoDividaDescricao() {
        return Optional.ofNullable(this.tipoDivida).map(TipoDivida::getDescricao).orElse(null);
    }

    public void agruparValores() {
        for (AiseParcelaReceitaParcelamentoDTO parcelaReceita : this.parcelaReceita) {
            this.valorPrincipal = this.valorPrincipal.add(parcelaReceita.getValor());
            this.valorJuros = this.valorJuros.add(parcelaReceita.getValorJuros());
            this.valorMulta = this.valorMulta.add(parcelaReceita.getValorMulta());
            this.valorCorrecao = this.valorCorrecao.add(parcelaReceita.getValorCorrecao());
            this.valorAcrescimos = this.valorAcrescimos.add(parcelaReceita.getValorAcrescimos());
            this.valorAvista = this.valorAvista.add(parcelaReceita.getValorAVista());
        }
    }

    public BigDecimal getValorDesconto() {
        return this.valorDescontoPrincipal.add(this.valorDescontoJuros).add(this.valorDescontoMulta).add(this.valorDescontoCorrecao);
    }

    @Generated
    public AiseDebitoParcelamentoDTO() {
    }

    @Generated
    public Integer getEntidade() {
        return this.entidade;
    }

    @Generated
    public Integer getExercicio() {
        return this.exercicio;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Integer getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public String getDescricaoGuiaRecolhimento() {
        return this.descricaoGuiaRecolhimento;
    }

    @Generated
    public Integer getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public BigDecimal getValorDebito() {
        return this.valorDebito;
    }

    @Generated
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public Integer getAnoContrato() {
        return this.anoContrato;
    }

    @Generated
    public String getNoProcessoComumUnica() {
        return this.noProcessoComumUnica;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public BigDecimal getValorDescontoParcelamento() {
        return this.valorDescontoParcelamento;
    }

    @Generated
    public BigDecimal getValorDescontoJurosParcelamento() {
        return this.valorDescontoJurosParcelamento;
    }

    @Generated
    public BigDecimal getValorDescontoMultaParcelamento() {
        return this.valorDescontoMultaParcelamento;
    }

    @Generated
    public BigDecimal getValorDescontoJurosFinanciamentoParcelamento() {
        return this.valorDescontoJurosFinanciamentoParcelamento;
    }

    @Generated
    public BigDecimal getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    @Generated
    public List<AiseParcelaReceitaParcelamentoDTO> getParcelaReceita() {
        return this.parcelaReceita;
    }

    @Generated
    public TipoDivida getTipoDivida() {
        return this.tipoDivida;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorAcrescimos() {
        return this.valorAcrescimos;
    }

    @Generated
    public BigDecimal getValorAvista() {
        return this.valorAvista;
    }

    @Generated
    public Boolean getConcedeDescontoNoPagamento() {
        return this.concedeDescontoNoPagamento;
    }

    @Generated
    public void setEntidade(Integer entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Integer exercicio) {
        this.exercicio = exercicio;
    }

    @JsonProperty(value="tipocadastro")
    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @JsonProperty(value="cadastrogeral")
    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @JsonProperty(value="guiarecolhimento")
    @Generated
    public void setGuiaRecolhimento(Integer guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @JsonProperty(value="guiarecolhimento_descr")
    @Generated
    public void setDescricaoGuiaRecolhimento(String descricaoGuiaRecolhimento) {
        this.descricaoGuiaRecolhimento = descricaoGuiaRecolhimento;
    }

    @JsonProperty(value="subdivida")
    @Generated
    public void setSubDivida(Integer subDivida) {
        this.subDivida = subDivida;
    }

    @JsonProperty(value="iddebito")
    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @JsonProperty(value="valordebito")
    @Generated
    public void setValorDebito(BigDecimal valorDebito) {
        this.valorDebito = valorDebito;
    }

    @JsonProperty(value="noprocessocomumunica")
    @Generated
    public void setNoProcessoComumUnica(String noProcessoComumUnica) {
        this.noProcessoComumUnica = noProcessoComumUnica;
    }

    @JsonProperty(value="valordescontoprincipal")
    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @JsonProperty(value="valordescontojuros")
    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @JsonProperty(value="valordescontomulta")
    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @JsonProperty(value="valordescontocorrecao")
    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @JsonProperty(value="descontoparcelamento")
    @Generated
    public void setValorDescontoParcelamento(BigDecimal valorDescontoParcelamento) {
        this.valorDescontoParcelamento = valorDescontoParcelamento;
    }

    @JsonProperty(value="descontojurosparcelamento")
    @Generated
    public void setValorDescontoJurosParcelamento(BigDecimal valorDescontoJurosParcelamento) {
        this.valorDescontoJurosParcelamento = valorDescontoJurosParcelamento;
    }

    @JsonProperty(value="descontomultaparcelamento")
    @Generated
    public void setValorDescontoMultaParcelamento(BigDecimal valorDescontoMultaParcelamento) {
        this.valorDescontoMultaParcelamento = valorDescontoMultaParcelamento;
    }

    @JsonProperty(value="descontojurosfinanparcelamento")
    @Generated
    public void setValorDescontoJurosFinanciamentoParcelamento(BigDecimal valorDescontoJurosFinanciamentoParcelamento) {
        this.valorDescontoJurosFinanciamentoParcelamento = valorDescontoJurosFinanciamentoParcelamento;
    }

    @JsonProperty(value="valorbasecalculo")
    @Generated
    public void setValorBaseCalculo(BigDecimal valorBaseCalculo) {
        this.valorBaseCalculo = valorBaseCalculo;
    }

    @JsonProperty(value="parcelareceita")
    @Generated
    public void setParcelaReceita(List<AiseParcelaReceitaParcelamentoDTO> parcelaReceita) {
        this.parcelaReceita = parcelaReceita;
    }

    @JsonProperty(value="tipoguiarecolhimento")
    @Generated
    public void setTipoDivida(TipoDivida tipoDivida) {
        this.tipoDivida = tipoDivida;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorAcrescimos(BigDecimal valorAcrescimos) {
        this.valorAcrescimos = valorAcrescimos;
    }

    @Generated
    public void setValorAvista(BigDecimal valorAvista) {
        this.valorAvista = valorAvista;
    }

    @Generated
    public void setConcedeDescontoNoPagamento(Boolean concedeDescontoNoPagamento) {
        this.concedeDescontoNoPagamento = concedeDescontoNoPagamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiseDebitoParcelamentoDTO)) {
            return false;
        }
        AiseDebitoParcelamentoDTO other = (AiseDebitoParcelamentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$entidade = this.getEntidade();
        Integer other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Integer this$exercicio = this.getExercicio();
        Integer other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Integer this$guiaRecolhimento = this.getGuiaRecolhimento();
        Integer other$guiaRecolhimento = other.getGuiaRecolhimento();
        if (this$guiaRecolhimento == null ? other$guiaRecolhimento != null : !((Object)this$guiaRecolhimento).equals(other$guiaRecolhimento)) {
            return false;
        }
        Integer this$subDivida = this.getSubDivida();
        Integer other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        Integer this$anoContrato = this.getAnoContrato();
        Integer other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !((Object)this$anoContrato).equals(other$anoContrato)) {
            return false;
        }
        Boolean this$concedeDescontoNoPagamento = this.getConcedeDescontoNoPagamento();
        Boolean other$concedeDescontoNoPagamento = other.getConcedeDescontoNoPagamento();
        if (this$concedeDescontoNoPagamento == null ? other$concedeDescontoNoPagamento != null : !((Object)this$concedeDescontoNoPagamento).equals(other$concedeDescontoNoPagamento)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$descricaoGuiaRecolhimento = this.getDescricaoGuiaRecolhimento();
        String other$descricaoGuiaRecolhimento = other.getDescricaoGuiaRecolhimento();
        if (this$descricaoGuiaRecolhimento == null ? other$descricaoGuiaRecolhimento != null : !this$descricaoGuiaRecolhimento.equals(other$descricaoGuiaRecolhimento)) {
            return false;
        }
        BigDecimal this$valorDebito = this.getValorDebito();
        BigDecimal other$valorDebito = other.getValorDebito();
        if (this$valorDebito == null ? other$valorDebito != null : !((Object)this$valorDebito).equals(other$valorDebito)) {
            return false;
        }
        String this$noProcessoComumUnica = this.getNoProcessoComumUnica();
        String other$noProcessoComumUnica = other.getNoProcessoComumUnica();
        if (this$noProcessoComumUnica == null ? other$noProcessoComumUnica != null : !this$noProcessoComumUnica.equals(other$noProcessoComumUnica)) {
            return false;
        }
        BigDecimal this$valorDescontoPrincipal = this.getValorDescontoPrincipal();
        BigDecimal other$valorDescontoPrincipal = other.getValorDescontoPrincipal();
        if (this$valorDescontoPrincipal == null ? other$valorDescontoPrincipal != null : !((Object)this$valorDescontoPrincipal).equals(other$valorDescontoPrincipal)) {
            return false;
        }
        BigDecimal this$valorDescontoJuros = this.getValorDescontoJuros();
        BigDecimal other$valorDescontoJuros = other.getValorDescontoJuros();
        if (this$valorDescontoJuros == null ? other$valorDescontoJuros != null : !((Object)this$valorDescontoJuros).equals(other$valorDescontoJuros)) {
            return false;
        }
        BigDecimal this$valorDescontoMulta = this.getValorDescontoMulta();
        BigDecimal other$valorDescontoMulta = other.getValorDescontoMulta();
        if (this$valorDescontoMulta == null ? other$valorDescontoMulta != null : !((Object)this$valorDescontoMulta).equals(other$valorDescontoMulta)) {
            return false;
        }
        BigDecimal this$valorDescontoCorrecao = this.getValorDescontoCorrecao();
        BigDecimal other$valorDescontoCorrecao = other.getValorDescontoCorrecao();
        if (this$valorDescontoCorrecao == null ? other$valorDescontoCorrecao != null : !((Object)this$valorDescontoCorrecao).equals(other$valorDescontoCorrecao)) {
            return false;
        }
        BigDecimal this$valorDescontoParcelamento = this.getValorDescontoParcelamento();
        BigDecimal other$valorDescontoParcelamento = other.getValorDescontoParcelamento();
        if (this$valorDescontoParcelamento == null ? other$valorDescontoParcelamento != null : !((Object)this$valorDescontoParcelamento).equals(other$valorDescontoParcelamento)) {
            return false;
        }
        BigDecimal this$valorDescontoJurosParcelamento = this.getValorDescontoJurosParcelamento();
        BigDecimal other$valorDescontoJurosParcelamento = other.getValorDescontoJurosParcelamento();
        if (this$valorDescontoJurosParcelamento == null ? other$valorDescontoJurosParcelamento != null : !((Object)this$valorDescontoJurosParcelamento).equals(other$valorDescontoJurosParcelamento)) {
            return false;
        }
        BigDecimal this$valorDescontoMultaParcelamento = this.getValorDescontoMultaParcelamento();
        BigDecimal other$valorDescontoMultaParcelamento = other.getValorDescontoMultaParcelamento();
        if (this$valorDescontoMultaParcelamento == null ? other$valorDescontoMultaParcelamento != null : !((Object)this$valorDescontoMultaParcelamento).equals(other$valorDescontoMultaParcelamento)) {
            return false;
        }
        BigDecimal this$valorDescontoJurosFinanciamentoParcelamento = this.getValorDescontoJurosFinanciamentoParcelamento();
        BigDecimal other$valorDescontoJurosFinanciamentoParcelamento = other.getValorDescontoJurosFinanciamentoParcelamento();
        if (this$valorDescontoJurosFinanciamentoParcelamento == null ? other$valorDescontoJurosFinanciamentoParcelamento != null : !((Object)this$valorDescontoJurosFinanciamentoParcelamento).equals(other$valorDescontoJurosFinanciamentoParcelamento)) {
            return false;
        }
        BigDecimal this$valorBaseCalculo = this.getValorBaseCalculo();
        BigDecimal other$valorBaseCalculo = other.getValorBaseCalculo();
        if (this$valorBaseCalculo == null ? other$valorBaseCalculo != null : !((Object)this$valorBaseCalculo).equals(other$valorBaseCalculo)) {
            return false;
        }
        List this$parcelaReceita = this.getParcelaReceita();
        List other$parcelaReceita = other.getParcelaReceita();
        if (this$parcelaReceita == null ? other$parcelaReceita != null : !((Object)this$parcelaReceita).equals(other$parcelaReceita)) {
            return false;
        }
        TipoDivida this$tipoDivida = this.getTipoDivida();
        TipoDivida other$tipoDivida = other.getTipoDivida();
        if (this$tipoDivida == null ? other$tipoDivida != null : !this$tipoDivida.equals(other$tipoDivida)) {
            return false;
        }
        BigDecimal this$valorPrincipal = this.getValorPrincipal();
        BigDecimal other$valorPrincipal = other.getValorPrincipal();
        if (this$valorPrincipal == null ? other$valorPrincipal != null : !((Object)this$valorPrincipal).equals(other$valorPrincipal)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorAcrescimos = this.getValorAcrescimos();
        BigDecimal other$valorAcrescimos = other.getValorAcrescimos();
        if (this$valorAcrescimos == null ? other$valorAcrescimos != null : !((Object)this$valorAcrescimos).equals(other$valorAcrescimos)) {
            return false;
        }
        BigDecimal this$valorAvista = this.getValorAvista();
        BigDecimal other$valorAvista = other.getValorAvista();
        return !(this$valorAvista == null ? other$valorAvista != null : !((Object)this$valorAvista).equals(other$valorAvista));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AiseDebitoParcelamentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Integer $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Integer $guiaRecolhimento = this.getGuiaRecolhimento();
        result = result * 59 + ($guiaRecolhimento == null ? 43 : ((Object)$guiaRecolhimento).hashCode());
        Integer $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        Integer $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : ((Object)$anoContrato).hashCode());
        Boolean $concedeDescontoNoPagamento = this.getConcedeDescontoNoPagamento();
        result = result * 59 + ($concedeDescontoNoPagamento == null ? 43 : ((Object)$concedeDescontoNoPagamento).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $descricaoGuiaRecolhimento = this.getDescricaoGuiaRecolhimento();
        result = result * 59 + ($descricaoGuiaRecolhimento == null ? 43 : $descricaoGuiaRecolhimento.hashCode());
        BigDecimal $valorDebito = this.getValorDebito();
        result = result * 59 + ($valorDebito == null ? 43 : ((Object)$valorDebito).hashCode());
        String $noProcessoComumUnica = this.getNoProcessoComumUnica();
        result = result * 59 + ($noProcessoComumUnica == null ? 43 : $noProcessoComumUnica.hashCode());
        BigDecimal $valorDescontoPrincipal = this.getValorDescontoPrincipal();
        result = result * 59 + ($valorDescontoPrincipal == null ? 43 : ((Object)$valorDescontoPrincipal).hashCode());
        BigDecimal $valorDescontoJuros = this.getValorDescontoJuros();
        result = result * 59 + ($valorDescontoJuros == null ? 43 : ((Object)$valorDescontoJuros).hashCode());
        BigDecimal $valorDescontoMulta = this.getValorDescontoMulta();
        result = result * 59 + ($valorDescontoMulta == null ? 43 : ((Object)$valorDescontoMulta).hashCode());
        BigDecimal $valorDescontoCorrecao = this.getValorDescontoCorrecao();
        result = result * 59 + ($valorDescontoCorrecao == null ? 43 : ((Object)$valorDescontoCorrecao).hashCode());
        BigDecimal $valorDescontoParcelamento = this.getValorDescontoParcelamento();
        result = result * 59 + ($valorDescontoParcelamento == null ? 43 : ((Object)$valorDescontoParcelamento).hashCode());
        BigDecimal $valorDescontoJurosParcelamento = this.getValorDescontoJurosParcelamento();
        result = result * 59 + ($valorDescontoJurosParcelamento == null ? 43 : ((Object)$valorDescontoJurosParcelamento).hashCode());
        BigDecimal $valorDescontoMultaParcelamento = this.getValorDescontoMultaParcelamento();
        result = result * 59 + ($valorDescontoMultaParcelamento == null ? 43 : ((Object)$valorDescontoMultaParcelamento).hashCode());
        BigDecimal $valorDescontoJurosFinanciamentoParcelamento = this.getValorDescontoJurosFinanciamentoParcelamento();
        result = result * 59 + ($valorDescontoJurosFinanciamentoParcelamento == null ? 43 : ((Object)$valorDescontoJurosFinanciamentoParcelamento).hashCode());
        BigDecimal $valorBaseCalculo = this.getValorBaseCalculo();
        result = result * 59 + ($valorBaseCalculo == null ? 43 : ((Object)$valorBaseCalculo).hashCode());
        List $parcelaReceita = this.getParcelaReceita();
        result = result * 59 + ($parcelaReceita == null ? 43 : ((Object)$parcelaReceita).hashCode());
        TipoDivida $tipoDivida = this.getTipoDivida();
        result = result * 59 + ($tipoDivida == null ? 43 : $tipoDivida.hashCode());
        BigDecimal $valorPrincipal = this.getValorPrincipal();
        result = result * 59 + ($valorPrincipal == null ? 43 : ((Object)$valorPrincipal).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorAcrescimos = this.getValorAcrescimos();
        result = result * 59 + ($valorAcrescimos == null ? 43 : ((Object)$valorAcrescimos).hashCode());
        BigDecimal $valorAvista = this.getValorAvista();
        result = result * 59 + ($valorAvista == null ? 43 : ((Object)$valorAvista).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AiseDebitoParcelamentoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", descricaoGuiaRecolhimento=" + this.getDescricaoGuiaRecolhimento() + ", subDivida=" + this.getSubDivida() + ", idDebito=" + this.getIdDebito() + ", valorDebito=" + this.getValorDebito() + ", numeroContrato=" + this.getNumeroContrato() + ", anoContrato=" + this.getAnoContrato() + ", noProcessoComumUnica=" + this.getNoProcessoComumUnica() + ", valorDescontoPrincipal=" + this.getValorDescontoPrincipal() + ", valorDescontoJuros=" + this.getValorDescontoJuros() + ", valorDescontoMulta=" + this.getValorDescontoMulta() + ", valorDescontoCorrecao=" + this.getValorDescontoCorrecao() + ", valorDescontoParcelamento=" + this.getValorDescontoParcelamento() + ", valorDescontoJurosParcelamento=" + this.getValorDescontoJurosParcelamento() + ", valorDescontoMultaParcelamento=" + this.getValorDescontoMultaParcelamento() + ", valorDescontoJurosFinanciamentoParcelamento=" + this.getValorDescontoJurosFinanciamentoParcelamento() + ", valorBaseCalculo=" + this.getValorBaseCalculo() + ", parcelaReceita=" + this.getParcelaReceita() + ", tipoDivida=" + this.getTipoDivida() + ", valorPrincipal=" + this.getValorPrincipal() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorAcrescimos=" + this.getValorAcrescimos() + ", valorAvista=" + this.getValorAvista() + ", concedeDescontoNoPagamento=" + this.getConcedeDescontoNoPagamento() + ")";
    }
}

