/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class RastreamentoProprietarioDTO {
    private String nome;
    private Long pessoa;
    private String tipoPessoa;
    private String cpfCnpj;
    private String vinculoDescricao;
    private Boolean principal;
    @JsonIgnore
    private List<RastreamentoCadastroDTO> cadastrosVinculados;
    @JsonIgnore
    private Long idCadastro;
    @JsonIgnore
    private Long tipoCadastro;
    @JsonIgnore
    private Long cadastroGeral;
    @JsonIgnore
    private String situacao;
    @JsonIgnore
    private String tipoLogradouro;
    @JsonIgnore
    private String logradouro;
    @JsonIgnore
    private String numero;
    @JsonIgnore
    private String bairro;
    @JsonIgnore
    private String cidade;
    @JsonIgnore
    private String unidadeFederacao;

    public Boolean getCertidaoPositivaDebitos() {
        if (Objects.isNull(this.cadastrosVinculados) || this.cadastrosVinculados.isEmpty()) {
            return false;
        }
        return this.cadastrosVinculados.stream().anyMatch(RastreamentoCadastroDTO::certidaoPositivaDebitoCadastro);
    }

    @JsonProperty(value="cadastrosVinculados")
    public List<RastreamentoCadastroDTO> getSortedCadastrosVinculados() {
        if (Objects.nonNull(this.cadastrosVinculados)) {
            return this.cadastrosVinculados.stream().sorted(Comparator.comparing(RastreamentoCadastroDTO::getTipoCadastro).thenComparing(RastreamentoCadastroDTO::getCadastroGeral)).collect(Collectors.toList());
        }
        return new ArrayList<RastreamentoCadastroDTO>();
    }

    @Generated
    public RastreamentoProprietarioDTO() {
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public Long getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public String getVinculoDescricao() {
        return this.vinculoDescricao;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public List<RastreamentoCadastroDTO> getCadastrosVinculados() {
        return this.cadastrosVinculados;
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setTipoPessoa(String tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setVinculoDescricao(String vinculoDescricao) {
        this.vinculoDescricao = vinculoDescricao;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @JsonIgnore
    @Generated
    public void setCadastrosVinculados(List<RastreamentoCadastroDTO> cadastrosVinculados) {
        this.cadastrosVinculados = cadastrosVinculados;
    }

    @JsonIgnore
    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @JsonIgnore
    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @JsonIgnore
    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @JsonIgnore
    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @JsonIgnore
    @Generated
    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    @JsonIgnore
    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @JsonIgnore
    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @JsonIgnore
    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @JsonIgnore
    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @JsonIgnore
    @Generated
    public void setUnidadeFederacao(String unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    @Generated
    public String toString() {
        return "RastreamentoProprietarioDTO(nome=" + this.getNome() + ", pessoa=" + this.getPessoa() + ", tipoPessoa=" + this.getTipoPessoa() + ", cpfCnpj=" + this.getCpfCnpj() + ", vinculoDescricao=" + this.getVinculoDescricao() + ", principal=" + this.getPrincipal() + ", cadastrosVinculados=" + this.getCadastrosVinculados() + ", idCadastro=" + this.getIdCadastro() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", situacao=" + this.getSituacao() + ", tipoLogradouro=" + this.getTipoLogradouro() + ", logradouro=" + this.getLogradouro() + ", numero=" + this.getNumero() + ", bairro=" + this.getBairro() + ", cidade=" + this.getCidade() + ", unidadeFederacao=" + this.getUnidadeFederacao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RastreamentoProprietarioDTO)) {
            return false;
        }
        RastreamentoProprietarioDTO other = (RastreamentoProprietarioDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        return !(this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RastreamentoProprietarioDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        return result;
    }
}

