/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class RastreamentoDebitoDTO {
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long divida;
    private Long subDivida;
    private LocalDate dataVencimento;
    private Long idContencioso;
    private Boolean recursoAdministrativo = false;
    private BigDecimal valor = BigDecimal.ZERO;
    private Boolean parcelado = false;
    private Boolean reparcelado = false;

    public Boolean getVencido() {
        return Optional.ofNullable(this.dataVencimento).map(arg_0 -> this.isExpired(arg_0)).orElse(false);
    }

    public Boolean getAVencer() {
        return this.getVencido() == false;
    }

    private Boolean isExpired(LocalDate dataVencimento) {
        return LocalDate.now().isAfter(dataVencimento);
    }

    public Boolean existeParcelamento() {
        return this.parcelado != false || this.reparcelado != false;
    }

    @Generated
    public RastreamentoDebitoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public Long getIdContencioso() {
        return this.idContencioso;
    }

    @Generated
    public Boolean getRecursoAdministrativo() {
        return this.recursoAdministrativo;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public Boolean getReparcelado() {
        return this.reparcelado;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setIdContencioso(Long idContencioso) {
        this.idContencioso = idContencioso;
    }

    @Generated
    public void setRecursoAdministrativo(Boolean recursoAdministrativo) {
        this.recursoAdministrativo = recursoAdministrativo;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setReparcelado(Boolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RastreamentoDebitoDTO)) {
            return false;
        }
        RastreamentoDebitoDTO other = (RastreamentoDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$idContencioso = this.getIdContencioso();
        Long other$idContencioso = other.getIdContencioso();
        if (this$idContencioso == null ? other$idContencioso != null : !((Object)this$idContencioso).equals(other$idContencioso)) {
            return false;
        }
        Boolean this$recursoAdministrativo = this.getRecursoAdministrativo();
        Boolean other$recursoAdministrativo = other.getRecursoAdministrativo();
        if (this$recursoAdministrativo == null ? other$recursoAdministrativo != null : !((Object)this$recursoAdministrativo).equals(other$recursoAdministrativo)) {
            return false;
        }
        Boolean this$parcelado = this.getParcelado();
        Boolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !((Object)this$parcelado).equals(other$parcelado)) {
            return false;
        }
        Boolean this$reparcelado = this.getReparcelado();
        Boolean other$reparcelado = other.getReparcelado();
        if (this$reparcelado == null ? other$reparcelado != null : !((Object)this$reparcelado).equals(other$reparcelado)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        return !(this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RastreamentoDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $idContencioso = this.getIdContencioso();
        result = result * 59 + ($idContencioso == null ? 43 : ((Object)$idContencioso).hashCode());
        Boolean $recursoAdministrativo = this.getRecursoAdministrativo();
        result = result * 59 + ($recursoAdministrativo == null ? 43 : ((Object)$recursoAdministrativo).hashCode());
        Boolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : ((Object)$parcelado).hashCode());
        Boolean $reparcelado = this.getReparcelado();
        result = result * 59 + ($reparcelado == null ? 43 : ((Object)$reparcelado).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RastreamentoDebitoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", dataVencimento=" + this.getDataVencimento() + ", idContencioso=" + this.getIdContencioso() + ", recursoAdministrativo=" + this.getRecursoAdministrativo() + ", valor=" + this.getValor() + ", parcelado=" + this.getParcelado() + ", reparcelado=" + this.getReparcelado() + ")";
    }
}

