/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipo;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ArrecadacaoPorTipoFiltroDTO {
    @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data In\u00edcio.")
    private @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data In\u00edcio.") LocalDate dataInicio;
    @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data Fim.")
    private @NotNull(message="\u00c9 obrigat\u00f3rio o preenchimento da Data Fim.") LocalDate dataFim;
    private ArrecadacaoPorTipo tipo;
    private Long contaBancaria;
    private Long tipoCadastro;
    private String cadastroGeral;
    private String exercicioDebito;
    private String divida;
    private String subDivida;

    public String getSearch() {
        Object search = "dataInicio: " + this.dataInicio.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " dataFim: " + this.dataFim.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " contaBancaria: " + this.contaBancaria + " tipoCadastro: " + this.tipoCadastro + " cadastroGeral: " + this.cadastroGeral + " anoDebito: " + this.exercicioDebito + " divida: " + this.divida + " subDivida: " + this.subDivida;
        search = ((String)search).replace("null", "");
        return search;
    }

    private String addAND(String clausula) {
        return " and " + clausula;
    }

    private void validaDatas() {
        if (this.dataInicio.isAfter(this.dataFim)) {
            throw new EloValidationException("Intervalo de datas inv\u00e1lido, favor corrija para prosseguir.");
        }
    }

    public String buildFiltro() {
        this.validaDatas();
        StringBuilder filtro = new StringBuilder();
        filtro.append(String.format("WHERE x.dataMovimentacao between '%s' and '%s'", DateUtils.localDateToString((LocalDate)this.dataInicio), DateUtils.localDateToString((LocalDate)this.dataFim)));
        if (Objects.nonNull(this.contaBancaria)) {
            filtro.append(this.addAND(String.format("x.contaBancaria = %d", this.contaBancaria)));
        }
        if (Objects.nonNull(this.tipoCadastro)) {
            filtro.append(this.addAND(String.format("x.tipoCadastro = %d", this.tipoCadastro)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"x.cadastroGeral")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicioDebito, (String)"x.exercicioDebito")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"x.divida")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"x.subDivida")));
        }
        return filtro.toString();
    }

    @Generated
    public ArrecadacaoPorTipoFiltroDTO() {
    }

    @Generated
    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    @Generated
    public LocalDate getDataFim() {
        return this.dataFim;
    }

    @Generated
    public ArrecadacaoPorTipo getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Generated
    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }

    @Generated
    public void setTipo(ArrecadacaoPorTipo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setContaBancaria(Long contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrecadacaoPorTipoFiltroDTO)) {
            return false;
        }
        ArrecadacaoPorTipoFiltroDTO other = (ArrecadacaoPorTipoFiltroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$contaBancaria = this.getContaBancaria();
        Long other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !((Object)this$contaBancaria).equals(other$contaBancaria)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        LocalDate this$dataInicio = this.getDataInicio();
        LocalDate other$dataInicio = other.getDataInicio();
        if (this$dataInicio == null ? other$dataInicio != null : !((Object)this$dataInicio).equals(other$dataInicio)) {
            return false;
        }
        LocalDate this$dataFim = this.getDataFim();
        LocalDate other$dataFim = other.getDataFim();
        if (this$dataFim == null ? other$dataFim != null : !((Object)this$dataFim).equals(other$dataFim)) {
            return false;
        }
        ArrecadacaoPorTipo this$tipo = this.getTipo();
        ArrecadacaoPorTipo other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        return !(this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArrecadacaoPorTipoFiltroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : ((Object)$contaBancaria).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        LocalDate $dataInicio = this.getDataInicio();
        result = result * 59 + ($dataInicio == null ? 43 : ((Object)$dataInicio).hashCode());
        LocalDate $dataFim = this.getDataFim();
        result = result * 59 + ($dataFim == null ? 43 : ((Object)$dataFim).hashCode());
        ArrecadacaoPorTipo $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArrecadacaoPorTipoFiltroDTO(dataInicio=" + this.getDataInicio() + ", dataFim=" + this.getDataFim() + ", tipo=" + this.getTipo() + ", contaBancaria=" + this.getContaBancaria() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ")";
    }
}

