/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.tributos.domain.ProprietarioItbiId;
import br.com.elotech.tributos.domain.TipoProprietarioItbi;
import br.com.elotech.tributos.dto.itbi.ProprietarioItbiDTO;
import java.math.BigDecimal;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBPROPRIETARIOITBI")
public class ProprietarioItbi {
    @EmbeddedId
    private ProprietarioItbiId id;
    private Long vinculo;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean principal = Boolean.FALSE;
    private BigDecimal percentual = BigDecimal.ZERO;
    private BigDecimal percentualVenda = BigDecimal.ZERO;

    public static ProprietarioItbi from(ProprietarioItbiDTO dto) {
        ProprietarioItbi proprietarioItbi = new ProprietarioItbi();
        proprietarioItbi.setVinculo(dto.getVinculo());
        proprietarioItbi.setPrincipal(dto.getPrincipal());
        proprietarioItbi.setPercentual(dto.getPercentual());
        proprietarioItbi.setPercentualVenda(dto.getPercentualVenda());
        return proprietarioItbi;
    }

    public Boolean isAtual() {
        return TipoProprietarioItbi.ATUAL.equals((Object)this.id.getTipoProprietarioItbi());
    }

    @Generated
    public ProprietarioItbi() {
    }

    @Generated
    public ProprietarioItbiId getId() {
        return this.id;
    }

    @Generated
    public Long getVinculo() {
        return this.vinculo;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public BigDecimal getPercentual() {
        return this.percentual;
    }

    @Generated
    public BigDecimal getPercentualVenda() {
        return this.percentualVenda;
    }

    @Generated
    public void setId(ProprietarioItbiId id) {
        this.id = id;
    }

    @Generated
    public void setVinculo(Long vinculo) {
        this.vinculo = vinculo;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setPercentual(BigDecimal percentual) {
        this.percentual = percentual;
    }

    @Generated
    public void setPercentualVenda(BigDecimal percentualVenda) {
        this.percentualVenda = percentualVenda;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProprietarioItbi)) {
            return false;
        }
        ProprietarioItbi other = (ProprietarioItbi)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProprietarioItbiId this$id = this.getId();
        ProprietarioItbiId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProprietarioItbi;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProprietarioItbiId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProprietarioItbi(id=" + this.getId() + ", vinculo=" + this.getVinculo() + ", principal=" + this.getPrincipal() + ", percentual=" + this.getPercentual() + ", percentualVenda=" + this.getPercentualVenda() + ")";
    }
}

