/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.converter.SituacaoCnaeConverter;
import br.com.elotech.tributos.domain.AtividadeMEI;
import br.com.elotech.tributos.domain.CnaeAtividade;
import br.com.elotech.tributos.domain.CnaeSecao;
import br.com.elotech.tributos.domain.CnaeServico;
import br.com.elotech.tributos.domain.ConfiguracaoAtividade;
import br.com.elotech.tributos.enums.SituacaoCnae;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="CNAE")
public class Cnae
implements EloEntity<Long> {
    @Id
    @Caption(value="Cnae")
    @Column(name="CNAE")
    @EloSequence(sequenceName="s05Cnae")
    private Long id;
    @Column(length=250)
    @Caption(value="Descri\u00e7\u00e3o")
    private String descricao;
    @ManyToOne
    @JoinColumn(name="NATUREZAATIVIDADE", referencedColumnName="NATUREZAATIVIDADE")
    private CnaeAtividade cnaeAtividade;
    private LocalDate inicioValidade;
    @Column(length=20)
    @Caption(value="C\u00f3digo")
    private String codigo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="secao", referencedColumnName="secao")
    private CnaeSecao secao;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="MovSN")
    @Column(name="MovSN")
    private Boolean admiteMovimento = Boolean.TRUE;
    @Convert(converter=SituacaoCnaeConverter.class)
    private SituacaoCnae situacaoMEI;
    @Convert(converter=SituacaoCnaeConverter.class)
    private SituacaoCnae situacaoSNA;
    private Long classificacaoAtividade;
    @Column(length=1)
    @Caption(value="Grau Risco")
    private String grauRisco;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Permite Alvar\u00e1 sem Acessibilidade")
    private Boolean permiteAlvaraSemAcessibilidade = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Verificar \u00c1rea")
    private Boolean verificarArea = Boolean.FALSE;
    private BigDecimal valorBaseCalculo = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Inativo")
    private Boolean inativo = Boolean.FALSE;
    @ManyToOne
    @JoinColumn(name="IDCONFIGURACAOATIVIDADE", referencedColumnName="IDCONFIGURACAOATIVIDADE")
    private ConfiguracaoAtividade configuracaoAtividade;
    private Long idUnico;
    private Long permiteServico;
    private Long vedadaMicroEmpreendedor;
    private Long vedadaSimplesNacional;
    @OneToMany(mappedBy="cnae", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CnaeServico> cnaeServico = new ArrayList();
    @OneToMany(mappedBy="cnae", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AtividadeMEI> atividadeMEIS = new ArrayList();

    public Cnae(Long id, String descricao, String codigo) {
        this.id = id;
        this.descricao = descricao;
        this.codigo = codigo;
    }

    public Cnae() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public CnaeAtividade getCnaeAtividade() {
        return this.cnaeAtividade;
    }

    @Generated
    public LocalDate getInicioValidade() {
        return this.inicioValidade;
    }

    @Generated
    public String getCodigo() {
        return this.codigo;
    }

    @Generated
    public CnaeSecao getSecao() {
        return this.secao;
    }

    @Generated
    public Boolean getAdmiteMovimento() {
        return this.admiteMovimento;
    }

    @Generated
    public SituacaoCnae getSituacaoMEI() {
        return this.situacaoMEI;
    }

    @Generated
    public SituacaoCnae getSituacaoSNA() {
        return this.situacaoSNA;
    }

    @Generated
    public Long getClassificacaoAtividade() {
        return this.classificacaoAtividade;
    }

    @Generated
    public String getGrauRisco() {
        return this.grauRisco;
    }

    @Generated
    public Boolean getPermiteAlvaraSemAcessibilidade() {
        return this.permiteAlvaraSemAcessibilidade;
    }

    @Generated
    public Boolean getVerificarArea() {
        return this.verificarArea;
    }

    @Generated
    public BigDecimal getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    @Generated
    public Boolean getInativo() {
        return this.inativo;
    }

    @Generated
    public ConfiguracaoAtividade getConfiguracaoAtividade() {
        return this.configuracaoAtividade;
    }

    @Generated
    public Long getIdUnico() {
        return this.idUnico;
    }

    @Generated
    public Long getPermiteServico() {
        return this.permiteServico;
    }

    @Generated
    public Long getVedadaMicroEmpreendedor() {
        return this.vedadaMicroEmpreendedor;
    }

    @Generated
    public Long getVedadaSimplesNacional() {
        return this.vedadaSimplesNacional;
    }

    @Generated
    public List<CnaeServico> getCnaeServico() {
        return this.cnaeServico;
    }

    @Generated
    public List<AtividadeMEI> getAtividadeMEIS() {
        return this.atividadeMEIS;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCnaeAtividade(CnaeAtividade cnaeAtividade) {
        this.cnaeAtividade = cnaeAtividade;
    }

    @Generated
    public void setInicioValidade(LocalDate inicioValidade) {
        this.inicioValidade = inicioValidade;
    }

    @Generated
    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setSecao(CnaeSecao secao) {
        this.secao = secao;
    }

    @Generated
    public void setAdmiteMovimento(Boolean admiteMovimento) {
        this.admiteMovimento = admiteMovimento;
    }

    @Generated
    public void setSituacaoMEI(SituacaoCnae situacaoMEI) {
        this.situacaoMEI = situacaoMEI;
    }

    @Generated
    public void setSituacaoSNA(SituacaoCnae situacaoSNA) {
        this.situacaoSNA = situacaoSNA;
    }

    @Generated
    public void setClassificacaoAtividade(Long classificacaoAtividade) {
        this.classificacaoAtividade = classificacaoAtividade;
    }

    @Generated
    public void setGrauRisco(String grauRisco) {
        this.grauRisco = grauRisco;
    }

    @Generated
    public void setPermiteAlvaraSemAcessibilidade(Boolean permiteAlvaraSemAcessibilidade) {
        this.permiteAlvaraSemAcessibilidade = permiteAlvaraSemAcessibilidade;
    }

    @Generated
    public void setVerificarArea(Boolean verificarArea) {
        this.verificarArea = verificarArea;
    }

    @Generated
    public void setValorBaseCalculo(BigDecimal valorBaseCalculo) {
        this.valorBaseCalculo = valorBaseCalculo;
    }

    @Generated
    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    @Generated
    public void setConfiguracaoAtividade(ConfiguracaoAtividade configuracaoAtividade) {
        this.configuracaoAtividade = configuracaoAtividade;
    }

    @Generated
    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    @Generated
    public void setPermiteServico(Long permiteServico) {
        this.permiteServico = permiteServico;
    }

    @Generated
    public void setVedadaMicroEmpreendedor(Long vedadaMicroEmpreendedor) {
        this.vedadaMicroEmpreendedor = vedadaMicroEmpreendedor;
    }

    @Generated
    public void setVedadaSimplesNacional(Long vedadaSimplesNacional) {
        this.vedadaSimplesNacional = vedadaSimplesNacional;
    }

    @Generated
    public void setCnaeServico(List<CnaeServico> cnaeServico) {
        this.cnaeServico = cnaeServico;
    }

    @Generated
    public void setAtividadeMEIS(List<AtividadeMEI> atividadeMEIS) {
        this.atividadeMEIS = atividadeMEIS;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cnae)) {
            return false;
        }
        Cnae other = (Cnae)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cnae;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Cnae(id=" + this.getId() + ")";
    }
}

