/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.core.utils.ListUtils;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressao;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressaoItem;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.dto.AlteracaoVencimentoParcelaDTO;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoItemDTO;
import br.com.elotech.tributos.calculo.dto.LoteItemDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.repository.CalculoLoteImpressaoItemRepository;
import br.com.elotech.tributos.calculo.service.CalculoCadastroService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.Carne;
import br.com.elotech.tributos.domain.CarneBoleto;
import br.com.elotech.tributos.domain.CarneId;
import br.com.elotech.tributos.domain.DebitoCarne;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.enums.SituacaoGeracaoCarne;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistradoReceiver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CalculoLoteImpressaoItemService
extends ReadOnlyService<CalculoLoteImpressaoItem, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculoLoteImpressaoItemService.class);
    private final CalculoLoteImpressaoItemRepository calculoLoteImpressaoItemRepository;
    private final CarneService carneService;
    private final CalculoCadastroService calculoCadastroService;
    private final IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoCarneService debitoCarneService;
    private final EntityManager entityManager;

    public CalculoLoteImpressaoItemService(CalculoLoteImpressaoItemRepository calculoLoteImpressaoItemRepository, CarneService carneService, CalculoCadastroService calculoCadastroService, IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver, DebitoParcelaService debitoParcelaService, DebitoCarneService debitoCarneService, EntityManager entityManager) {
        this.calculoLoteImpressaoItemRepository = calculoLoteImpressaoItemRepository;
        this.carneService = carneService;
        this.calculoCadastroService = calculoCadastroService;
        this.integracaoBoletoRegistradoReceiver = integracaoBoletoRegistradoReceiver;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoCarneService = debitoCarneService;
        this.entityManager = entityManager;
    }

    public List<CalculoLoteImpressaoItem> createLoteImpressaoItem(CalculoLoteImpressao calculoLoteImpressao, List<LoteItemDTO> loteItens) {
        ArrayList<CalculoLoteImpressaoItem> loteImpressaoItens = new ArrayList<CalculoLoteImpressaoItem>();
        AtomicLong ordem = new AtomicLong();
        loteItens.forEach(loteItem -> {
            CalculoLoteImpressaoItem loteImpressaoItem = new CalculoLoteImpressaoItem();
            loteImpressaoItem.setCalculoLoteImpressao(calculoLoteImpressao);
            loteImpressaoItem.setIdCalculoCadastro(loteItem.getIdCalculoCadastro());
            loteImpressaoItem.setOrdem(Long.valueOf(ordem.incrementAndGet()));
            loteImpressaoItens.add(loteImpressaoItem);
            this.calculoLoteImpressaoItemRepository.save((Object)loteImpressaoItem);
        });
        return loteImpressaoItens;
    }

    public Page<CalculoLoteImpressaoItemDTO> findByLoteImpressaoId(Long idLoteImpressao, String search, Pageable pageable) {
        String idClause = String.format("calculoLoteImpressao.id==%d", idLoteImpressao);
        String searchWithIdClause = StringUtils.isBlank((CharSequence)search) ? idClause : String.format("(%s) and (%s)", idClause, search);
        return this.findByRsql(searchWithIdClause, pageable).map(CalculoLoteImpressaoItemDTO::of);
    }

    public CalculoLoteImpressaoItem findItemById(Long id) {
        return (CalculoLoteImpressaoItem)this.calculoLoteImpressaoItemRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado item do lote de impress\u00e3o com id %d.", id)));
    }

    private void saveCarne(CalculoLoteImpressaoItem calculoLoteImpressaoItem, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos) {
        CalculoCadastro calculoCadastro = calculoLoteImpressaoItem.getCalculoCadastro();
        CarneDTO carneDTO = this.carneService.geraCarneCalculo(calculoCadastro, calculoLoteImpressaoItem.getCalculoLoteImpressao().getOrdem(), parametrosAcrescimos);
        calculoCadastro.vincularCarne(carneDTO);
        this.calculoCadastroService.save((EloEntity)calculoCadastro, null);
    }

    public CalculoLoteImpressaoItemDTO gerarCarneManual(Long id) {
        CalculoLoteImpressaoItem calculoLoteImpressaoItem = this.findItemById(id);
        CalculoCadastro calculoCadastro = calculoLoteImpressaoItem.getCalculoCadastro();
        this.validaGeracaoCarneManual(calculoCadastro);
        this.saveCarne(calculoLoteImpressaoItem, null);
        if (SituacaoGeracaoCarne.ERRO.equals((Object)calculoLoteImpressaoItem.getCalculoCadastro().getSituacaoCarne())) {
            throw new EloValidationException(String.format("Houve um erro na gera\u00e7\u00e3o do carn\u00ea: %s", calculoLoteImpressaoItem.getCalculoCadastro().getErroEmissaoBoleto()));
        }
        this.atualizaSituacaoCalculoCasoTodosCarnesGerados(calculoCadastro.getCalculo());
        return this.saveDebitoCarne(calculoLoteImpressaoItem);
    }

    public CalculoLoteImpressaoItemDTO gerarCarneBatch(Long id, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos) {
        CalculoLoteImpressaoItem calculoLoteImpressaoItem = this.findItemById(id);
        this.saveCarne(calculoLoteImpressaoItem, parametrosAcrescimos);
        return this.saveDebitoCarne(calculoLoteImpressaoItem);
    }

    public void alterarVencimentoParcelas(Long idCalculoLoteImpressaoItem, List<AlteracaoVencimentoParcelaDTO> parcelas, StepExecution stepExecution) {
        if (ListUtils.safeIsEmpty(parcelas).booleanValue()) {
            throw new EloValidationException("Nenhuma parcela para alterar");
        }
        CalculoLoteImpressaoItem calculoLoteImpressaoItem = Optional.ofNullable(this.findItemById(idCalculoLoteImpressaoItem)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado calculo lote impress\u00e3o item para o id %d.", idCalculoLoteImpressaoItem)));
        CalculoCadastro calculoCadastro = calculoLoteImpressaoItem.getCalculoCadastro();
        CarneId carneId = new CarneId(calculoCadastro.getEntidadeCarne(), calculoCadastro.getExercicioCarne(), calculoCadastro.getNumeroCarne());
        Carne carne = (Carne)this.carneService.findById((Serializable)carneId).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado o carn\u00ea com entidade %d, exerc\u00edcio %d e n\u00famero %d.", calculoCadastro.getEntidadeCarne(), calculoCadastro.getExercicioCarne(), calculoCadastro.getNumeroCarne())));
        Map boletosByParcelaSemCotaUnica = carne.getBoletos().stream().map(CarneBoleto::getBoleto).filter(b -> !b.isCotaUnica()).collect(Collectors.toMap(b -> ((BoletoDebito)b.getDebitos().stream().findFirst().orElseThrow(() -> new EloValidationException(String.format("Nenhum d\u00e9bito encontrado para o boleto %d.", b.getId())))).getId().getDebitoParcelaTributo().getParcela(), Function.identity()));
        for (AlteracaoVencimentoParcelaDTO dto : parcelas) {
            Bloqueto boletoAlterar = dto.getCotaUnica() != false ? (Bloqueto)carne.getBoletos().stream().map(CarneBoleto::getBoleto).filter(Bloqueto::isCotaUnica).findFirst().orElse(null) : (Bloqueto)boletosByParcelaSemCotaUnica.get(dto.getParcela());
            try {
                DebitoParcelaTributo debitoParcelaTributo = ((BoletoDebito)boletoAlterar.getDebitos().stream().findFirst().orElseThrow(() -> new EloValidationException(String.format("Nenhum d\u00e9bito encontrado para o boleto %d.", boletoAlterar.getId())))).getId().getDebitoParcelaTributo();
                if (!debitoParcelaTributo.getDebitoParcela().getSituacaoDebito().isAberto().booleanValue()) {
                    throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel alterar boleto para parcela n\u00e3o aberta. D\u00e9bito %d, Parcela %d.", debitoParcelaTributo.getIdDebito(), boletoAlterar.isCotaUnica() ? 0L : debitoParcelaTributo.getParcela()));
                }
                if (!Objects.nonNull(boletoAlterar)) continue;
                this.integracaoBoletoRegistradoReceiver.updateVencimentoBoleto(boletoAlterar, dto.getVencimento());
                if (boletoAlterar.isCotaUnica()) continue;
                this.debitoParcelaService.updateVencimentoParcela(debitoParcelaTributo.getIdDebito(), dto.getParcela(), dto.getVencimento());
            }
            catch (Exception e) {
                log.error(String.format("Erro ao alterar o vencimento do boleto %d, de %s para %s", boletoAlterar.getId(), boletoAlterar.getDataVencimento(), dto.getVencimento()), (Throwable)e);
                if (!Objects.nonNull(stepExecution)) continue;
                stepExecution.addFailureException((Throwable)e);
            }
        }
    }

    public List<AlteracaoVencimentoParcelaDTO> findParcelas(Long idCalculo) {
        if (Objects.isNull(idCalculo)) {
            throw new EloValidationException("\u00c9 necess\u00e1rio informar o c\u00e1lculo para pesquisar.");
        }
        CalculoCadastro calculoCadastro = (CalculoCadastro)this.calculoLoteImpressaoItemRepository.findAllCalculoCadastroInAnyLoteByCalculoId(idCalculo).stream().findFirst().orElseThrow(() -> new EloValidationException(String.format("Nenhum cadastro encontrado para o c\u00e1lculo %d.", idCalculo)));
        CarneId carneId = new CarneId(calculoCadastro.getEntidadeCarne(), calculoCadastro.getExercicioCarne(), calculoCadastro.getNumeroCarne());
        Carne carne = (Carne)this.carneService.findById((Serializable)carneId).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado o carn\u00ea com entidade %d, exerc\u00edcio %d e n\u00famero %d.", calculoCadastro.getEntidadeCarne(), calculoCadastro.getExercicioCarne(), calculoCadastro.getNumeroCarne())));
        return AlteracaoVencimentoParcelaDTO.of(carne.getBoletos().stream().map(CarneBoleto::getBoleto).collect(Collectors.toList()));
    }

    private void atualizaSituacaoCalculoCasoTodosCarnesGerados(Calculo calculo) {
        List cadastros = this.calculoLoteImpressaoItemRepository.findAllCalculoCadastroInAnyLoteByCalculoId(calculo.getId());
        if (cadastros.stream().allMatch(cadastro -> Objects.nonNull(cadastro.getNumeroCarne()))) {
            calculo.setSituacao(SituacaoCalculo.CARNE_GERADO);
        }
    }

    private void validaGeracaoCarneManual(CalculoCadastro calculoCadastro) {
        this.validaSituacaoCalculo(calculoCadastro.getCalculo());
        this.validaFormasPagamento(calculoCadastro);
    }

    public void validaGeracaoCarneBatch(Calculo calculo) {
        this.validaSituacaoCalculo(calculo);
        this.validaFormasPagamentoTodasDividasDoCalculo(calculo);
    }

    private void validaSituacaoCalculo(Calculo calculo) {
        BatchStatus batchStatus;
        BatchStatus batchStatus2 = batchStatus = Objects.nonNull(calculo.getBatchJobExecutionCarne()) ? calculo.getBatchJobExecutionCarne().getStatus() : null;
        if (!SituacaoCalculo.LOTE_GERADO.equals((Object)calculo.getSituacao()) && !SituacaoCalculo.ERRO_GERACAO_CARNE.equals((Object)calculo.getSituacao())) {
            if (SituacaoCalculo.GERANDO_CARNE.equals((Object)calculo.getSituacao()) && !BatchStatus.FAILED.equals((Object)batchStatus)) {
                throw new CalculoException(String.format("Os carn\u00eas do c\u00e1lculo %d j\u00e1 est\u00e3o sendo gerados. Por favor aguarde ou tente novamente.", calculo.getId()));
            }
            if (!SituacaoCalculo.GERANDO_CARNE.equals((Object)calculo.getSituacao())) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar carn\u00eas para c\u00e1lculo com situa\u00e7\u00e3o %s.", calculo.getSituacao().getDescricao()));
            }
        }
    }

    private void validaFormasPagamento(CalculoCadastro calculoCadastro) {
        List formasPagamento = calculoCadastro.getCalculo().getFormasPagamento();
        if (formasPagamento.stream().noneMatch(formaPagamento -> formaPagamento.getDividaFormaPagamento().getDivida().equals((Object)calculoCadastro.getDivida()))) {
            throw new EloValidationException(String.format("Forma de pagamento n\u00e3o configurada para d\u00edvida %d.", calculoCadastro.getDivida().getDivida()));
        }
    }

    private void validaFormasPagamentoTodasDividasDoCalculo(Calculo calculo) {
        List dividasSemFormaDePagamento = calculo.getDividas().stream().filter(divida -> calculo.getFormasPagamento().stream().noneMatch(formaPagamento -> formaPagamento.getDividaFormaPagamento().getDivida().equals(divida))).collect(Collectors.toList());
        if (!dividasSemFormaDePagamento.isEmpty()) {
            throw new EloValidationException(String.format("\u00c9 necess\u00e1rio configurar pelo menos uma forma de pagamento para as seguintes d\u00edvidas %s.", dividasSemFormaDePagamento.stream().map(divida -> String.format("\"%d - %s\"", divida.getDivida(), divida.getDescricao())).collect(Collectors.joining(", "))));
        }
    }

    public void deleteCarne(Long id) {
        CalculoLoteImpressaoItem calculoLoteImpressaoItem = this.findItemById(id);
        CalculoCadastro calculoCadastro = calculoLoteImpressaoItem.getCalculoCadastro();
        this.carneService.deleteCarne(calculoCadastro.getEntidadeCarne(), calculoCadastro.getExercicioCarne(), calculoCadastro.getNumeroCarne());
        calculoCadastro.limparCarne();
        this.calculoCadastroService.save((EloEntity)calculoCadastro, null);
    }

    private CalculoLoteImpressaoItemDTO saveDebitoCarne(CalculoLoteImpressaoItem calculoLoteImpressaoItem) {
        CalculoLoteImpressaoItemDTO calculoLoteImpressao = CalculoLoteImpressaoItemDTO.of((CalculoLoteImpressaoItem)calculoLoteImpressaoItem);
        try {
            Carne carne = (Carne)this.entityManager.getReference(Carne.class, (Object)new CarneId(calculoLoteImpressao.getEntidadeCarne(), calculoLoteImpressao.getExercicioCarne(), calculoLoteImpressao.getCarne()));
            if (Objects.nonNull(carne)) {
                DebitoCarne debitoCarne = new DebitoCarne();
                debitoCarne.setId(calculoLoteImpressao.getIdDebito());
                debitoCarne.setCarne(carne);
                debitoCarne.setFormaPagamento(this.getFormaPagamento(carne));
                this.debitoCarneService.save((EloEntity)debitoCarne, null);
            }
        }
        catch (Exception e) {
            log.error("Erro ao salvar d\u00e9bito do carne", (Throwable)e);
        }
        return calculoLoteImpressao;
    }

    private Long getFormaPagamento(Carne carne) {
        List formasDiferentes = carne.getBoletos().stream().map(CarneBoleto::getBoleto).filter(Objects::nonNull).map(Bloqueto::getFormaPagamento).distinct().collect(Collectors.toList());
        return formasDiferentes.size() != 1 ? null : (Long)formasDiferentes.get(0);
    }
}

