/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.sanepar.importacao;

import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.batch.sanepar.importacao.ImportacaoSaneparReader;
import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.enums.sanepar.TipoBaixaSanepar;
import br.com.elotech.tributos.service.resolvers.arquivoclient.ArquivoClientMinioResolver;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.BeanWrapperFieldSetMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.FixedLengthTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImportacaoSaneparReader
extends FlatFileItemReader<BaixaSaneparItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoSaneparReader.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");

    public ImportacaoSaneparReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, ArquivoStorageFeignClient arquivoStorageFeignClient, ArquivoClientMinioResolver arquivoClientMinioResolver) {
        Long idArquivo = (Long)jobParameters.get("idArquivo");
        TipoBaixaSanepar tipoBaixa = TipoBaixaSanepar.fromValue((String)((String)jobParameters.get("tipoBaixa")));
        this.setResource((Resource)new InputStreamResource(this.getFileStream(idArquivo, arquivoClientMinioResolver, arquivoStorageFeignClient)));
        this.setLineMapper((LineMapper)this.buildLineMapper(tipoBaixa));
    }

    private InputStream getFileStream(Long idArquivo, ArquivoClientMinioResolver minioResolver, ArquivoStorageFeignClient feignClient) {
        ArquivoDTO arquivoDto = feignClient.findOne(idArquivo);
        log.debug("Buscando url de download do arquivo");
        ArquivoFindRequest arquivoFindRequest = ArquivoFindRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getTenantId().orElse("")), (String)arquivoDto.getFullPath());
        return minioResolver.getArquivoClient().buscarArquivo(arquivoFindRequest).map(ArquivoContent::getContent).orElseThrow(() -> new EloValidationException("Erro ao baixar o arquivo"));
    }

    private FixedLengthTokenizer arquivoArrecadacaoTokenizer() {
        FixedLengthTokenizer fixedLengthTokenizer = new FixedLengthTokenizer();
        fixedLengthTokenizer.setNames(new String[]{"matricula", "nome", "doctipo", "docNumero", "logradouro", "numeroImovel", "categoria", "economiaAguaResidencial", "economiaAguaComercial", "economiaAguaIndustrial", "economiaAguaUtilidadePublica", "economiaAguaPoderPublico", "economiaEsgotoResidencial", "economiaEsgotoComercial", "economiaEsgotoIndustrial", "economiaEsgotoUtilidadePublica", "economiaEsgotoPoderPublico", "referencia", "digito", "codigoServico", "valor", "dataPagamento", "classeLixo"});
        fixedLengthTokenizer.setColumns(new Range[]{new Range(8, 15), new Range(16, 55), new Range(56, 56), new Range(57, 70), new Range(90, 119), new Range(120, 124), new Range(125, 127), new Range(128, 130), new Range(131, 133), new Range(134, 136), new Range(137, 139), new Range(140, 142), new Range(143, 145), new Range(146, 148), new Range(149, 151), new Range(152, 154), new Range(155, 157), new Range(158, 163), new Range(164, 164), new Range(165, 168), new Range(169, 181), new Range(182, 189), new Range(190, 190)});
        fixedLengthTokenizer.setStrict(Boolean.FALSE.booleanValue());
        return fixedLengthTokenizer;
    }

    private FixedLengthTokenizer arquivoMultaTokenizer() {
        FixedLengthTokenizer fixedLengthTokenizer = new FixedLengthTokenizer();
        fixedLengthTokenizer.setNames(new String[]{"matricula", "nome", "doctipo", "docNumero", "logradouro", "numeroImovel", "categoria", "economiaAguaResidencial", "economiaAguaComercial", "economiaAguaIndustrial", "economiaAguaUtilidadePublica", "economiaAguaPoderPublico", "economiaEsgotoResidencial", "economiaEsgotoComercial", "economiaEsgotoIndustrial", "economiaEsgotoUtilidadePublica", "economiaEsgotoPoderPublico", "referencia", "referenciaMulta", "codigoServico", "valor", "dataPagamento", "classeLixo"});
        fixedLengthTokenizer.setColumns(new Range[]{new Range(8, 15), new Range(16, 55), new Range(56, 56), new Range(57, 70), new Range(90, 119), new Range(120, 124), new Range(125, 127), new Range(128, 130), new Range(131, 133), new Range(134, 136), new Range(137, 139), new Range(140, 142), new Range(143, 145), new Range(146, 148), new Range(149, 151), new Range(152, 154), new Range(155, 157), new Range(158, 163), new Range(164, 169), new Range(170, 173), new Range(174, 186), new Range(187, 194), new Range(195, 195)});
        fixedLengthTokenizer.setStrict(Boolean.FALSE.booleanValue());
        return fixedLengthTokenizer;
    }

    private BaixaSaneparItemMapper buildLineMapper(TipoBaixaSanepar tipoBaixa) {
        BaixaSaneparItemMapper lineMapper = new BaixaSaneparItemMapper();
        BeanWrapperFieldSetMapper fieldSetMapper = new BeanWrapperFieldSetMapper();
        fieldSetMapper.setTargetType(BaixaSaneparItem.class);
        fieldSetMapper.setConversionService(this.createConversionService());
        FixedLengthTokenizer tokenizer = TipoBaixaSanepar.ARRECADACAO.equals((Object)tipoBaixa) ? this.arquivoArrecadacaoTokenizer() : this.arquivoMultaTokenizer();
        lineMapper.setLineTokenizer((LineTokenizer)tokenizer);
        lineMapper.setFieldSetMapper((FieldSetMapper)fieldSetMapper);
        return lineMapper;
    }

    private ConversionService createConversionService() {
        DefaultConversionService defaultConversionService = new DefaultConversionService();
        defaultConversionService.addConverter(this.buildLocalDateConverter());
        defaultConversionService.addConverter(this.buildBigDecimalConverter());
        return defaultConversionService;
    }

    private Converter<String, LocalDate> buildLocalDateConverter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Converter<String, BigDecimal> buildBigDecimalConverter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

