/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class EnvioProtestoRemessaJobListener
extends JobExecutionListenerSupport {
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        super.beforeJob(jobExecution);
        String dataInicio = LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        Optional notificacaoId = this.notificacaoService.send("Protesto - Iniciado Envio de Remessa para o CRA", String.format("Iniciado o processo para o envio da remessa de protestos para o CRA - %s", dataInicio), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        super.afterJob(jobExecution);
        String dataFim = LocalDate.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Protesto - Sucesso ao Enviar de Remessa para o CRA", String.format("Finalizado com sucesso o envio da remessa de protestos para o CRA - %s", dataFim), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Protesto - Erro ao Enviar de Remessa para o CRA", String.format("Ocorreu algum erro no envio da remessa de protestos para o CRA - %s", dataFim), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public EnvioProtestoRemessaJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

